/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import nintaco.util.GuiUtil;

public class ComboBoxDialog
extends JDialog {
    private boolean ok;
    private String input;
    private int inputIndex;
    private JButton cancelButton;
    private JLabel iconLabel;
    private JComboBox inputComboBox;
    private JPanel inputPanel;
    private JButton okButton;
    private JLabel promptLabel;
    private JPanel spacerPanel;

    public ComboBoxDialog(Window parent, String message, String title) {
        this(parent, message, title, null);
    }

    public ComboBoxDialog(Window parent, String message, String title, List<String> items) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        GuiUtil.scaleFonts(this);
        this.setPrompt(message, title, items);
    }

    public final void setPrompt(String message, String title) {
        this.setPrompt(message, title, null);
    }

    public final void setPrompt(String message, String title, List<String> items) {
        if (!message.toLowerCase().trim().startsWith("<html>")) {
            message = "<html>" + message + "</html>";
        }
        this.setTitle(title);
        this.promptLabel.setText(message);
        this.iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        if (items != null) {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            for (String item : items) {
                model.addElement(item);
            }
            this.inputComboBox.setModel(model);
            this.inputComboBox.setSelectedItem("");
        }
        this.inputComboBox.requestFocus();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void setOkButtonText(String text) {
        this.okButton.setText(text);
    }

    public void setOkButtonMnemonic(char mnemonic) {
        this.okButton.setMnemonic(mnemonic);
    }

    public void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }

    public void setCancelButtonMnemonic(char mnemonic) {
        this.cancelButton.setMnemonic(mnemonic);
    }

    public String getInput() {
        return this.input;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public boolean isOk() {
        return this.ok;
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.inputPanel = new JPanel();
        this.promptLabel = new JLabel();
        this.inputComboBox = new JComboBox();
        this.iconLabel = new JLabel();
        this.spacerPanel = new JPanel();
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ComboBoxDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("   Cancel   ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComboBoxDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComboBoxDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.promptLabel.setText(" ");
        this.inputComboBox.setFocusable(false);
        this.inputComboBox.setMaximumSize(null);
        this.inputComboBox.setMinimumSize(null);
        this.inputComboBox.setPreferredSize(null);
        GroupLayout inputPanelLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(inputPanelLayout);
        inputPanelLayout.setHorizontalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, inputPanelLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addComponent(this.promptLabel, -1, -1, Short.MAX_VALUE).addGap(1, 1, 1)).addGroup(inputPanelLayout.createSequentialGroup().addComponent(this.inputComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)))));
        inputPanelLayout.setVerticalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addComponent(this.promptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputComboBox, -2, -1, -2).addGap(15, 15, 15)));
        this.iconLabel.setText(" ");
        this.spacerPanel.setMaximumSize(null);
        GroupLayout spacerPanelLayout = new GroupLayout(this.spacerPanel);
        this.spacerPanel.setLayout(spacerPanelLayout);
        spacerPanelLayout.setHorizontalGroup(spacerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        spacerPanelLayout.setVerticalGroup(spacerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.spacerPanel, -2, -1, -2).addComponent(this.iconLabel, -2, 50, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addGap(15, 15, 15)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.linkSize(0, this.iconLabel, this.spacerPanel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputPanel, -2, -1, -2).addComponent(this.iconLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton))).addComponent(this.spacerPanel, -1, -1, Short.MAX_VALUE)).addGap(15, 15, 15)));
        layout.linkSize(1, this.iconLabel, this.inputPanel);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.inputIndex = this.inputComboBox.getSelectedIndex();
        Object item = this.inputComboBox.getSelectedItem();
        this.input = item == null ? "" : item.toString();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }
}

