/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    public final int IMAGE_WIDTH;
    public final int IMAGE_HEIGHT;
    private final Dimension preferredSize;
    private final BufferedImage buffer;
    private final int[] screen;
    private final List<MouseMotionProxy> mouseMotionProxies = new ArrayList<MouseMotionProxy>();
    private final List<MouseProxy> mouseProxies = new ArrayList<MouseProxy>();
    private volatile int imageX;
    private volatile int imageY;
    private volatile int imageWidth;
    private volatile int imageHeight;
    private volatile int paneWidth;
    private volatile int paneHeight;
    private volatile boolean barsOnSides;
    private MouseEvent lastMouseEvent;
    private boolean blackBars;
    private boolean centered = true;
    private boolean minimalSizeIsPreferredSize;

    public ImagePanel(int width, int height) {
        this(width, height, width, height);
    }

    public ImagePanel(int width, int height, int scale) {
        this(width, height, scale * width, scale * height);
    }

    public ImagePanel(int width, int height, int preferredWidth, int preferredHeight) {
        this.IMAGE_WIDTH = width;
        this.IMAGE_HEIGHT = height;
        this.preferredSize = new Dimension(preferredWidth, preferredHeight);
        this.buffer = new BufferedImage(width, height, 1);
        this.screen = ((DataBufferInt)this.buffer.getRaster().getDataBuffer()).getData();
        this.setDoubleBuffered(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImagePanel.this.paneResized();
            }
        });
        super.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ImagePanel.this.mouseUpdated(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                ImagePanel.this.mouseUpdated(e);
            }
        });
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                ImagePanel.this.fireMouseExited(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ImagePanel.this.mouseUpdated(e);
            }
        });
    }

    private void mouseUpdated(MouseEvent e) {
        MouseEvent mouseEvent = this.adjustMouseEvent(e);
        if (this.lastMouseEvent == null && mouseEvent != null) {
            this.fireMouseEntered(mouseEvent);
        } else if (this.lastMouseEvent != null && mouseEvent == null) {
            this.fireMouseExited(this.lastMouseEvent);
        }
        this.lastMouseEvent = mouseEvent;
    }

    private void fireMouseEntered(MouseEvent e) {
        for (MouseProxy proxy : this.mouseProxies) {
            proxy.getMouseListener().mouseEntered(e);
        }
    }

    private void fireMouseExited(MouseEvent e) {
        for (MouseProxy proxy : this.mouseProxies) {
            proxy.getMouseListener().mouseExited(e);
        }
    }

    private MouseEvent adjustMouseEvent(MouseEvent e) {
        int imgX = this.centered ? this.imageX : 0;
        int imgY = this.centered ? this.imageY : 0;
        int x = e.getX();
        int y = e.getY();
        if (x >= imgX && y >= imgY && x < imgX + this.imageWidth && y < imgY + this.imageHeight) {
            x = (x - imgX) * this.IMAGE_WIDTH / this.imageWidth;
            y = (y - imgY) * this.IMAGE_HEIGHT / this.imageHeight;
            return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), x, y, 0, 0, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }
        return null;
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        MouseMotionProxy proxy = new MouseMotionProxy(listener);
        this.mouseMotionProxies.add(proxy);
        super.addMouseMotionListener(proxy);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener listener) {
        for (int i = this.mouseMotionProxies.size() - 1; i >= 0; --i) {
            MouseMotionProxy proxy = this.mouseMotionProxies.get(i);
            if (!proxy.getMouseMotionListener().equals(listener)) continue;
            super.removeMouseMotionListener(proxy);
            this.mouseMotionProxies.remove(i);
        }
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        MouseProxy proxy = new MouseProxy(listener);
        this.mouseProxies.add(proxy);
        super.addMouseListener(proxy);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        for (int i = this.mouseProxies.size() - 1; i >= 0; --i) {
            MouseProxy proxy = this.mouseProxies.get(i);
            if (!proxy.getMouseListener().equals(listener)) continue;
            super.removeMouseListener(proxy);
            this.mouseProxies.remove(i);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimalSizeIsPreferredSize ? this.getPreferredSize() : super.getMinimumSize();
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
    }

    @Override
    public void setMaximumSize(Dimension maximumSize) {
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public boolean isMinimalSizeIsPreferredSize() {
        return this.minimalSizeIsPreferredSize;
    }

    public void setMinimalSizeIsPreferredSize(boolean minimalSizeIsPreferredSize) {
        this.minimalSizeIsPreferredSize = minimalSizeIsPreferredSize;
    }

    public boolean isBlackBars() {
        return this.blackBars;
    }

    public void setBlackBars(boolean blackBars) {
        this.blackBars = blackBars;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public int[] getScreen() {
        return this.screen;
    }

    public void clearScreen() {
        Arrays.fill(this.screen, 0);
        EventQueue.invokeLater(this::repaint);
    }

    public void render() {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.render(g, this.buffer);
            g.dispose();
        }
    }

    private void paneResized() {
        this.paneWidth = this.getWidth();
        this.paneHeight = this.getHeight();
        if (this.IMAGE_HEIGHT * this.paneWidth >= this.IMAGE_WIDTH * this.paneHeight) {
            this.barsOnSides = true;
            this.imageHeight = this.paneHeight;
            this.imageY = 0;
            this.imageWidth = this.imageHeight * this.IMAGE_WIDTH / this.IMAGE_HEIGHT;
            this.imageX = (this.paneWidth - this.imageWidth) / 2;
        } else {
            this.barsOnSides = false;
            this.imageWidth = this.paneWidth;
            this.imageHeight = this.imageWidth * this.IMAGE_HEIGHT / this.IMAGE_WIDTH;
            this.imageY = (this.paneHeight - this.imageHeight) / 2;
            this.imageX = 0;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paneResized();
        super.paintComponent(g);
        this.render(g, this.buffer);
    }

    private void render(Graphics g, BufferedImage buffer) {
        if (this.centered) {
            if (this.blackBars) {
                g.setColor(Color.BLACK);
                if (this.barsOnSides) {
                    g.fillRect(0, 0, this.imageX, this.paneHeight);
                    g.fillRect(this.imageX + this.imageWidth, 0, this.paneWidth - (this.imageX + this.imageWidth), this.paneHeight);
                } else {
                    g.fillRect(0, 0, this.paneWidth, this.imageY);
                    g.fillRect(0, this.imageY + this.imageHeight, this.paneWidth, this.paneHeight - (this.imageY + this.imageHeight));
                }
            }
            g.drawImage(buffer, this.imageX, this.imageY, this.imageWidth, this.imageHeight, null);
        } else {
            if (this.blackBars) {
                g.setColor(Color.BLACK);
                if (this.barsOnSides) {
                    g.fillRect(this.imageWidth, 0, this.paneWidth - this.imageWidth, this.paneHeight);
                } else {
                    g.fillRect(0, this.imageHeight, this.paneWidth, this.paneHeight - this.imageHeight);
                }
            }
            g.drawImage(buffer, 0, 0, this.imageWidth, this.imageHeight, null);
        }
    }

    private class MouseProxy
    implements MouseListener {
        private final MouseListener listener;

        public MouseProxy(MouseListener listener) {
            this.listener = listener;
        }

        public MouseListener getMouseListener() {
            return this.listener;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MouseEvent event = ImagePanel.this.adjustMouseEvent(e);
            if (event != null) {
                this.listener.mouseClicked(event);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MouseEvent event = ImagePanel.this.adjustMouseEvent(e);
            if (event != null) {
                this.listener.mousePressed(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MouseEvent event = ImagePanel.this.adjustMouseEvent(e);
            if (event != null) {
                this.listener.mouseReleased(event);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MouseEvent event = ImagePanel.this.adjustMouseEvent(e);
            if (event != null) {
                this.listener.mouseEntered(event);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MouseEvent event = ImagePanel.this.adjustMouseEvent(e);
            if (event != null) {
                this.listener.mouseExited(event);
            }
        }
    }

    private class MouseMotionProxy
    implements MouseMotionListener {
        private final MouseMotionListener listener;

        public MouseMotionProxy(MouseMotionListener listener) {
            this.listener = listener;
        }

        public MouseMotionListener getMouseMotionListener() {
            return this.listener;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MouseEvent event = ImagePanel.this.adjustMouseEvent(e);
            if (event != null) {
                this.listener.mouseDragged(event);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            MouseEvent event = ImagePanel.this.adjustMouseEvent(e);
            if (event != null) {
                this.listener.mouseMoved(event);
            }
        }
    }
}

