/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import nintaco.util.GuiUtil;

public class PasswordDialog
extends JDialog {
    private boolean ok;
    private boolean rememberPassword;
    private char[] password;
    private boolean textRequired;
    private DocumentListener documentListener;
    private JButton cancelButton;
    private JLabel iconLabel;
    private JPanel inputPanel;
    private JButton okButton;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel promptLabel;
    private JPanel spacerPanel;

    public PasswordDialog(Window parent, String message, String title) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initDocumentListener();
        this.getRootPane().setDefaultButton(this.okButton);
        GuiUtil.scaleFonts(this);
        this.setPrompt(message, title);
    }

    private void initDocumentListener() {
        this.documentListener = GuiUtil.createDocumentListener(this::enableComponents);
        this.passwordField.getDocument().addDocumentListener(this.documentListener);
    }

    @Override
    public void setVisible(boolean visible) {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        super.setVisible(visible);
    }

    public void setPassword(int passwordLength) {
        StringBuilder sb = new StringBuilder();
        for (int i = passwordLength - 1; i >= 0; --i) {
            sb.append('*');
        }
        this.setPassword(sb.toString());
    }

    public void setPassword(String password) {
        if (password == null) {
            return;
        }
        this.passwordField.getDocument().removeDocumentListener(this.documentListener);
        this.passwordField.setText(password);
        this.passwordField.getDocument().addDocumentListener(this.documentListener);
        this.passwordField.selectAll();
        this.enableComponents();
        this.passwordField.requestFocus();
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.passwordCheckBox.setSelected(rememberPassword);
    }

    private void enableComponents() {
        this.okButton.setEnabled(!this.textRequired || this.passwordField.getPassword().length > 0);
    }

    public void setPasswordRequired() {
        this.textRequired = true;
        this.enableComponents();
    }

    public final void setPrompt(String message, String title) {
        if (!message.toLowerCase().trim().startsWith("<html>")) {
            message = "<html>" + message + "</html>";
        }
        this.setTitle(title);
        this.promptLabel.setText(message);
        this.iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        this.passwordField.requestFocus();
    }

    public void setOkButtonMnemonic(char mnemonic) {
        this.okButton.setMnemonic(mnemonic);
    }

    public void setOkButtonText(String text) {
        this.okButton.setText(text);
    }

    public void setCancelButtonMnemonic(char mnemonic) {
        this.cancelButton.setMnemonic(mnemonic);
    }

    public void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }

    public char[] getPassword() {
        return this.password;
    }

    public boolean isOk() {
        return this.ok;
    }

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.inputPanel = new JPanel();
        this.promptLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.passwordCheckBox = new JCheckBox();
        this.iconLabel = new JLabel();
        this.spacerPanel = new JPanel();
        this.setDefaultCloseOperation(0);
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PasswordDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setLabel("   Cancel   ");
        this.cancelButton.setMaximumSize(null);
        this.cancelButton.setMinimumSize(null);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(null);
        this.okButton.setMinimumSize(null);
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.promptLabel.setText(" ");
        this.passwordField.setColumns(16);
        this.passwordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordDialog.this.passwordFieldActionPerformed(evt);
            }
        });
        this.passwordCheckBox.setText("Remember password");
        GroupLayout inputPanelLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(inputPanelLayout);
        inputPanelLayout.setHorizontalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addComponent(this.passwordCheckBox).addContainerGap(-1, Short.MAX_VALUE)).addGroup(inputPanelLayout.createSequentialGroup().addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.passwordField).addComponent(this.promptLabel, -1, -1, Short.MAX_VALUE)).addGap(1, 1, 1)))));
        inputPanelLayout.setVerticalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.promptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.passwordCheckBox).addContainerGap()));
        this.iconLabel.setText(" ");
        this.spacerPanel.setMaximumSize(null);
        GroupLayout spacerPanelLayout = new GroupLayout(this.spacerPanel);
        this.spacerPanel.setLayout(spacerPanelLayout);
        spacerPanelLayout.setHorizontalGroup(spacerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        spacerPanelLayout.setVerticalGroup(spacerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.spacerPanel, -2, -1, -2).addComponent(this.iconLabel, -2, 50, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2))).addGap(15, 15, 15)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.linkSize(0, this.iconLabel, this.spacerPanel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel).addComponent(this.inputPanel, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2))).addComponent(this.spacerPanel, -1, -1, Short.MAX_VALUE)).addGap(15, 15, 15)));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.password = this.passwordField.getPassword();
        this.rememberPassword = this.passwordCheckBox.isSelected();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void passwordFieldActionPerformed(ActionEvent evt) {
        if (this.okButton.isEnabled()) {
            this.okButton.doClick();
        }
    }
}

