/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import nintaco.gui.IntPoint;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class TextDialog
extends JDialog {
    private JButton okButton;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public TextDialog(Window parent, String text, String title) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.setTitle(title);
        this.getRootPane().setDefaultButton(this.okButton);
        this.textArea.setFont(new Font("Monospaced", 0, this.textArea.getFont().getSize()));
        GuiUtil.scaleFonts(this);
        IntPoint dimensions = StringUtil.getTextDimensions(text);
        this.textArea.setColumns(Math.min(dimensions.x, 160) + 1);
        this.textArea.setRows(Math.min(dimensions.y, 32));
        this.textArea.setText(text);
        this.textArea.setCaretPosition(0);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TextDialog.this.formWindowClosing(evt);
            }
        });
        this.okButton.setFocusPainted(false);
        this.okButton.setLabel("   OK   ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.scrollPane.setPreferredSize(null);
        this.textArea.setEditable(false);
        this.textArea.setColumns(60);
        this.textArea.setRows(32);
        this.textArea.setPreferredSize(null);
        this.scrollPane.setViewportView(this.textArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }
}

