/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.api.server;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentListener;
import nintaco.App;
import nintaco.gui.LocalIPAddressRenderer;
import nintaco.gui.api.server.ProgramServerPrefs;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;
import nintaco.util.NetworkUtil;
import nintaco.util.StringUtil;

public class ProgramServerFrame
extends JFrame {
    private static final Color GREEN = new Color(32768);
    private DocumentListener portListener;
    private JLabel activityLabel;
    private JScrollPane activityScrollPane;
    private JTextArea activityTextArea;
    private JButton clearActivityButton;
    private JButton hideWindowButton;
    private JComboBox localIPComboBox;
    private JLabel localIPLabel;
    private JLabel portLabel;
    private JTextField portTextField;
    private JCheckBox runInBackgroundCheckBox;
    private JToggleButton startServerButton;
    private JLabel statusLabel;

    public ProgramServerFrame() {
        this.initComponents();
        this.initLocalIPComboBox();
        this.initTextFields();
        this.loadFields();
        this.setServerStatus(false);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void initLocalIPComboBox() {
        this.localIPComboBox.setRenderer(new LocalIPAddressRenderer());
        List<InetAddress> localIPAddresses = NetworkUtil.sortAddresses(NetworkUtil.getNetworkInterfaces());
        localIPAddresses.add(0, null);
        this.localIPComboBox.setModel(new DefaultComboBoxModel<InetAddress>(NetworkUtil.toArray(localIPAddresses)));
    }

    private void initTextFields() {
        this.portListener = GuiUtil.createDocumentListener(this::enableComponents);
        this.portTextField.getDocument().addDocumentListener(this.portListener);
        GuiUtil.makeMonospaced(this.activityTextArea);
        this.activityTextArea.setCursor(new Cursor(2));
        GuiUtil.enableAutoscroll(this.activityTextArea);
    }

    private void setPort(int port) {
        this.setPort(Integer.toString(port));
    }

    private void setPort(String port) {
        this.portTextField.getDocument().removeDocumentListener(this.portListener);
        this.portTextField.setText(port);
        this.portTextField.getDocument().addDocumentListener(this.portListener);
    }

    private void loadFields() {
        ProgramServerPrefs prefs = AppPrefs.getInstance().getProgramServerPrefs();
        this.localIPComboBox.setSelectedItem(prefs.getLocalIPAddress());
        this.setPort(prefs.getPort());
        this.runInBackgroundCheckBox.setSelected(prefs.isRunInBackground());
    }

    private void saveFields() {
        ProgramServerPrefs prefs = AppPrefs.getInstance().getProgramServerPrefs();
        prefs.setLocalIPAddress((InetAddress)this.localIPComboBox.getSelectedItem());
        prefs.setPort(StringUtil.parseInt(this.portTextField.getText(), 9999));
        prefs.setRunInBackground(this.runInBackgroundCheckBox.isSelected());
        AppPrefs.save();
    }

    public void enableComponents() {
        boolean serverDown = !this.startServerButton.isSelected();
        this.localIPLabel.setEnabled(serverDown);
        this.localIPComboBox.setEnabled(serverDown);
        this.portLabel.setEnabled(serverDown);
        this.portTextField.setEnabled(serverDown);
        this.runInBackgroundCheckBox.setEnabled(serverDown);
        this.startServerButton.setEnabled(!serverDown || StringUtil.parseInt(this.portTextField.getText(), -1) >= 0);
        this.startServerButton.setText((serverDown ? "Start" : "Stop") + " Server");
    }

    public void destroy() {
        this.saveFields();
        this.dispose();
    }

    private void closeFrame() {
        if (this.startServerButton.isSelected()) {
            this.setVisible(false);
        } else {
            App.destroyProgramServerFrame();
        }
    }

    public void addActivity(String activity, Object ... params) {
        if (EventQueue.isDispatchThread()) {
            this.activityTextArea.append(String.format(activity, params) + "\n");
        } else {
            EventQueue.invokeLater(() -> this.addActivity(activity, params));
        }
    }

    public void setServerStatus(boolean serverUp) {
        if (EventQueue.isDispatchThread()) {
            this.startServerButton.setSelected(serverUp);
            if (serverUp) {
                this.statusLabel.setBackground(GREEN);
                this.statusLabel.setText("<html><b>RUNNING</b></html>");
            } else {
                this.statusLabel.setBackground(Color.RED);
                this.statusLabel.setText("<html><b>DOWN</b></html>");
            }
            this.enableComponents();
        } else {
            EventQueue.invokeLater(() -> this.setServerStatus(serverUp));
        }
    }

    private void initComponents() {
        this.localIPLabel = new JLabel();
        this.localIPComboBox = new JComboBox();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.activityLabel = new JLabel();
        this.activityScrollPane = new JScrollPane();
        this.activityTextArea = new JTextArea();
        this.statusLabel = new JLabel();
        this.startServerButton = new JToggleButton();
        this.clearActivityButton = new JButton();
        this.hideWindowButton = new JButton();
        this.runInBackgroundCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Start Program Server");
        this.setMaximumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgramServerFrame.this.formWindowClosing(evt);
            }
        });
        this.localIPLabel.setText("Local IP address:");
        this.localIPComboBox.setFocusable(false);
        this.portLabel.setText("Port:");
        this.portTextField.setColumns(6);
        this.activityLabel.setText("Activity");
        this.activityScrollPane.setVerticalScrollBarPolicy(22);
        this.activityScrollPane.setMaximumSize(null);
        this.activityScrollPane.setMinimumSize(null);
        this.activityScrollPane.setPreferredSize(null);
        this.activityTextArea.setEditable(false);
        this.activityTextArea.setColumns(60);
        this.activityTextArea.setRows(8);
        this.activityTextArea.setMaximumSize(null);
        this.activityTextArea.setMinimumSize(null);
        this.activityTextArea.setPreferredSize(null);
        this.activityScrollPane.setViewportView(this.activityTextArea);
        this.statusLabel.setForeground(Color.white);
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setText(" ");
        this.statusLabel.setBorder(new SoftBevelBorder(1));
        this.statusLabel.setMaximumSize(null);
        this.statusLabel.setMinimumSize(null);
        this.statusLabel.setOpaque(true);
        this.statusLabel.setPreferredSize(null);
        this.startServerButton.setMnemonic('S');
        this.startServerButton.setText("Start Server");
        this.startServerButton.setFocusPainted(false);
        this.startServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramServerFrame.this.startServerButtonActionPerformed(evt);
            }
        });
        this.clearActivityButton.setMnemonic('A');
        this.clearActivityButton.setText("Clear Activity");
        this.clearActivityButton.setFocusPainted(false);
        this.clearActivityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramServerFrame.this.clearActivityButtonActionPerformed(evt);
            }
        });
        this.hideWindowButton.setMnemonic('H');
        this.hideWindowButton.setText("Hide Window");
        this.hideWindowButton.setFocusPainted(false);
        this.hideWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramServerFrame.this.hideWindowButtonActionPerformed(evt);
            }
        });
        this.runInBackgroundCheckBox.setText("Continue emulation when not in focus");
        this.runInBackgroundCheckBox.setFocusPainted(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.activityScrollPane, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.statusLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.startServerButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearActivityButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideWindowButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.localIPLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localIPComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.portLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portTextField, -2, -1, -2)).addComponent(this.activityLabel).addComponent(this.runInBackgroundCheckBox)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.clearActivityButton, this.hideWindowButton, this.startServerButton, this.statusLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localIPLabel).addComponent(this.localIPComboBox, -2, -1, -2).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.runInBackgroundCheckBox).addGap(18, 18, 18).addComponent(this.activityLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.activityScrollPane, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startServerButton).addComponent(this.hideWindowButton).addComponent(this.clearActivityButton).addComponent(this.statusLabel, -2, -1, -2)).addContainerGap()));
        layout.linkSize(1, this.clearActivityButton, this.hideWindowButton, this.startServerButton, this.statusLabel);
    }

    private void startServerButtonActionPerformed(ActionEvent evt) {
        if (this.startServerButton.isSelected()) {
            this.saveFields();
            this.setTitle("Program Server Controls");
            App.startProgramServer();
        } else {
            this.setTitle("Start Program Server");
            App.stopProgramServer();
        }
        this.enableComponents();
    }

    private void clearActivityButtonActionPerformed(ActionEvent evt) {
        this.activityTextArea.setText("");
    }

    private void hideWindowButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }
}

