/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.archive;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import nintaco.gui.archive.ArchiveOptionsDialog;
import nintaco.gui.archive.EntryElement;
import nintaco.gui.archive.SearchTask;
import nintaco.gui.archive.SearchTextField;
import nintaco.task.TaskScheduler;
import nintaco.util.GuiUtil;

public class ArchiveFileChooser
extends JDialog {
    private final TaskScheduler scheduler = new TaskScheduler();
    private List<String> entries;
    private String selectedFile;
    private JButton cancelButton;
    private JList<EntryElement> fileList;
    private JButton openButton;
    private JButton optionsButton;
    private JScrollPane scrollPane;
    private JTextField searchTextField;

    public ArchiveFileChooser(Window parent, List<String> entries, int defaultEntry) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.openButton);
        GuiUtil.scaleFonts(this);
        GuiUtil.addTextFieldEditListener(this.searchTextField, this::searchTextEdited);
        this.entries = entries;
        DefaultListModel<EntryElement> model = new DefaultListModel<EntryElement>();
        for (int i = 0; i < entries.size(); ++i) {
            String entry = entries.get(i);
            model.addElement(new EntryElement(entry, entry));
        }
        this.fileList.setModel(model);
        this.fileList.setVisibleRowCount(Math.min(25, entries.size()));
        if (defaultEntry < 0) {
            this.optionsButton.setVisible(false);
        } else if (defaultEntry < entries.size()) {
            this.fileList.setSelectedIndex(defaultEntry);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    private void searchTextEdited() {
        this.scheduler.cancelAll();
        this.scheduler.add(new SearchTask(this.fileList, this.entries, this.searchTextField.getText()));
    }

    private void cancelButtonPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.scheduler.dispose();
        this.dispose();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.fileList = new JList();
        this.cancelButton = new JButton();
        this.openButton = new JButton();
        this.searchTextField = new SearchTextField();
        this.optionsButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Select file from archive");
        this.setPreferredSize(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ArchiveFileChooser.this.formComponentShown(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ArchiveFileChooser.this.formWindowClosing(evt);
            }
        });
        this.scrollPane.setMaximumSize(null);
        this.scrollPane.setMinimumSize(null);
        this.scrollPane.setPreferredSize(null);
        this.fileList.setSelectionMode(0);
        this.fileList.setMaximumSize(null);
        this.fileList.setMinimumSize(null);
        this.fileList.setPreferredSize(null);
        this.fileList.setVisibleRowCount(16);
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ArchiveFileChooser.this.fileListMouseClicked(evt);
            }
        });
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ArchiveFileChooser.this.fileListValueChanged(evt);
            }
        });
        this.scrollPane.setViewportView(this.fileList);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setLabel("   Cancel   ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArchiveFileChooser.this.cancelButtonActionPerformed(evt);
            }
        });
        this.openButton.setMnemonic('O');
        this.openButton.setText("Open");
        this.openButton.setEnabled(false);
        this.openButton.setFocusPainted(false);
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArchiveFileChooser.this.openButtonActionPerformed(evt);
            }
        });
        this.searchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArchiveFileChooser.this.searchTextFieldActionPerformed(evt);
            }
        });
        this.optionsButton.setText("Options...");
        this.optionsButton.setFocusPainted(false);
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArchiveFileChooser.this.optionsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.optionsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 38, Short.MAX_VALUE).addComponent(this.openButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.searchTextField)).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.openButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.searchTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.openButton).addComponent(this.optionsButton)).addContainerGap()));
    }

    private void fileListValueChanged(ListSelectionEvent evt) {
        this.openButton.setEnabled(this.fileList.getSelectedValue() != null);
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        EntryElement element = this.fileList.getSelectedValue();
        if (element != null) {
            this.selectedFile = element.getEntry();
            this.closeDialog();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelButtonPressed();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonPressed();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.fileList.getSelectedIndex() >= 0) {
            this.fileList.requestFocusInWindow();
            EventQueue.invokeLater(() -> GuiUtil.scrollToCenter(this.fileList, this.fileList.getSelectedIndex()));
        } else {
            this.requestFocusInWindow();
        }
    }

    private void optionsButtonActionPerformed(ActionEvent evt) {
        new ArchiveOptionsDialog((Window)this).setVisible(true);
    }

    private void searchTextFieldActionPerformed(ActionEvent evt) {
        if (this.openButton.isEnabled()) {
            this.openButton.doClick();
        } else {
            this.requestFocusInWindow();
        }
    }

    private void fileListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            EntryElement element;
            int index = this.fileList.locationToIndex(evt.getPoint());
            ListModel<EntryElement> model = this.fileList.getModel();
            if (index >= 0 && index < this.fileList.getModel().getSize() && (element = model.getElementAt(index)) != null) {
                this.selectedFile = element.getEntry();
                this.closeDialog();
            }
        }
    }
}

