/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.archive;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import nintaco.gui.archive.ArchivePrefs;
import nintaco.gui.archive.EntryRegion;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;

public class ArchiveOptionsDialog
extends JDialog {
    private JButton cancelButton;
    private JCheckBox defaultFileCheckBox;
    private JButton okButton;
    private JComboBox<EntryRegion> regionComboBox;
    private JLabel regionLabel;

    public ArchiveOptionsDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void closeDialog() {
        this.dispose();
    }

    private void loadFields() {
        ArchivePrefs prefs = AppPrefs.getInstance().getArchivePrefs();
        this.regionComboBox.setSelectedItem((Object)prefs.getArchiveEntryRegion());
        this.defaultFileCheckBox.setSelected(prefs.isOpenDefaultArchiveEntry());
    }

    private void saveFields() {
        ArchivePrefs prefs = AppPrefs.getInstance().getArchivePrefs();
        prefs.setArchiveEntryRegion((EntryRegion)((Object)this.regionComboBox.getSelectedItem()));
        prefs.setOpenDefaultArchiveEntry(this.defaultFileCheckBox.isSelected());
        AppPrefs.save();
    }

    private void initComponents() {
        this.regionLabel = new JLabel();
        this.regionComboBox = new JComboBox<EntryRegion>(EntryRegion.values());
        this.defaultFileCheckBox = new JCheckBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Archive Options");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ArchiveOptionsDialog.this.formWindowClosing(evt);
            }
        });
        this.regionLabel.setText("Preferred region:");
        this.regionComboBox.setFocusable(false);
        this.defaultFileCheckBox.setText("Automatically open the default file");
        this.defaultFileCheckBox.setFocusPainted(false);
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArchiveOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArchiveOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultFileCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.regionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regionComboBox, -2, -1, -2))).addContainerGap(15, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.regionLabel).addComponent(this.regionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.defaultFileCheckBox).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addGap(15, 15, 15)));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveFields();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }
}

