/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.archive;

import java.awt.EventQueue;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import nintaco.gui.archive.EntryElement;
import nintaco.task.Task;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class SearchTask
extends Task {
    public static final int BOLD_THRESHOLD = 64;
    protected final JList<EntryElement> list;
    protected final List<String> entries;
    protected final String searchStr;

    public SearchTask(JList<EntryElement> list, List<String> entries, String searchStr) {
        this.list = list;
        this.entries = entries;
        this.searchStr = searchStr;
    }

    protected Pattern createPattern(String searchStr) {
        searchStr = searchStr.trim();
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < searchStr.length(); ++i) {
            char c = searchStr.charAt(i);
            if (Character.isWhitespace(c)) {
                sb.append("\\s");
                continue;
            }
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '-': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\').append(c);
                    continue block5;
                }
                case '*': {
                    sb.append(".*?");
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return Pattern.compile(sb.toString(), 2);
    }

    @Override
    public void loop() {
        DefaultListModel<EntryElement> model = new DefaultListModel<EntryElement>();
        if (StringUtil.isBlank(this.searchStr)) {
            for (String entry : this.entries) {
                if (this.canceled) {
                    return;
                }
                model.addElement(new EntryElement(entry, entry));
            }
        } else {
            Pattern pattern = this.createPattern(this.searchStr);
            for (String entry : this.entries) {
                if (this.canceled) {
                    return;
                }
                if (!pattern.matcher(entry).find()) continue;
                model.addElement(new EntryElement(entry, entry));
            }
            if (model.size() < 64) {
                StringBuilder sb = new StringBuilder();
                for (int i = model.size() - 1; i >= 0; --i) {
                    if (this.canceled) {
                        return;
                    }
                    EntryElement element = (EntryElement)model.getElementAt(i);
                    String entry = element.getEntry();
                    sb.setLength(0);
                    sb.append("<html>");
                    int index = 0;
                    Matcher matcher = pattern.matcher(entry);
                    while (matcher.find() && !this.canceled) {
                        int start = matcher.start();
                        int end = matcher.end();
                        if (start > index) {
                            sb.append(entry.substring(index, start));
                        }
                        index = end;
                        sb.append("<b>").append(entry.substring(start, end)).append("</b>");
                    }
                    if (index == 0) continue;
                    if (index < entry.length()) {
                        sb.append(entry.substring(index));
                    }
                    sb.append("</html>");
                    element.setEntryHTML(sb.toString());
                }
            }
        }
        if (!this.canceled) {
            EventQueue.invokeLater(() -> this.updateModel(model));
        }
    }

    protected void updateModel(DefaultListModel<EntryElement> model) {
        EntryElement selectedElement = this.list.getSelectedValue();
        int selectedIndex = -1;
        if (selectedElement != null) {
            String entry = selectedElement.getEntry();
            for (int i = model.size() - 1; i >= 0; --i) {
                if (model.get(i).getEntry().equals(entry)) {
                    selectedIndex = i;
                    break;
                }
                if (!this.canceled) continue;
                return;
            }
        }
        if (!this.canceled) {
            this.list.setModel(model);
            if (selectedIndex < 0 && model.getSize() == 1) {
                selectedIndex = 0;
            }
            if (selectedIndex >= 0) {
                this.list.setSelectedIndex(selectedIndex);
                int index = selectedIndex;
                EventQueue.invokeLater(() -> GuiUtil.scrollToCenter(this.list, index));
            } else {
                this.list.clearSelection();
            }
        }
    }
}

