/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.cheats.search;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import nintaco.App;
import nintaco.Machine;
import nintaco.PauseStepType;
import nintaco.cheats.Cheat;
import nintaco.cheats.GameCheats;
import nintaco.files.CartFile;
import nintaco.gui.ToolTipsTable;
import nintaco.gui.cheats.search.CheatSearchTableModel;
import nintaco.gui.cheats.search.Filter;
import nintaco.gui.cheats.search.RamTableModel;
import nintaco.gui.cheats.search.RamTableRow;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.QuickSaveListener;
import nintaco.gui.image.QuickSaveStateInfo;
import nintaco.mappers.Mapper;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class CheatSearchFrame
extends JFrame {
    private List<QuickSaveStateInfo> quickSaveStateInfos;
    private CheatSearchTableModel cheatSearchTableModel;
    private RamTableModel ramTableModel;
    private int aValue = -1;
    private int bValue = -1;
    private volatile int requestR = -1;
    private volatile boolean requestNVRAM;
    private volatile boolean requestPause;
    private volatile Mapper mapper;
    private final ImageFrame imageFrame;
    private final QuickSaveListener quickSaveListener = this::onQuickSaveChanged;
    private final DocumentListener cheatDocListener = GuiUtil.createDocumentListener(this::updateCheatsButtons);
    private final int[][] internalRAM = new int[2][2048];
    private final int[][] NVRAM = new int[2][8192];
    private final JRadioButton[] radioButtons;
    private final Filter[] filters = new Filter[]{(r0, r1) -> true, (r0, r1) -> r0 != r1, (r0, r1) -> r0 < r1, (r0, r1) -> r0 > r1, (r0, r1) -> r0 == this.aValue && r1 == this.bValue, (r0, r1) -> r0 == this.aValue && r0 - r1 == this.bValue, (r0, r1) -> r0 - r1 == this.bValue};
    private Filter filter = this.filters[0];
    private JLabel aLabel;
    private JTextField aTextField;
    private JRadioButton abDeltaRadioButton;
    private JRadioButton abRadioButton;
    private JLabel addressLabel;
    private JTextField addressTextField;
    private JButton applyButton;
    private JLabel bLabel;
    private JTextField bTextField;
    private ButtonGroup buttonGroup;
    private JButton cancelButton;
    private JPanel cheatsPanel;
    private JScrollPane cheatsScrollPane;
    private JTable cheatsTable;
    private JLabel compareLabel;
    private JTextField compareTextField;
    private JButton deleteButton;
    private JRadioButton deltaRadioButton;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private JPanel filterPanel;
    private JRadioButton gtRadioButton;
    private JButton insertButton;
    private JLabel jLabel1;
    private JButton loadButton;
    private JRadioButton ltRadioButton;
    private JRadioButton neRadioButton;
    private JButton nextFrameButton;
    private JRadioButton noRadioButton;
    private JCheckBox nvramCheckBox;
    private JButton okButton;
    private JToggleButton pauseButton;
    private JCheckBox pauseCheckBox;
    private JScrollPane ramScrollPane;
    private JTable ramTable;
    private JButton saveButton;
    private JComboBox saveSlotComboBox;
    private JPanel searchPanel;
    private JCheckBox showHexCheckBox;
    private JCheckBox snapAfterFrameCheckBox;
    private JButton snapR0Button;
    private JButton snapR1Button;
    private JButton updateButton;
    private JLabel valueLabel;
    private JTextField valueTextField;

    public CheatSearchFrame(Machine machine) {
        this.initComponents();
        for (JRadioButton radioButton : this.radioButtons = new JRadioButton[]{this.noRadioButton, this.neRadioButton, this.ltRadioButton, this.gtRadioButton, this.abRadioButton, this.abDeltaRadioButton, this.deltaRadioButton}) {
            radioButton.addActionListener(e -> this.updateRamTableModel());
        }
        this.imageFrame = App.getImageFrame();
        this.imageFrame.addQuickSaveListener(this.quickSaveListener);
        GuiUtil.scaleFonts(this);
        this.initDocumentListeners();
        this.initCheatsTable();
        this.initRamTable();
        this.setMachine(machine);
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private boolean tableHasBeenReset() {
        for (int i = this.cheatSearchTableModel.getRowCount() - 1; i >= 0; --i) {
            if (!this.cheatSearchTableModel.getRow(i).isEnabled()) continue;
            return false;
        }
        List<Cheat> cheats = GameCheats.queryCheatsDB();
        if (cheats == null || cheats.size() != this.cheatSearchTableModel.getRowCount()) {
            return false;
        }
        for (int i = cheats.size() - 1; i >= 0; --i) {
            if (cheats.get(i).equals(this.cheatSearchTableModel.getRow(i))) continue;
            return false;
        }
        return true;
    }

    private void resetIfEmpty() {
        if (this.cheatSearchTableModel.getRowCount() == 0) {
            this.resetCheats();
        }
    }

    private void resetCheats() {
        this.cheatSearchTableModel.clear();
        List<Cheat> cheats = GameCheats.queryCheatsDB();
        if (cheats != null) {
            this.cheatSearchTableModel.add(cheats, false);
            this.cheatSearchTableModel.setModified(false);
        }
        this.updateCheatsButtons();
    }

    public List<Cheat> getCheats() {
        return this.cheatSearchTableModel.getCheatsCopy();
    }

    public void setCheats(List<Cheat> cheats) {
        this.cheatSearchTableModel.setCheats(cheats);
        this.resetIfEmpty();
    }

    public final void setMachine(Machine machine) {
        this.mapper = machine == null ? null : machine.getMapper();
        this.updateR(0, this.mapper);
        this.updateR(1, this.mapper);
        EventQueue.invokeLater(() -> {
            CartFile cartFile = App.getCartFile();
            if (cartFile != null) {
                this.nvramCheckBox.setSelected(cartFile.isNonVolatilePrgRamPresent());
            }
            this.activateButtons();
            Mapper m = this.mapper;
            if (m == null) {
                this.cheatSearchTableModel.clear();
            } else {
                this.setCheats(GameCheats.getCopy());
            }
            this.cheatTableSelectionChanged();
        });
    }

    private void updateLoadButton() {
        int index = this.saveSlotComboBox.getSelectedIndex();
        if (this.quickSaveStateInfos != null && index < this.quickSaveStateInfos.size()) {
            QuickSaveStateInfo info = this.quickSaveStateInfos.get(index);
            this.loadButton.setEnabled(info.getFile().exists());
        } else {
            this.loadButton.setEnabled(false);
        }
    }

    private void initDocumentListeners() {
        this.aTextField.getDocument().addDocumentListener(GuiUtil.createDocumentListener(this::updateRamTableModel));
        this.bTextField.getDocument().addDocumentListener(GuiUtil.createDocumentListener(this::updateRamTableModel));
        this.addCheatDocumentListeners();
    }

    private void addCheatDocumentListeners() {
        this.descriptionTextField.getDocument().addDocumentListener(this.cheatDocListener);
        this.addressTextField.getDocument().addDocumentListener(this.cheatDocListener);
        this.valueTextField.getDocument().addDocumentListener(this.cheatDocListener);
        this.compareTextField.getDocument().addDocumentListener(this.cheatDocListener);
    }

    private void removeCheatDocumentListeners() {
        this.descriptionTextField.getDocument().removeDocumentListener(this.cheatDocListener);
        this.addressTextField.getDocument().removeDocumentListener(this.cheatDocListener);
        this.valueTextField.getDocument().removeDocumentListener(this.cheatDocListener);
        this.compareTextField.getDocument().removeDocumentListener(this.cheatDocListener);
    }

    private void initCheatsTable() {
        this.cheatsScrollPane.setPreferredSize(null);
        this.cheatSearchTableModel = new CheatSearchTableModel(GameCheats.getCopy());
        this.resetIfEmpty();
        this.cheatsTable.setModel(this.cheatSearchTableModel);
        ((ToolTipsTable)this.cheatsTable).setColumnToolTips("Enabled", "Description");
        GuiUtil.disableCellBorder(this.cheatsTable);
        GuiUtil.forceNoClearRowSelect(this.cheatsTable);
        this.cheatsTable.getSelectionModel().addListSelectionListener(e -> this.cheatTableSelectionChanged());
        GuiUtil.resizeCellSizes(this.cheatsTable, true, 20, false);
        this.cheatsTable.getColumnModel().getColumn(1).setPreferredWidth(0x100000);
        this.cheatTableSelectionChanged();
    }

    private void initRamTable() {
        this.ramTableModel = new RamTableModel(new ArrayList<RamTableRow>());
        this.ramTable.setModel(this.ramTableModel);
        GuiUtil.resizeCellSizes(this.ramTable, true, 10, false, "BBBBB", "BBBB", "BBBB");
        GuiUtil.disableCellBorder(this.ramTable);
        GuiUtil.forceNoClearRowSelect(this.ramTable);
    }

    private void cheatTableSelectionChanged() {
        this.removeCheatDocumentListeners();
        int index = this.cheatsTable.getSelectedRow();
        if (index >= 0 && index < this.cheatSearchTableModel.getRowCount()) {
            boolean showHex = this.showHexCheckBox.isSelected();
            Cheat cheat = this.cheatSearchTableModel.getRow(index);
            this.descriptionTextField.setText(cheat.getDescription());
            this.addressTextField.setText(String.format("%04X", cheat.getAddress()));
            this.valueTextField.setText(String.format(showHex ? "%02X" : "%d", cheat.getDataValue()));
            if (cheat.hasCompareValue()) {
                this.compareTextField.setText(String.format(showHex ? "%02X" : "%d", cheat.getCompareValue()));
            } else {
                this.compareTextField.setText("");
            }
        }
        this.addCheatDocumentListeners();
        this.updateCheatsButtons();
    }

    private Cheat createCheat() {
        boolean showHex = this.showHexCheckBox.isSelected();
        int address = StringUtil.parseInt(this.addressTextField.getText(), true, 65535L);
        int value = StringUtil.parseInt(this.valueTextField.getText(), showHex, 255L);
        int compare = StringUtil.parseInt(this.compareTextField.getText(), showHex, 255L);
        if (address < 0 || value < 0 || compare < -1) {
            return null;
        }
        Cheat cheat = new Cheat(address, value, compare);
        String description = this.descriptionTextField.getText().trim();
        if (description.isEmpty()) {
            cheat.generateDescription();
        } else {
            cheat.setDescription(description);
        }
        return cheat;
    }

    private void aEdited() {
        this.aValue = StringUtil.parseInt(this.aTextField.getText(), this.showHexCheckBox.isSelected(), 255L);
        this.updateRadioButtons();
    }

    private void bEdited() {
        this.bValue = StringUtil.parseInt(this.bTextField.getText(), this.showHexCheckBox.isSelected(), 255L);
        this.updateRadioButtons();
    }

    private void updateRadioButtons() {
        this.abRadioButton.setEnabled(this.aValue >= 0 && this.bValue >= 0);
        this.abDeltaRadioButton.setEnabled(this.aValue >= 0 && this.bValue >= 0);
        this.deltaRadioButton.setEnabled(this.bValue >= 0);
    }

    private void activateButtons() {
        this.updateCheatsButtons();
        boolean enabled = this.mapper != null;
        this.snapR0Button.setEnabled(enabled);
        this.snapR1Button.setEnabled(enabled);
        this.pauseButton.setEnabled(enabled);
        this.nextFrameButton.setEnabled(enabled);
        this.saveButton.setEnabled(enabled);
        this.loadButton.setEnabled(enabled);
        this.applyButton.setEnabled(enabled);
        this.okButton.setEnabled(enabled);
    }

    private void updateCheatsButtons() {
        if (this.mapper == null) {
            this.insertButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.updateButton.setEnabled(false);
            return;
        }
        this.deleteButton.setEnabled(this.cheatSearchTableModel.getRowCount() > 0 && this.cheatsTable.getSelectedRow() >= 0 && this.cheatsTable.getSelectedRow() < this.cheatSearchTableModel.getRowCount());
        boolean showHex = this.showHexCheckBox.isSelected();
        int address = StringUtil.parseInt(this.addressTextField.getText(), true, 65535L);
        int value = -1;
        int compare = -1;
        if (address >= 0) {
            value = StringUtil.parseInt(this.valueTextField.getText(), showHex, 255L);
            if (value >= 0) {
                compare = StringUtil.parseInt(this.compareTextField.getText(), showHex, 255L);
                this.insertButton.setEnabled(compare >= -1);
            } else {
                this.insertButton.setEnabled(false);
            }
        } else {
            this.insertButton.setEnabled(false);
        }
        if (this.deleteButton.isEnabled() && this.insertButton.isEnabled()) {
            Cheat cheat = this.cheatSearchTableModel.getRow(this.cheatsTable.getSelectedRow());
            this.updateButton.setEnabled(cheat.getAddress() != address || cheat.getDataValue() != value || (cheat.hasCompareValue() || compare != -1) && cheat.getCompareValue() != compare || !cheat.getDescription().equals(this.descriptionTextField.getText().trim()));
        } else {
            this.updateButton.setEnabled(false);
        }
    }

    public void destroy() {
        this.imageFrame.removeQuickSaveListener(this.quickSaveListener);
        if (this.pauseButton.isSelected()) {
            App.setStepPause(false);
        }
        this.dispose();
    }

    private void closeFrame() {
        App.destroyCheatSearchFrame();
    }

    public void update() {
        if (this.requestR >= 0) {
            this.updateR(this.requestR, this.mapper);
            this.requestR = -1;
        }
    }

    private void updateR(int r, Mapper mapper) {
        int[] ram = this.internalRAM[r];
        for (int i = 2047; i >= 0; --i) {
            ram[i] = mapper == null ? 0 : mapper.peekCpuMemory(i);
        }
        if (this.requestNVRAM) {
            int[] nvram = this.NVRAM[r];
            for (int i = 8191; i >= 0; --i) {
                nvram[i] = mapper == null ? 0 : mapper.peekCpuMemory(0x6000 | i);
            }
        }
        this.rUpdated();
    }

    private void rUpdated() {
        if (EventQueue.isDispatchThread()) {
            if (this.requestPause) {
                App.setStepPause(true);
                this.requestPause = false;
            }
            this.updateRamTableModel();
        } else {
            EventQueue.invokeLater(this::rUpdated);
        }
    }

    private void updateRamTableModel() {
        int r1;
        int r0;
        int i;
        this.updateFilter();
        int firstAddress = 0;
        int firstIndex = GuiUtil.getFirstVisibleRowIndex(this.ramTable);
        if (firstIndex >= 0 && firstIndex < this.ramTableModel.getRowCount()) {
            RamTableRow row = this.ramTableModel.getRow(firstIndex);
            firstAddress = row.getAddress();
        }
        int bestIndex = 0;
        int diff = Integer.MAX_VALUE;
        ArrayList<RamTableRow> rows = new ArrayList<RamTableRow>();
        for (i = 0; i < 2048; ++i) {
            r0 = this.internalRAM[0][i];
            r1 = this.internalRAM[1][i];
            if (!this.filter.accept(r0, r1)) continue;
            rows.add(new RamTableRow(i, r0, r1));
            int d = Math.abs(i - firstAddress);
            if (d >= diff) continue;
            diff = d;
            bestIndex = rows.size() - 1;
        }
        if (this.nvramCheckBox.isSelected()) {
            for (i = 0; i < 8192; ++i) {
                r0 = this.NVRAM[0][i];
                r1 = this.NVRAM[1][i];
                if (!this.filter.accept(r0, r1)) continue;
                int address = 0x6000 | i;
                rows.add(new RamTableRow(address, r0, r1));
                int d = Math.abs(address - firstAddress);
                if (d >= diff) continue;
                diff = d;
                bestIndex = rows.size() - 1;
            }
        }
        this.ramTableModel.setRows(rows);
        GuiUtil.scrollToRowIndex(this.ramTable, bestIndex);
    }

    private void updateFilter() {
        this.aEdited();
        this.bEdited();
        this.filter = this.filters[0];
        for (int i = this.radioButtons.length - 1; i >= 0; --i) {
            if (!this.radioButtons[i].isSelected()) continue;
            this.filter = this.filters[i];
            break;
        }
    }

    private void requestSnap(int index) {
        this.requestNVRAM = this.nvramCheckBox.isSelected();
        if (this.pauseButton.isSelected()) {
            this.updateR(index, this.mapper);
        } else if (this.requestR < 0) {
            this.requestPause = this.pauseCheckBox.isSelected() && !this.pauseButton.isSelected();
            this.requestR = index;
        }
    }

    private void applyCheats() {
        if (!this.cheatSearchTableModel.isModified() || this.tableHasBeenReset()) {
            this.cheatSearchTableModel.clear();
        }
        GameCheats.setCheats(this.cheatSearchTableModel.getCheatsCopy());
        GameCheats.save();
        GameCheats.updateMachine();
    }

    public void onStepPausedChanged(boolean paused) {
        this.pauseButton.setText(paused ? "Resume" : "Pause");
        this.pauseButton.setSelected(paused);
        this.nextFrameButton.setEnabled(paused);
    }

    private void onQuickSaveChanged(List<QuickSaveStateInfo> quickSaveStateInfos) {
        this.quickSaveStateInfos = quickSaveStateInfos;
        this.updateLoadButton();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.cheatsPanel = new JPanel();
        this.cheatsScrollPane = new JScrollPane();
        this.cheatsTable = new ToolTipsTable();
        this.insertButton = new JButton();
        this.updateButton = new JButton();
        this.deleteButton = new JButton();
        this.descriptionTextField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.addressLabel = new JLabel();
        this.addressTextField = new JTextField();
        this.valueLabel = new JLabel();
        this.valueTextField = new JTextField();
        this.compareLabel = new JLabel();
        this.compareTextField = new JTextField();
        this.searchPanel = new JPanel();
        this.ramScrollPane = new JScrollPane();
        this.ramTable = new ToolTipsTable();
        this.filterPanel = new JPanel();
        this.noRadioButton = new JRadioButton();
        this.saveButton = new JButton();
        this.gtRadioButton = new JRadioButton();
        this.aLabel = new JLabel();
        this.saveSlotComboBox = new JComboBox();
        this.snapR1Button = new JButton();
        this.aTextField = new JTextField();
        this.nvramCheckBox = new JCheckBox();
        this.pauseCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.abRadioButton = new JRadioButton();
        this.deltaRadioButton = new JRadioButton();
        this.abDeltaRadioButton = new JRadioButton();
        this.neRadioButton = new JRadioButton();
        this.ltRadioButton = new JRadioButton();
        this.loadButton = new JButton();
        this.bLabel = new JLabel();
        this.snapR0Button = new JButton();
        this.bTextField = new JTextField();
        this.pauseButton = new JToggleButton();
        this.nextFrameButton = new JButton();
        this.snapAfterFrameCheckBox = new JCheckBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.applyButton = new JButton();
        this.showHexCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Cheat Search");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CheatSearchFrame.this.formWindowClosing(evt);
            }
        });
        this.cheatsPanel.setBorder(BorderFactory.createTitledBorder("Cheats"));
        this.cheatsScrollPane.setMaximumSize(null);
        this.cheatsScrollPane.setMinimumSize(null);
        this.cheatsTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.cheatsTable.setAutoResizeMode(3);
        this.cheatsScrollPane.setViewportView(this.cheatsTable);
        this.insertButton.setMnemonic('I');
        this.insertButton.setText("Insert");
        this.insertButton.setFocusPainted(false);
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.insertButtonActionPerformed(evt);
            }
        });
        this.updateButton.setMnemonic('U');
        this.updateButton.setText("Update");
        this.updateButton.setFocusPainted(false);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.updateButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setMnemonic('D');
        this.deleteButton.setText("Delete");
        this.deleteButton.setFocusPainted(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.deleteButtonActionPerformed(evt);
            }
        });
        this.descriptionTextField.setMinimumSize(null);
        this.descriptionTextField.setPreferredSize(null);
        this.descriptionLabel.setText("Description:");
        this.addressLabel.setText("Address:");
        this.addressTextField.setColumns(7);
        this.valueLabel.setText("Value:");
        this.valueTextField.setColumns(5);
        this.valueTextField.setPreferredSize(null);
        this.compareLabel.setText("Compare:");
        this.compareTextField.setColumns(5);
        this.compareTextField.setPreferredSize(null);
        GroupLayout cheatsPanelLayout = new GroupLayout(this.cheatsPanel);
        this.cheatsPanel.setLayout(cheatsPanelLayout);
        cheatsPanelLayout.setHorizontalGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cheatsPanelLayout.createSequentialGroup().addGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cheatsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.insertButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(cheatsPanelLayout.createSequentialGroup().addContainerGap().addGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cheatsPanelLayout.createSequentialGroup().addGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, GroupLayout.Alignment.TRAILING).addComponent(this.addressLabel, GroupLayout.Alignment.TRAILING).addComponent(this.valueLabel, GroupLayout.Alignment.TRAILING).addComponent(this.compareLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionTextField, -1, -1, Short.MAX_VALUE).addGroup(cheatsPanelLayout.createSequentialGroup().addGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addressTextField, -2, -1, -2).addComponent(this.valueTextField, -2, -1, -2).addComponent(this.compareTextField, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.cheatsScrollPane, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        cheatsPanelLayout.linkSize(0, this.deleteButton, this.insertButton, this.updateButton);
        cheatsPanelLayout.linkSize(0, this.compareTextField, this.valueTextField);
        cheatsPanelLayout.setVerticalGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cheatsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cheatsScrollPane, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.descriptionTextField, -2, -1, -2).addComponent(this.descriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressLabel).addComponent(this.addressTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.valueLabel).addComponent(this.valueTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compareLabel).addComponent(this.compareTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(cheatsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.insertButton).addComponent(this.updateButton).addComponent(this.deleteButton)).addContainerGap()));
        this.searchPanel.setBorder(BorderFactory.createTitledBorder("Search"));
        this.ramScrollPane.setVerticalScrollBarPolicy(22);
        this.ramScrollPane.setMinimumSize(null);
        this.ramTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.ramScrollPane.setViewportView(this.ramTable);
        this.buttonGroup.add(this.noRadioButton);
        this.noRadioButton.setSelected(true);
        this.noRadioButton.setText("No search filter");
        this.noRadioButton.setFocusPainted(false);
        this.saveButton.setMnemonic('S');
        this.saveButton.setText("Save");
        this.saveButton.setFocusPainted(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.gtRadioButton);
        this.gtRadioButton.setText("<html>R0 &gt; R1</html>");
        this.gtRadioButton.setFocusPainted(false);
        this.aLabel.setText("A:");
        this.saveSlotComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"}));
        this.saveSlotComboBox.setFocusable(false);
        this.saveSlotComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.saveSlotComboBoxActionPerformed(evt);
            }
        });
        this.snapR1Button.setMnemonic('1');
        this.snapR1Button.setText("Snap R1");
        this.snapR1Button.setFocusPainted(false);
        this.snapR1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.snapR1ButtonActionPerformed(evt);
            }
        });
        this.aTextField.setColumns(5);
        this.aTextField.setMinimumSize(null);
        this.aTextField.setPreferredSize(null);
        this.nvramCheckBox.setText("View NVRAM");
        this.nvramCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.nvramCheckBoxActionPerformed(evt);
            }
        });
        this.pauseCheckBox.setSelected(true);
        this.pauseCheckBox.setText("Pause after snap");
        this.jLabel1.setText("Save slot:");
        this.jLabel1.setToolTipText("");
        this.jLabel1.setMaximumSize(null);
        this.jLabel1.setMinimumSize(null);
        this.jLabel1.setPreferredSize(null);
        this.buttonGroup.add(this.abRadioButton);
        this.abRadioButton.setText("<html>R0 = A, R1 = B</html>");
        this.abRadioButton.setEnabled(false);
        this.abRadioButton.setFocusPainted(false);
        this.buttonGroup.add(this.deltaRadioButton);
        this.deltaRadioButton.setText("<html>R0 &minus; R1 = B</html>");
        this.deltaRadioButton.setEnabled(false);
        this.deltaRadioButton.setFocusPainted(false);
        this.buttonGroup.add(this.abDeltaRadioButton);
        this.abDeltaRadioButton.setText("<html>R0 = A, R0 &minus; R1 = B</html>");
        this.abDeltaRadioButton.setEnabled(false);
        this.abDeltaRadioButton.setFocusPainted(false);
        this.buttonGroup.add(this.neRadioButton);
        this.neRadioButton.setText("<html>R0 &ne; R1</html>");
        this.neRadioButton.setFocusPainted(false);
        this.buttonGroup.add(this.ltRadioButton);
        this.ltRadioButton.setText("<html>R0 &lt; R1</html>");
        this.ltRadioButton.setFocusPainted(false);
        this.loadButton.setMnemonic('L');
        this.loadButton.setText("Load");
        this.loadButton.setFocusPainted(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.loadButtonActionPerformed(evt);
            }
        });
        this.bLabel.setText("B:");
        this.snapR0Button.setMnemonic('0');
        this.snapR0Button.setText("Snap R0");
        this.snapR0Button.setFocusPainted(false);
        this.snapR0Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.snapR0ButtonActionPerformed(evt);
            }
        });
        this.bTextField.setColumns(5);
        this.bTextField.setMinimumSize(null);
        this.bTextField.setPreferredSize(null);
        this.pauseButton.setMnemonic('P');
        this.pauseButton.setText("Pause");
        this.pauseButton.setFocusPainted(false);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.pauseButtonActionPerformed(evt);
            }
        });
        this.nextFrameButton.setMnemonic('F');
        this.nextFrameButton.setText("Frame+1");
        this.nextFrameButton.setFocusPainted(false);
        this.nextFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.nextFrameButtonActionPerformed(evt);
            }
        });
        this.snapAfterFrameCheckBox.setText("Snap R1 after Frame+1");
        GroupLayout filterPanelLayout = new GroupLayout(this.filterPanel);
        this.filterPanel.setLayout(filterPanelLayout);
        filterPanelLayout.setHorizontalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.pauseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextFrameButton)).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.snapR0Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.snapR1Button)).addComponent(this.deltaRadioButton, -2, -1, -2).addComponent(this.abDeltaRadioButton, -2, -1, -2).addComponent(this.abRadioButton, -2, -1, -2).addComponent(this.gtRadioButton, -2, -1, -2).addComponent(this.ltRadioButton, -2, -1, -2).addComponent(this.neRadioButton, -2, -1, -2).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.aLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.bLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bTextField, -2, -1, -2)).addComponent(this.noRadioButton).addComponent(this.nvramCheckBox).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadButton)).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveSlotComboBox, -2, -1, -2)).addComponent(this.pauseCheckBox).addComponent(this.snapAfterFrameCheckBox)).addContainerGap()));
        filterPanelLayout.linkSize(0, this.loadButton, this.nextFrameButton, this.pauseButton, this.saveButton, this.snapR0Button, this.snapR1Button);
        filterPanelLayout.setVerticalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aLabel).addComponent(this.aTextField, -2, -1, -2).addComponent(this.bLabel).addComponent(this.bTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.neRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ltRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gtRadioButton, -2, -1, -2).addGap(0, 0, 0).addComponent(this.abRadioButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.abDeltaRadioButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deltaRadioButton, -2, -1, -2).addGap(18, 18, 18).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.snapR0Button).addComponent(this.snapR1Button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pauseButton).addComponent(this.nextFrameButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pauseCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.snapAfterFrameCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nvramCheckBox).addGap(18, 18, 18).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.loadButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.saveSlotComboBox, -2, -1, -2)).addContainerGap()));
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filterPanel, -2, -1, -2).addGap(10, 10, 10).addComponent(this.ramScrollPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ramScrollPane, -1, -1, Short.MAX_VALUE).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.filterPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("   Cancel   ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.okButtonActionPerformed(evt);
            }
        });
        this.applyButton.setMnemonic('A');
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.applyButtonActionPerformed(evt);
            }
        });
        this.showHexCheckBox.setText("Show hex");
        this.showHexCheckBox.setFocusPainted(false);
        this.showHexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatSearchFrame.this.showHexCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cheatsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchPanel, -1, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.showHexCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyButton))).addContainerGap()));
        layout.linkSize(0, this.applyButton, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cheatsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.searchPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.applyButton).addComponent(this.showHexCheckBox)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void snapR0ButtonActionPerformed(ActionEvent evt) {
        this.requestSnap(0);
    }

    private void snapR1ButtonActionPerformed(ActionEvent evt) {
        this.requestSnap(1);
    }

    private void showHexCheckBoxActionPerformed(ActionEvent evt) {
        this.ramTableModel.setShowHex(this.showHexCheckBox.isSelected());
        this.cheatTableSelectionChanged();
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        int index = this.cheatSearchTableModel.add(this.createCheat());
        this.cheatsTable.getSelectionModel().setSelectionInterval(index, index);
        this.updateCheatsButtons();
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        this.cheatSearchTableModel.update(this.cheatsTable.getSelectedRow(), this.createCheat());
        this.updateCheatsButtons();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (this.cheatSearchTableModel.isEmpty()) {
            return;
        }
        int index = this.cheatsTable.getSelectedRow();
        if (index >= 0 && index < this.cheatSearchTableModel.getRowCount()) {
            this.cheatSearchTableModel.removeRow(index);
        }
        this.updateCheatsButtons();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.applyCheats();
        this.closeFrame();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.applyCheats();
    }

    private void nextFrameButtonActionPerformed(ActionEvent evt) {
        if (this.snapAfterFrameCheckBox.isSelected()) {
            this.requestSnap(1);
        }
        App.step(PauseStepType.Frame);
    }

    private void pauseButtonActionPerformed(ActionEvent evt) {
        App.setStepPause(this.pauseButton.isSelected());
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.imageFrame.quickSaveState(this.saveSlotComboBox.getSelectedIndex() + 1);
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        this.imageFrame.quickLoadState(this.saveSlotComboBox.getSelectedIndex() + 1);
    }

    private void saveSlotComboBoxActionPerformed(ActionEvent evt) {
        this.updateLoadButton();
    }

    private void nvramCheckBoxActionPerformed(ActionEvent evt) {
        this.updateRamTableModel();
    }
}

