/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.debugger.addresslabel;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import nintaco.disassembler.AddressLabel;
import nintaco.preferences.GamePrefs;
import nintaco.util.StringUtil;

public class AddressLabelTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Code", "Bookmark", "Bank", "Address", "Label", "Comment"};
    private List<AddressLabel> rows = new ArrayList<AddressLabel>();

    public List<AddressLabel> getRows() {
        return this.rows;
    }

    public void delete(int index) {
        this.rows.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public int add(AddressLabel addressLabel) {
        int index = this.rows.indexOf(addressLabel);
        if (index >= 0) {
            this.rows.set(index, addressLabel);
            this.fireTableRowsUpdated(index, index);
            return index;
        }
        this.rows.add(addressLabel);
        this.fireTableDataChanged();
        return this.rows.indexOf(addressLabel);
    }

    public void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public List<AddressLabel> getRowsCopy() {
        ArrayList<AddressLabel> rs = new ArrayList<AddressLabel>();
        for (AddressLabel row : this.rows) {
            rs.add(new AddressLabel(row));
        }
        return rs;
    }

    public void setRows(List<AddressLabel> rows) {
        this.rows = rows;
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowsCopy(List<AddressLabel> rows) {
        ArrayList<AddressLabel> rs = new ArrayList<AddressLabel>();
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            for (AddressLabel row : rows) {
                rs.add(new AddressLabel(row));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.setRows(rs);
            return;
        }
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AddressLabel addressLabel = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return addressLabel.isCode();
            }
            case 1: {
                return addressLabel.isBookmark();
            }
            case 2: {
                return addressLabel.getBank() < 0 ? "" : String.format("$%02X", addressLabel.getBank());
            }
            case 3: {
                return String.format("$%04X", addressLabel.getAddress());
            }
            case 4: {
                return addressLabel.getLabel();
            }
            case 5: {
                return addressLabel.getComment();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (value == null) {
            return;
        }
        AddressLabel addressLabel = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                addressLabel.setCode((Boolean)value);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 1: {
                addressLabel.setBookmark((Boolean)value);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 2: {
                int bank = StringUtil.parseInt(value, true, 255L);
                if (bank < -1) {
                    return;
                }
                for (AddressLabel row : this.rows) {
                    if (row.getBank() != bank || row.getAddress() != addressLabel.getAddress()) continue;
                    return;
                }
                addressLabel.setBank(bank);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 3: {
                int address = StringUtil.parseInt(value, true, 65535L);
                if (address < 0) {
                    return;
                }
                for (AddressLabel row : this.rows) {
                    if (row.getAddress() != address || row.getBank() != addressLabel.getBank()) continue;
                    return;
                }
                addressLabel.setAddress(address);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 4: {
                String label = ((String)value).trim();
                if (!label.isEmpty() || !addressLabel.getComment().isEmpty()) {
                    addressLabel.setLabel(label);
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 5: {
                String comment = ((String)value).trim();
                if (!comment.isEmpty() || !addressLabel.getLabel().isEmpty()) {
                    addressLabel.setComment(comment);
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex < 2 ? Boolean.class : String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }
}

