/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.debugger.breakpoint;

import java.awt.EventQueue;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import nintaco.App;
import nintaco.Breakpoint;
import nintaco.files.FileUtil;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.ToolTipsTable;
import nintaco.gui.debugger.addresslabel.AddressLabelDialog;
import nintaco.gui.debugger.breakpoint.BreakpointTableModel;
import nintaco.gui.debugger.breakpoint.CreateBreakpointDialog;
import nintaco.gui.image.preferences.Paths;
import nintaco.gui.table.TableDialog;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.CsvUtil;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class BreakpointDialog
extends TableDialog {
    private BreakpointTableModel tableModel;
    private Breakpoint breakpoint;
    private boolean ok;

    public BreakpointDialog(Window parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.setTitle("Breakpoints");
        this.tableModel = new BreakpointTableModel();
        this.tableModel.setRowsCopy(GamePrefs.getInstance().getDebuggerGamePrefs().getBreakpoints());
        this.table.setModel(this.tableModel);
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().toggleSortOrder(3);
        GuiUtil.setCellRenderer(this.table, 0, GuiUtil.NO_BORDER_BOOLEAN_RENDERER);
        GuiUtil.createComboBoxCellEditorAndRenderer(this.table, 1, BreakpointTableModel.TYPE_NAMES);
        GuiUtil.setCellRenderer(this.table, 2, GuiUtil.NO_BORDER_MONOSPACED_RENDERER);
        GuiUtil.setCellRenderer(this.table, 3, GuiUtil.NO_BORDER_MONOSPACED_RENDERER);
        GuiUtil.setCellRenderer(this.table, 4, GuiUtil.NO_BORDER_MONOSPACED_RENDERER);
        GuiUtil.resizeCellSizes(this.table, true, 8, false, Boolean.TRUE, BreakpointTableModel.TYPE_NAMES[0], "MMMM", "MMMMMM", "MMMMMM");
        ((ToolTipsTable)this.table).setColumnToolTips("Enabled", "Type", "Bank", "Start", "End");
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setBreakpoint(Breakpoint breakpoint) {
        this.breakpoint = breakpoint;
    }

    @Override
    protected void handleShown() {
        if (this.breakpoint != null) {
            List<Breakpoint> rows = this.tableModel.getRows();
            for (int i = rows.size() - 1; i >= 0; --i) {
                Breakpoint row = rows.get(i);
                if (!row.equals(this.breakpoint)) continue;
                this.editButtonPressed(i);
                return;
            }
            CreateBreakpointDialog dialog = new CreateBreakpointDialog((Window)this);
            dialog.setTitle("New Breakpoint");
            dialog.setBreakpoint(new Breakpoint(this.breakpoint));
            dialog.setVisible(true);
            if (dialog.isOk()) {
                this.setSelectedRow(this.tableModel.add(dialog.getBreakpoint()));
            }
        }
    }

    @Override
    protected void okButtonPressed() {
        GamePrefs.getInstance().getDebuggerGamePrefs().setBreakpoints(this.tableModel.getRows());
        GamePrefs.save();
        this.ok = true;
        this.closeDialog();
    }

    @Override
    protected void cancelButtonPressed() {
        this.closeDialog();
    }

    @Override
    protected void clearButtonPressed() {
        this.tableModel.clear();
    }

    @Override
    protected void exportButtonPressed() {
        App.setNoStepPause(true);
        Paths paths = AppPrefs.getInstance().getPaths();
        String recentDir = paths.getBreakpointsDir();
        FileUtil.mkdir(recentDir);
        File file = GuiUtil.showSaveAsDialog(this, recentDir, FileUtil.getFileNameWithoutExtension(App.getEntryFileName()) + ".csv", "csv", AddressLabelDialog.FILE_FILTERS[0], true);
        if (file != null) {
            String dir = file.getParent();
            paths.addRecentDirectory(dir);
            paths.setBreakpointsDir(dir);
            AppPrefs.save();
            List<Breakpoint> breakpoints = this.tableModel.getRows();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.exportFile(pleaseWaitDialog, file, breakpoints)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void exportFile(PleaseWaitDialog pleaseWaitDialog, File file, List<Breakpoint> breakpoints) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (Breakpoint breakpoint : breakpoints) {
            ArrayList<String> row = new ArrayList<String>();
            rows.add(row);
            row.add(Boolean.toString(breakpoint.isEnabled()));
            row.add(BreakpointTableModel.TYPE_NAMES[breakpoint.getType()]);
            row.add(String.format("%02X", breakpoint.getBank()));
            row.add(String.format("%04X", breakpoint.getStartAddress()));
            row.add(String.format("%04X", breakpoint.getEndAddress()));
        }
        boolean error = false;
        try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));){
            CsvUtil.write(out, rows);
        }
        catch (Throwable t) {
            error = true;
        }
        pleaseWaitDialog.dispose();
        if (error) {
            GuiUtil.displayError(this, "Failed to export breakpoints.");
        }
        App.setNoStepPause(false);
    }

    @Override
    protected void importButtonPressed() {
        App.setNoStepPause(true);
        JFileChooser chooser = GuiUtil.createFileChooser("Import Breakpoints", AppPrefs.getInstance().getPaths().getBreakpointsDir(), (FileFilter[])AddressLabelDialog.FILE_FILTERS);
        if (GuiUtil.showOpenDialog(this, chooser, (p, d) -> p.setBreakpointsDir((String)d)) == 0) {
            File selectedFile = chooser.getSelectedFile();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.importFile(pleaseWaitDialog, selectedFile)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void importFile(PleaseWaitDialog pleaseWaitDialog, File selectedFile) {
        ArrayList<Breakpoint> rows = new ArrayList<Breakpoint>();
        List<List<String>> values = null;
        try (BufferedReader br = new BufferedReader(new FileReader(selectedFile));){
            values = CsvUtil.read(br);
            for (List<String> list : values) {
                if (list.size() < 5) continue;
                boolean enabled = Boolean.parseBoolean(list.get(0));
                int type = BreakpointTableModel.getType(list.get(1));
                int bank = StringUtil.parseInt(list.get(2), true, 255L);
                int startAddress = StringUtil.parseInt(list.get(3), true, 65535L);
                int endAddress = StringUtil.parseInt(list.get(4), true, 65535L);
                if (startAddress < 0 || type < 0) continue;
                rows.add(new Breakpoint(type, bank, startAddress, endAddress, enabled));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pleaseWaitDialog.dispose();
        if (values == null) {
            GuiUtil.displayError(this, "Failed to import address labels file.");
        } else if (rows.isEmpty()) {
            GuiUtil.displayError(this, "The file does not contain any valid address labels.");
        } else {
            EventQueue.invokeLater(() -> {
                this.tableModel.setRows(rows);
                this.selectionChanged();
                this.updateClearButton();
            });
        }
        App.setNoStepPause(false);
    }

    @Override
    protected void deleteButtonPressed(int index) {
        this.tableModel.delete(index);
    }

    @Override
    protected void editButtonPressed(int index) {
        CreateBreakpointDialog dialog = new CreateBreakpointDialog((Window)this);
        dialog.setTitle("Edit Breakpoint");
        dialog.setBreakpoint(this.tableModel.getRows().get(index));
        dialog.setVisible(true);
        if (dialog.isOk()) {
            this.tableModel.delete(index);
            this.setSelectedRow(this.tableModel.add(dialog.getBreakpoint()));
        }
    }

    @Override
    protected void newButtonPressed() {
        CreateBreakpointDialog dialog = new CreateBreakpointDialog((Window)this);
        dialog.setTitle("New Breakpoint");
        dialog.setVisible(true);
        if (dialog.isOk()) {
            this.setSelectedRow(this.tableModel.add(dialog.getBreakpoint()));
        }
    }
}

