/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.dipswitches;

import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import nintaco.App;
import nintaco.gui.dipswitches.DipSwitchesAppPrefs;
import nintaco.input.dipswitches.DipSwitch;
import nintaco.input.dipswitches.DipSwitchValue;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;

public class DipSwitchesDialog
extends JDialog {
    private final List<DipSwitch> dipSwitches;
    private final ActionListener comboBoxesListener = e -> this.selectionChanged();
    private JLabel[] dipSwitchLabels;
    private JComboBox[] dipSwitchComboBoxes;
    private boolean ok;
    private JButton cancelButton;
    private JButton defaultsButton;
    private JPanel dipSwichesPanel;
    private JCheckBox loadCheckBox;
    private JButton okButton;
    private JCheckBox resetCheckBox;

    public DipSwitchesDialog(Window parent, List<DipSwitch> dipSwitches) {
        super(parent);
        this.dipSwitches = dipSwitches;
        this.setModal(true);
        this.initComponents();
        this.initDipSwitchComponents();
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.boldAllLabels();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.selectionChanged();
    }

    private void initDipSwitchComponents() {
        this.dipSwitchLabels = new JLabel[this.dipSwitches.size()];
        this.dipSwitchComboBoxes = new JComboBox[this.dipSwitches.size()];
        GroupLayout dipSwichesPanelLayout = new GroupLayout(this.dipSwichesPanel);
        this.dipSwichesPanel.setLayout(dipSwichesPanelLayout);
        GroupLayout.ParallelGroup parallelGroup1 = dipSwichesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup parallelGroup2 = dipSwichesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup sequentialGroup = dipSwichesPanelLayout.createSequentialGroup().addContainerGap();
        for (int i = 0; i < this.dipSwitchLabels.length; ++i) {
            DipSwitch dipSwitch = this.dipSwitches.get(i);
            JLabel label = this.dipSwitchLabels[i] = new JLabel(dipSwitch.getName() + ":");
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            for (DipSwitchValue value : dipSwitch.getValues()) {
                model.addElement(value.getName());
            }
            JComboBox comboBox = this.dipSwitchComboBoxes[i] = new JComboBox(model);
            comboBox.addActionListener(this.comboBoxesListener);
            comboBox.setFocusable(false);
            parallelGroup1.addComponent(label);
            parallelGroup2.addComponent(comboBox);
            sequentialGroup.addGroup(dipSwichesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(comboBox));
            if (i == this.dipSwitchLabels.length - 1) {
                sequentialGroup.addContainerGap();
                continue;
            }
            sequentialGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        dipSwichesPanelLayout.setHorizontalGroup(dipSwichesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dipSwichesPanelLayout.createSequentialGroup().addContainerGap().addGroup(parallelGroup1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(parallelGroup2).addContainerGap()));
        dipSwichesPanelLayout.setVerticalGroup(dipSwichesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequentialGroup));
    }

    private void loadFields() {
        int[] dipSwitchValues = GamePrefs.getInstance().getDipSwitchesGamePrefs().getDipSwitchValues();
        for (int i = this.dipSwitchComboBoxes.length - 1; i >= 0; --i) {
            JComboBox comboBox = this.dipSwitchComboBoxes[i];
            comboBox.setSelectedIndex(MathUtil.clamp(i < dipSwitchValues.length ? dipSwitchValues[i] : this.dipSwitches.get(i).getDefaultValue(), 0, comboBox.getItemCount()));
        }
        DipSwitchesAppPrefs appPrefs = AppPrefs.getInstance().getDipSwitchesAppPrefs();
        this.loadCheckBox.setSelected(appPrefs.isDisplayDialogOnLoad());
        this.resetCheckBox.setSelected(appPrefs.isResetMachine());
    }

    private void saveFields() {
        int[] dipSwitchValues = new int[this.dipSwitchComboBoxes.length];
        for (int i = this.dipSwitchComboBoxes.length - 1; i >= 0; --i) {
            dipSwitchValues[i] = this.dipSwitchComboBoxes[i].getSelectedIndex();
        }
        GamePrefs.getInstance().getDipSwitchesGamePrefs().setDipSwitchValues(dipSwitchValues);
        GamePrefs.save();
        DipSwitchesAppPrefs appPrefs = AppPrefs.getInstance().getDipSwitchesAppPrefs();
        appPrefs.setDisplayDialogOnLoad(this.loadCheckBox.isSelected());
        appPrefs.setResetMachine(this.resetCheckBox.isSelected());
        AppPrefs.save();
    }

    private void closeDialog() {
        this.dispose();
    }

    private void boldAllLabels() {
        if (this.dipSwitchComboBoxes.length == 0) {
            return;
        }
        Font boldFont = this.dipSwitchLabels[0].getFont().deriveFont(1);
        for (int i = this.dipSwitchLabels.length - 1; i >= 0; --i) {
            this.dipSwitchLabels[i].setFont(boldFont);
        }
    }

    private void selectionChanged() {
        if (this.dipSwitchComboBoxes.length == 0) {
            return;
        }
        boolean resetButtonEnabled = false;
        Font plainFont = this.dipSwitchLabels[0].getFont().deriveFont(0);
        Font boldFont = this.dipSwitchLabels[0].getFont().deriveFont(1);
        for (int i = this.dipSwitchComboBoxes.length - 1; i >= 0; --i) {
            boolean notDefault = this.dipSwitchComboBoxes[i].getSelectedIndex() != this.dipSwitches.get(i).getDefaultValue();
            resetButtonEnabled |= notDefault;
            this.dipSwitchLabels[i].setFont(notDefault ? boldFont : plainFont);
        }
        this.defaultsButton.setEnabled(resetButtonEnabled);
    }

    public boolean isOK() {
        return this.ok;
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.dipSwichesPanel = new JPanel();
        this.loadCheckBox = new JCheckBox();
        this.resetCheckBox = new JCheckBox();
        this.defaultsButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("DIP Switches");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DipSwitchesDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DipSwitchesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DipSwitchesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.dipSwichesPanel.setBorder(BorderFactory.createTitledBorder("DIP Switches"));
        this.dipSwichesPanel.setMaximumSize(null);
        this.dipSwichesPanel.setName("");
        GroupLayout dipSwichesPanelLayout = new GroupLayout(this.dipSwichesPanel);
        this.dipSwichesPanel.setLayout(dipSwichesPanelLayout);
        dipSwichesPanelLayout.setHorizontalGroup(dipSwichesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        dipSwichesPanelLayout.setVerticalGroup(dipSwichesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.loadCheckBox.setSelected(true);
        this.loadCheckBox.setText("Display this dialog on file load");
        this.loadCheckBox.setFocusPainted(false);
        this.loadCheckBox.setFocusable(false);
        this.resetCheckBox.setSelected(true);
        this.resetCheckBox.setText("Reset machine after pressing OK");
        this.resetCheckBox.setFocusPainted(false);
        this.resetCheckBox.setFocusable(false);
        this.defaultsButton.setMnemonic('D');
        this.defaultsButton.setText("Defaults");
        this.defaultsButton.setFocusPainted(false);
        this.defaultsButton.setFocusable(false);
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DipSwitchesDialog.this.defaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.defaultsButton).addGap(18, 18, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.dipSwichesPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resetCheckBox).addComponent(this.loadCheckBox)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.defaultsButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.dipSwichesPanel, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.loadCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.resetCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.defaultsButton)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveFields();
        App.handleDipSwitchChange(this.dipSwitches);
        this.ok = true;
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        if (this.dipSwitchComboBoxes.length == 0) {
            return;
        }
        Font plainFont = this.dipSwitchLabels[0].getFont().deriveFont(0);
        for (int i = this.dipSwitchComboBoxes.length - 1; i >= 0; --i) {
            JComboBox comboBox = this.dipSwitchComboBoxes[i];
            comboBox.removeActionListener(this.comboBoxesListener);
            comboBox.setSelectedIndex(this.dipSwitches.get(i).getDefaultValue());
            comboBox.addActionListener(this.comboBoxesListener);
            this.dipSwitchLabels[i].setFont(plainFont);
        }
        this.defaultsButton.setEnabled(false);
    }
}

