/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.fonts;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import javax.imageio.ImageIO;
import nintaco.palettes.PalettePPU;
import nintaco.util.CollectionsUtil;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;

public final class FontUtil {
    private static final String FONT_FILE = "font.png";
    private static final String KERNING_FILE = "kerning.dat";
    private static final BufferedImage[] tiles = new BufferedImage[96];
    private static final int[][] pixels = new int[96][];
    private static final int[][] kernings = new int[96][96];
    private static final int DARK_BLUE = 1;
    private static final int BLUE = 17;
    private static final int WHITE = 48;
    private static int darkBlue;
    private static int blue;
    private static int white;
    private static PalettePPU palettePPU;
    private static int requestColor;
    private static int drawColor;

    private static void createKerningTable() throws Throwable {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(FontUtil.class.getResourceAsStream(KERNING_FILE)));){
            int value = 0;
            for (int i = 0; i < 96; ++i) {
                for (int j = 0; j < 96; ++j) {
                    int v;
                    if (MathUtil.isEven(j)) {
                        value = in.readUnsignedByte();
                        v = value >> 4;
                    } else {
                        v = value & 0xF;
                    }
                    FontUtil.kernings[i][j] = v + 1;
                }
            }
        }
    }

    private static void createTiles(BufferedImage image) {
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 16; ++x) {
                FontUtil.createTile(image, x, y);
            }
        }
    }

    private static void createTile(BufferedImage image, int x, int y) {
        int index = y << 4 | x;
        FontUtil.tiles[index] = new BufferedImage(8, 8, 2);
        FontUtil.pixels[index] = ((DataBufferInt)tiles[index].getRaster().getDataBuffer()).getData();
        int[] ps = FontUtil.pixels[index];
        image.getRGB(x << 3, y << 3, 8, 8, ps, 0, 8);
        for (int i = 63; i >= 0; --i) {
            ps[i] = (ps[i] & 0xFFFFFF) == 0xFFFFFF ? drawColor : 0;
        }
    }

    public static void setColor(int color) {
        requestColor = color;
    }

    public static int getColor() {
        return requestColor;
    }

    private static void updateColor() {
        int color = 0xFF000000 | requestColor & 0x1C0 | palettePPU.getMap()[requestColor & 0x3F];
        if (drawColor != color) {
            FontUtil.updateColor(color);
        }
    }

    private static void updateColor(int color) {
        drawColor = color;
        for (int i = 95; i >= 0; --i) {
            int[] ps = pixels[i];
            for (int j = 63; j >= 0; --j) {
                if (ps[j] == 0) continue;
                ps[j] = drawColor;
            }
        }
    }

    public static void drawChar(Graphics2D g, char c, int x, int y) {
        FontUtil.updateColor();
        g.drawImage((Image)tiles[(c & 0x7F) - 32], x, y, null);
    }

    public static void drawChars(Graphics2D g, char[] data, int offset, int length, int x, int y, boolean monospaced) {
        if (CollectionsUtil.isBlank(data) || offset < 0 || length < 0 || offset + length > data.length) {
            return;
        }
        int X = x;
        int b = 0;
        for (int i = 0; i < length; ++i) {
            char c = data[i + offset];
            if (monospaced) {
                if (i > 0) {
                    X += 8;
                }
            } else {
                int a = b;
                b = (c & 0x7F) - 32;
                if (i > 0) {
                    X += kernings[a][b];
                }
            }
            FontUtil.drawChar(g, c, X, y);
        }
    }

    public static void drawString(Graphics2D g, String str, int x, int y, boolean monospaced) {
        int X = x;
        int b = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (monospaced) {
                if (i > 0) {
                    X += 8;
                }
            } else {
                int a = b;
                b = (c & 0x7F) - 32;
                if (i > 0) {
                    X += kernings[a][b];
                }
            }
            FontUtil.drawChar(g, c, X, y);
        }
    }

    public static void drawChar(int[] screen, char c, int x, int y, boolean opaque) {
        if (y + 7 < 0 || x + 7 < 0 || y > 239 || x > 255) {
            return;
        }
        int yMin = y < 0 ? -y : 0;
        int yMax = y > 232 ? 239 - y : 7;
        int xMin = x < 0 ? -x : 0;
        int xMax = x > 248 ? 255 - x : 7;
        int[] ps = pixels[(c & 0x7F) - 32];
        for (int i = yMin; i <= yMax; ++i) {
            int j;
            int so = (i + y << 8) + x;
            int po = i << 3;
            if (opaque) {
                for (j = xMin; j <= xMax; ++j) {
                    screen[so + j] = ps[po + j] == 0 ? darkBlue : white;
                }
                continue;
            }
            for (j = xMin; j <= xMax; ++j) {
                if (ps[po + j] == 0) continue;
                screen[so + j] = white;
            }
        }
    }

    private static void fillRect(int[] screen, int x1, int y1, int x2, int y2, int color) {
        int t;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        if (y2 < 0 || x2 < 0 || y2 > 239 || x2 > 255) {
            return;
        }
        int yMin = y1 < 0 ? 0 : y1;
        int yMax = y2 > 239 ? 239 : y2;
        int xMin = x1 < 0 ? 0 : x1;
        int xMax = x2 > 255 ? 255 : x2;
        for (int i = yMin; i <= yMax; ++i) {
            int so = i << 8;
            for (int j = xMin; j <= xMax; ++j) {
                screen[so + j] = color;
            }
        }
    }

    public static int getWidth(char[] chars, boolean monospaced) {
        if (chars == null || chars.length == 0) {
            return 0;
        }
        int length = chars.length;
        if (monospaced) {
            return length << 3;
        }
        int width = 0;
        int b = 0;
        for (int i = 0; i < length; ++i) {
            int a = b;
            b = (chars[i] & 0x7F) - 32;
            if (i <= 0) continue;
            width += kernings[a][b];
        }
        return width + kernings[b][45];
    }

    public static int getWidth(String str, boolean monospaced) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int length = str.length();
        if (monospaced) {
            return length << 3;
        }
        int width = 0;
        int b = 0;
        for (int i = 0; i < length; ++i) {
            int a = b;
            b = (str.charAt(i) & 0x7F) - 32;
            if (i <= 0) continue;
            width += kernings[a][b];
        }
        return width + kernings[b][45];
    }

    public static void drawString(int[] screen, String str, int x, int y, boolean monospaced) {
        if (str == null || str.length() == 0) {
            return;
        }
        if (!monospaced) {
            FontUtil.fillRect(screen, x - 1, y - 1, x + FontUtil.getWidth(str, monospaced), y + 7, darkBlue);
        }
        int length = str.length();
        int X = x;
        int b = 0;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (monospaced) {
                if (i > 0) {
                    X += 8;
                }
            } else {
                int a = b;
                b = (c & 0x7F) - 32;
                if (i > 0) {
                    X += kernings[a][b];
                }
            }
            FontUtil.drawChar(screen, c, X, y, monospaced);
        }
        if (monospaced) {
            GuiUtil.drawVerticalLine(screen, x - 1, y, y + 7, darkBlue);
            GuiUtil.drawHorizontalLine(screen, x - 1, X + 7, y - 1, darkBlue);
            X += 8;
        } else {
            X += kernings[b][45] + 1;
        }
        GuiUtil.drawVerticalLine(screen, x - 2, y - 1, y + 7, blue);
        GuiUtil.drawVerticalLine(screen, X, y - 1, y + 7, blue);
        GuiUtil.drawHorizontalLine(screen, x - 2, X, y - 2, blue);
        GuiUtil.drawHorizontalLine(screen, x - 2, X, y + 8, blue);
    }

    public static void setPalettePPU(PalettePPU palettePPU) {
        FontUtil.palettePPU = palettePPU;
        int[] map = palettePPU.getMap();
        darkBlue = map[1];
        blue = map[17];
        white = map[48];
        FontUtil.updateColor();
    }

    private FontUtil() {
    }

    static {
        palettePPU = PalettePPU._2C02;
        requestColor = 48;
        drawColor = -16777168;
        try {
            FontUtil.createTiles(ImageIO.read(FontUtil.class.getResource(FONT_FILE)));
            FontUtil.createKerningTable();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

