/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import nintaco.MessageException;

public class CharTable {
    private final char[] chars = new char[256];
    private final String[] strings = new String[256];
    private final int[] values = new int[256];

    public CharTable() {
        for (int i = 0; i < 256; ++i) {
            if (i >= 32 && i <= 126) {
                this.chars[i] = (char)i;
                this.values[i] = i;
                continue;
            }
            this.chars[i] = 46;
            this.values[i] = -1;
        }
        this.createStrings();
    }

    public CharTable(String fileName) throws Throwable {
        this(new File(fileName));
    }

    public CharTable(File file) throws Throwable {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            this.loadFile(br);
        }
    }

    public CharTable(BufferedReader br) throws Throwable {
        this.loadFile(br);
    }

    private void createStrings() {
        for (int i = 0; i < 256; ++i) {
            this.strings[i] = Character.toString(this.chars[i]);
        }
    }

    private void loadFile(BufferedReader br) throws Throwable {
        for (int i = 0; i < 256; ++i) {
            this.values[i] = -1;
            this.chars[i] = 65535;
        }
        String input = null;
        int line = 0;
        while ((input = br.readLine()) != null) {
            int c;
            ++line;
            if ((input = input.trim()).isEmpty()) continue;
            String[] tokens = input.split("=");
            if (tokens.length != 2 || tokens[0].length() < 2 || tokens[1].length() < 1) {
                this.throwWrongForm(line);
            }
            int value = 0;
            try {
                value = Integer.parseInt(tokens[0].substring(0, 2), 16);
            }
            catch (Throwable t) {
                this.throwWrongForm(line);
            }
            int n = c = tokens[1].toLowerCase().startsWith("ret") ? 10 : (int)tokens[1].charAt(0);
            if (this.values[c & 0xFF] != -1 || this.chars[value] != '\uffff') {
                throw new MessageException("Error on line %d: Duplicate character mapping.", line);
            }
            this.chars[value] = c;
            this.values[c & 0xFF] = value;
        }
        for (int i = 0; i < 256; ++i) {
            if (this.chars[i] != '\uffff') continue;
            this.chars[i] = 46;
        }
        this.createStrings();
    }

    private void throwWrongForm(int line) throws MessageException {
        throw new MessageException("Error on line %d: Expected xx=c.", line);
    }

    public String getString(int value) {
        return this.strings[value & 0xFF];
    }

    public char getChar(int value) {
        return this.chars[value & 0xFF];
    }

    public int getValue(char c) {
        return this.values[c & 0xFF];
    }
}

