/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import nintaco.App;
import nintaco.Breakpoint;
import nintaco.Machine;
import nintaco.cheats.Cheat;
import nintaco.disassembler.AddressTextRange;
import nintaco.files.FdsFile;
import nintaco.files.NesFile;
import nintaco.files.UnifFile;
import nintaco.gui.InputDialog;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.StyleListener;
import nintaco.gui.cheats.CheatsDialog;
import nintaco.gui.debugger.DebuggerFrame;
import nintaco.gui.debugger.addresslabel.AddressLabelDialog;
import nintaco.gui.debugger.breakpoint.BreakpointDialog;
import nintaco.gui.hexeditor.CharTable;
import nintaco.gui.hexeditor.CpuDataSource;
import nintaco.gui.hexeditor.DataSource;
import nintaco.gui.hexeditor.Edit;
import nintaco.gui.hexeditor.FileDataSource;
import nintaco.gui.hexeditor.HexEditorFrame;
import nintaco.gui.hexeditor.NoDataSource;
import nintaco.gui.hexeditor.PpuDataSource;
import nintaco.gui.hexeditor.SearchDialog;
import nintaco.gui.hexeditor.SearchQuery;
import nintaco.gui.hexeditor.SearchText;
import nintaco.gui.hexeditor.Searcher;
import nintaco.gui.hexeditor.preferences.Bookmark;
import nintaco.gui.hexeditor.preferences.HexEditorAppPrefs;
import nintaco.gui.hexeditor.preferences.HexEditorGamePrefs;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;
import nintaco.util.StreamUtil;

public class HexEditorView
extends JComponent
implements StyleListener {
    static final int MARGIN = 1;
    private final DataSource[] dataSources = new DataSource[3];
    private final Rectangle clip = new Rectangle();
    private Font font;
    private HexEditorFrame hexEditorFrame;
    private Machine machine;
    private SearchDialog searchDialog;
    private Color[] changedColors;
    private Color[] selectedColors;
    private FontMetrics metrics;
    private int charWidth = 1;
    private int charHeight = 1;
    private int charAscent;
    private int addressMaxX;
    private Dimension preferredSize = new Dimension(0, 0);
    private boolean selecting;
    private boolean editing;
    private boolean selectedText;
    private int writeValue;
    private volatile int startViewAddress;
    private volatile int endViewAddress;
    private DataSource dataSource;
    private CharTable charTable = new CharTable();
    private int fadeColor;
    private int editColor;
    private int bookmarkColor;
    private int editBookmarkColor;

    public HexEditorView() {
        this.createFadeColors();
        this.styleChanged();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int address;
                if (HexEditorView.this.editing) {
                    HexEditorView.this.editing = false;
                    HexEditorView.this.repaint();
                }
                if (e.isPopupTrigger()) {
                    HexEditorView.this.showPopupMenu(e);
                } else if (e.getButton() == 1 && (address = HexEditorView.this.convertCoordinatesIntoAddress(e.getX(), e.getY())) >= 0) {
                    HexEditorView.this.selecting = true;
                    HexEditorView.this.dataSource.setSelection(address);
                    HexEditorView.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HexEditorView.this.showPopupMenu(e);
                } else if (e.getButton() == 1) {
                    HexEditorView.this.selectionEnded();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (HexEditorView.this.selecting && e.getButton() != 1) {
                    HexEditorView.this.selectionEnded();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (HexEditorView.this.selecting) {
                    int address = HexEditorView.this.convertCoordinatesIntoAddress(e.getX(), e.getY());
                    DataSource source = HexEditorView.this.dataSource;
                    if (address >= 0 && address != source.getEndSelectedAddress()) {
                        source.setEndSelectedAddress(address);
                        HexEditorView.this.repaint();
                    }
                }
            }
        });
    }

    private JMenuItem createBreakpointMenuItem(int startAddress, int endAddress) {
        if (endAddress > startAddress) {
            return new JMenuItem(String.format("Add Breakpoint for $%04X-%04X...", startAddress, endAddress));
        }
        return new JMenuItem(String.format("Add Breakpoint for $%04X...", startAddress));
    }

    private void applyBreakpoints() {
        App.setBreakpoints(GamePrefs.getInstance().getDebuggerGamePrefs().getBreakpoints());
    }

    public void addBreakpoint() {
        DataSource source = this.dataSource;
        if (source.getIndex() == 0) {
            int start = source.getStartSelectedAddress();
            int end = source.getEndSelectedAddress();
            if (start >= 0 && end >= 0) {
                if (end > start) {
                    int temp = end;
                    end = start;
                    start = temp;
                }
                this.showBreakpointDialog(3, start, end);
            }
        }
    }

    private void showBreakpointDialog(int breakpointType, int startAddress, int endAddress) {
        if (this.machine != null) {
            BreakpointDialog dialog = new BreakpointDialog((Window)App.getHexEditorFrame());
            if (startAddress >= 0) {
                dialog.setBreakpoint(new Breakpoint(breakpointType, -1, startAddress, startAddress == endAddress ? -1 : endAddress, true));
            }
            dialog.setVisible(true);
            if (dialog.isOk()) {
                this.applyBreakpoints();
            }
        }
    }

    public void showBreakpointDialog() {
        this.showBreakpointDialog(-1, -1, -1);
    }

    public void addAddressLabel() {
        int address;
        DataSource source = this.dataSource;
        if (source.getIndex() == 0 && (address = Math.min(source.getStartSelectedAddress(), source.getEndSelectedAddress())) >= 0) {
            this.showAddressLabelDialog(address);
        }
    }

    private void showAddressLabelDialog(int address) {
        DebuggerFrame debuggerFrame;
        AddressLabelDialog dialog = new AddressLabelDialog((Window)App.getHexEditorFrame());
        if (address >= 0) {
            dialog.setRange(new AddressTextRange(-1, address, -1, -1));
        }
        dialog.setVisible(true);
        if (dialog.isOk() && (debuggerFrame = App.getDebuggerFrame()) != null) {
            debuggerFrame.refreshAddressLabels();
        }
    }

    public void showAddressLabelsDialog() {
        this.showAddressLabelDialog(-1);
    }

    public void addCheat() {
        int address;
        DataSource source = this.dataSource;
        if (source.getIndex() == 0 && (address = Math.min(source.getStartSelectedAddress(), source.getEndSelectedAddress())) >= 0) {
            this.showCheatsDialog(address, source.peek(address));
        }
    }

    private void showCheatsDialog(int address, int value) {
        CheatsDialog dialog = new CheatsDialog((Window)App.getHexEditorFrame());
        if (address >= 0) {
            Cheat cheat = new Cheat(address, value & 0xFF);
            cheat.generateDescription();
            dialog.setNewCheat(cheat);
        }
        dialog.setVisible(true);
    }

    public void showCheatsDialog() {
        this.showCheatsDialog(-1, -1);
    }

    private void showPopupMenu(MouseEvent e) {
        JPopupMenu popupMenu = new JPopupMenu();
        DataSource source = this.dataSource;
        JMenuItem toggleBookmarkMenuItem = new JMenuItem("Toggle Bookmark");
        toggleBookmarkMenuItem.addActionListener(a -> this.toggleBookmark());
        popupMenu.add(toggleBookmarkMenuItem);
        if (source.getIndex() == 0) {
            int E;
            int S;
            int end;
            int start = source.getStartSelectedAddress();
            if (start <= (end = source.getEndSelectedAddress())) {
                S = start;
                E = end;
            } else {
                S = end;
                E = start;
            }
            if (S >= 0 && E >= 0) {
                popupMenu.add(new JSeparator());
                JMenuItem addBreakpointMenuItem = this.createBreakpointMenuItem(S, E);
                addBreakpointMenuItem.addActionListener(a -> this.showBreakpointDialog(3, S, E));
                popupMenu.add(addBreakpointMenuItem);
            }
            JMenuItem editBreakpointsMenuItem = new JMenuItem("Edit Breakpoints...");
            editBreakpointsMenuItem.addActionListener(a -> this.showBreakpointDialog());
            popupMenu.add(editBreakpointsMenuItem);
            if (S >= 0 && E >= 0) {
                popupMenu.add(new JSeparator());
                JMenuItem addAddressLabelMenuItem = new JMenuItem(String.format("Add Address Label for $%04X...", S));
                addAddressLabelMenuItem.addActionListener(a -> this.showAddressLabelDialog(S));
                popupMenu.add(addAddressLabelMenuItem);
            }
            JMenuItem editAddressLabelsMenuItem = new JMenuItem("Edit Address Labels...");
            editAddressLabelsMenuItem.addActionListener(a -> this.showAddressLabelsDialog());
            popupMenu.add(editAddressLabelsMenuItem);
            if (S >= 0 && E >= 0) {
                popupMenu.add(new JSeparator());
                JMenuItem addCheatMenuItem = new JMenuItem(String.format("Add Cheat for $%04X...", S));
                addCheatMenuItem.addActionListener(a -> this.showCheatsDialog(S, source.peek(S)));
                popupMenu.add(addCheatMenuItem);
            }
            JMenuItem cheatsMenuItem = new JMenuItem("Edit Cheats...");
            cheatsMenuItem.addActionListener(a -> this.showCheatsDialog());
            popupMenu.add(cheatsMenuItem);
        }
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public final void styleChanged() {
        this.font = GuiUtil.scaleFont(new Font("Monospaced", 0, GuiUtil.getDefaultFont(new JTextArea("M")).getSize()));
        this.setFont(this.font);
        this.metrics = null;
    }

    public final void createFadeColors() {
        HexEditorAppPrefs prefs = AppPrefs.getInstance().getHexEditorPrefs();
        this.editColor = prefs.getFadeFrames();
        this.bookmarkColor = this.editColor + 1;
        this.editBookmarkColor = this.bookmarkColor + 1;
        this.fadeColor = this.editColor - 1;
        this.changedColors = new Color[this.editBookmarkColor + 1];
        this.selectedColors = new Color[this.changedColors.length];
        for (int i = this.fadeColor; i >= 0; --i) {
            int value = 255 * i / this.fadeColor;
            this.changedColors[i] = new Color(value / 2, value, value);
            value = 255 - 127 * i / this.fadeColor;
            this.selectedColors[i] = new Color(value, 255, 255);
        }
        this.selectedColors[this.editColor] = this.changedColors[this.editColor] = Color.RED;
        this.selectedColors[this.editBookmarkColor] = this.changedColors[this.editBookmarkColor] = new Color(15038976);
        this.changedColors[this.bookmarkColor] = this.changedColors[this.editBookmarkColor];
        this.selectedColors[this.bookmarkColor] = this.changedColors[this.editBookmarkColor];
        this.repaint();
    }

    public void saveFile(PleaseWaitDialog pleaseWaitDialog, File file, int dataSourceIndex) {
        DataSource source = this.dataSources[dataSourceIndex];
        source.refreshCache();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            StreamUtil.writeBytes(out, source.getCache());
            pleaseWaitDialog.dispose();
        }
        catch (Throwable t) {
            pleaseWaitDialog.dispose();
            GuiUtil.displayError(this.hexEditorFrame, "Failed to save file.");
        }
        App.setNoStepPause(false);
    }

    private void selectionEnded() {
        this.selecting = false;
        this.repaint();
    }

    public void setHexEditorFrame(HexEditorFrame hexEditorFrame) {
        this.hexEditorFrame = hexEditorFrame;
    }

    public void showSearchDialog(boolean replace) {
        this.showSearchDialog(replace, "");
    }

    public void showSearchDialog(boolean replace, String findWhat) {
        if (this.searchDialog == null) {
            this.searchDialog = new SearchDialog(this.hexEditorFrame);
            this.searchDialog.setHexEditorView(this);
        }
        this.searchDialog.setCharTable(this.charTable);
        this.searchDialog.setData(this.selectedText ? SearchQuery.Data.Text : SearchQuery.Data.Hex);
        DataSource source = this.dataSource;
        int size = Math.abs(source.getStartSelectedAddress() - source.getEndSelectedAddress());
        this.searchDialog.setScope(SearchQuery.Scope.CurrentView);
        this.searchDialog.setReplaceWith("");
        if (size == 0 || !findWhat.isEmpty()) {
            this.searchDialog.setFindWhat(findWhat);
        } else if (size >= 16) {
            this.searchDialog.setFindWhat("");
            this.searchDialog.setScope(SearchQuery.Scope.Selection);
        } else {
            this.searchDialog.setFindWhat(this.getSelectedText(!this.selectedText));
        }
        this.searchDialog.setShowReplace(replace);
        this.searchDialog.setLocationRelativeTo(this.hexEditorFrame);
        EventQueue.invokeLater(() -> this.searchDialog.find());
        if (this.searchDialog.isVisible()) {
            GuiUtil.toFront(this.searchDialog);
        } else {
            this.searchDialog.setVisible(true);
        }
    }

    public void keyPressed(KeyEvent e) {
        boolean shiftPressed;
        if (this.selecting || (e.getModifiers() & 0xE) != 0) {
            return;
        }
        DataSource source = this.dataSource;
        int cacheSize = source.getSize();
        int code = e.getExtendedKeyCode();
        boolean bl = shiftPressed = (e.getModifiers() & 1) != 0;
        if (code == 8) {
            this.undo();
            return;
        }
        if (code == 38 || code == 40 || code == 37 || code == 39) {
            int address = shiftPressed ? source.getEndSelectedAddress() : source.getStartSelectedAddress();
            switch (code) {
                case 38: {
                    if (address < 16) break;
                    address -= 16;
                    break;
                }
                case 40: {
                    address += 16;
                    break;
                }
                case 37: {
                    if (address <= 0) break;
                    --address;
                    break;
                }
                case 39: {
                    ++address;
                }
            }
            source.setEndSelectedAddress(address);
            if (!shiftPressed) {
                source.setStartSelectedAddress(address);
            }
            this.repaint();
            return;
        }
        if (this.selectedText) {
            int value;
            char c = e.getKeyChar();
            if (shiftPressed) {
                c = Character.toUpperCase(c);
            }
            if ((value = this.charTable.getValue(c)) >= 0) {
                this.write(source.getStartSelectedAddress(), value, source);
                source.setStartSelectedAddress(source.getStartSelectedAddress() + 1);
                if (source.getStartSelectedAddress() >= cacheSize) {
                    source.setStartSelectedAddress(cacheSize - 1);
                }
                source.setEndSelectedAddress(source.getStartSelectedAddress());
                this.repaint();
            }
        } else {
            int value = -1;
            if (code >= 48 && code <= 57) {
                value = code - 48;
            } else if (code >= 96 && code <= 105) {
                value = code - 96;
            } else if (code >= 65 && code <= 70) {
                value = code - 55;
            }
            if (value >= 0) {
                if (this.editing) {
                    this.editing = false;
                    this.write(source.getStartSelectedAddress(), this.writeValue << 4 | value, source);
                    source.setStartSelectedAddress(source.getStartSelectedAddress() + 1);
                    if (source.getStartSelectedAddress() >= cacheSize) {
                        source.setStartSelectedAddress(cacheSize - 1);
                    }
                } else {
                    this.editing = true;
                    this.writeValue = value;
                }
                source.setEndSelectedAddress(source.getStartSelectedAddress());
                this.repaint();
            } else if (this.editing || code == 27) {
                this.editing = false;
                this.repaint();
            }
        }
    }

    public Searcher.Result search(SearchQuery searchQuery) {
        String replaceText;
        SearchText replaceWith;
        Searcher.Result result = Searcher.findNext(this.dataSources, this.dataSource, searchQuery, this.charTable);
        if (result == Searcher.NOT_FOUND) {
            return result;
        }
        if (!(searchQuery.getType() == SearchQuery.Type.FindNext || (replaceWith = searchQuery.getReplaceWith()) == null || (replaceText = replaceWith.getValue()) == null || replaceText.isEmpty() || searchQuery.getData() == SearchQuery.Data.Hex && replaceText.trim().isEmpty())) {
            this.paste(result.getSource(), result.getStart(), replaceText, searchQuery.getData() == SearchQuery.Data.Text, false);
        }
        DataSource source = result.getSource();
        if (searchQuery.getScope() == SearchQuery.Scope.Selection) {
            source.setStartSelectedAddress(result.getEnd() + 1);
            if (source.getEndSelectedAddress() < source.getStartSelectedAddress()) {
                source.setEndSelectedAddress(source.getStartSelectedAddress());
            }
        } else {
            source.setStartSelectedAddress(result.getStart());
            source.setEndSelectedAddress(result.getEnd());
        }
        if (this.dataSource != source) {
            this.hexEditorFrame.setDataSource(source.getIndex());
            this.setDataSource(source);
        }
        EventQueue.invokeLater(() -> {
            this.centerAddressIfNotVisible(source, result.getStart());
            this.repaint();
        });
        return result;
    }

    public void update() {
        DataSource source = this.dataSource;
        if (source == null || source.getIndex() == 2 || source.getSize() == 0) {
            return;
        }
        int startAddress = this.startViewAddress;
        int endAddress = this.endViewAddress;
        if (startAddress > endAddress) {
            return;
        }
        int[] cache = source.getCache();
        if (startAddress >= cache.length) {
            startAddress = cache.length - 1;
        } else if (startAddress < 0) {
            startAddress = 0;
        }
        if (endAddress >= cache.length) {
            endAddress = cache.length - 1;
        } else if (endAddress < 0) {
            endAddress = 0;
        }
        for (int i = startAddress; i <= endAddress; ++i) {
            int lastValue = cache[i] & 0xFF;
            int color = cache[i] >> 8 & 0xFF;
            int value = source.peek(i);
            boolean changed = false;
            if (value != lastValue && color <= this.editColor) {
                cache[i] = cache[i] & 0xFFFF0000 | this.fadeColor << 8 | value;
                changed = true;
            } else if (color > 0 && color <= this.fadeColor) {
                cache[i] = cache[i] & 0xFFFF00FF | color - 1 << 8;
                changed = true;
            }
            if (!changed) continue;
            int nibble = i & 0xF;
            int x = 1 + (9 + 3 * nibble) * this.charWidth;
            int y = 1 + (i >> 4) * this.charHeight;
            int x2 = 1 + (60 + nibble) * this.charWidth;
            EventQueue.invokeLater(() -> this.repaint(x, y, this.charWidth << 1, this.charHeight));
            EventQueue.invokeLater(() -> this.repaint(x2, y, this.charWidth, this.charHeight));
        }
    }

    private String getSelectedText(boolean spaced) {
        int end;
        DataSource source = this.dataSource;
        int start = source.getStartSelectedAddress();
        if (start > (end = source.getEndSelectedAddress())) {
            int temp = start;
            start = end;
            end = temp;
        }
        StringBuilder sb = new StringBuilder();
        int[] cache = source.getCache();
        if (this.selectedText) {
            for (int i = start; i <= end && i < cache.length; ++i) {
                if (i > start && spaced) {
                    sb.append(' ');
                }
                sb.append(this.charTable.getChar(cache[i] & 0xFF));
            }
        } else {
            for (int i = start; i <= end && i < cache.length; ++i) {
                if (i > start && spaced) {
                    sb.append(' ');
                }
                sb.append(String.format("%02X", cache[i] & 0xFF));
            }
        }
        return sb.toString();
    }

    public void copy(boolean spaced) {
        GuiUtil.setClipboardString(this.getSelectedText(spaced));
    }

    public void paste() {
        DataSource source = this.dataSource;
        if (source.getSize() == 0) {
            return;
        }
        this.paste(source, source.getStartSelectedAddress(), GuiUtil.getClipboardString(), this.selectedText, true);
    }

    public void paste(DataSource source, int start, String text, boolean pasteText, boolean modifySelection) {
        int i;
        int[] values = null;
        boolean edited = false;
        if (pasteText) {
            values = new int[text.length()];
            for (i = values.length - 1; i >= 0; --i) {
                int address = start + i;
                int value = this.charTable.getValue(text.charAt(i));
                int cachedValue = source.readCache(address);
                int color = cachedValue & 0xFF00;
                int priorValue = source.peek(address);
                values[i] = color | priorValue;
                if (value < 0) continue;
                source.write(address, value);
                if (priorValue != source.peek(address)) {
                    edited = true;
                    source.writeCache(address, this.markEdited(value));
                    continue;
                }
                source.writeCache(address, color | value & 0xFF);
            }
        } else {
            text = text.replaceAll("\\s", "");
            values = new int[text.length() >> 1];
            for (i = values.length - 1; i >= 0; --i) {
                int address = start + i;
                int offset = i << 1;
                int value = 0;
                try {
                    value = Integer.parseInt(text.substring(offset, offset + 2), 16);
                }
                catch (Throwable color) {
                    // empty catch block
                }
                int cachedValue = source.readCache(address);
                int color = cachedValue & 0xFF00;
                int priorValue = source.peek(address);
                values[i] = color | priorValue;
                source.write(address, value);
                if (priorValue != source.peek(address)) {
                    edited = true;
                    source.writeCache(address, this.markEdited(value));
                    continue;
                }
                source.writeCache(address, color | value & 0xFF);
            }
        }
        if (edited) {
            source.addEdit(new Edit(start, values));
        }
        if (modifySelection) {
            int address = start + values.length;
            if (address >= source.getSize()) {
                address = source.getSize() - 1;
            }
            if (address < 0) {
                address = 0;
            }
            source.setSelection(address);
        }
        this.repaint();
    }

    public void undo() {
        DataSource source = this.dataSource;
        int editIndex = source.getEditIndex() - 1;
        if (editIndex >= 0) {
            this.makeEdit(source, editIndex, false);
            source.setEditIndex(editIndex);
        }
    }

    public void redo() {
        DataSource source = this.dataSource;
        int editIndex = source.getEditIndex();
        if (editIndex < source.getEdits().size()) {
            this.makeEdit(source, editIndex, true);
            source.setEditIndex(editIndex + 1);
        }
    }

    private void makeEdit(DataSource source, int editIndex, boolean redo) {
        Edit edit = source.getEdits().get(editIndex);
        int start = edit.getAddress();
        int[] values = edit.getValues();
        for (int i = values.length - 1; i >= 0; --i) {
            int address = start + i;
            int value = source.readColored(address);
            source.write(address, values[i]);
            source.writeCache(address, values[i]);
            values[i] = value;
        }
        int address = edit.getAddress();
        if (redo) {
            address += values.length;
        }
        if (address >= source.getSize()) {
            address = source.getSize() - 1;
        }
        if (address < 0) {
            address = 0;
        }
        source.setStartSelectedAddress(address);
        source.setEndSelectedAddress(address);
        this.centerAddressIfNotVisible(source, address);
        this.repaint();
    }

    public void selectAll() {
        DataSource source = this.dataSource;
        source.setStartSelectedAddress(0);
        source.setEndSelectedAddress(source.getSize() - 1);
        this.repaint();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(int index) {
        this.setDataSource(this.dataSources[index]);
    }

    private void setDataSource(DataSource dataSource) {
        if (EventQueue.isDispatchThread()) {
            dataSource.refreshCache();
            this.dataSource = dataSource;
            this.metrics = null;
            this.editing = false;
            this.selecting = false;
            this.repaint();
        } else {
            EventQueue.invokeLater(() -> this.setDataSource(dataSource));
        }
    }

    public void setCharTable(CharTable charTable) {
        if (EventQueue.isDispatchThread()) {
            this.charTable = charTable;
            this.repaint();
        } else {
            EventQueue.invokeLater(() -> this.setCharTable(charTable));
        }
    }

    public CharTable getCharTable() {
        return this.charTable;
    }

    public void toggleBookmark() {
        block8: {
            InputDialog dialog;
            String input;
            String formattedAddress;
            DataSource source = this.dataSource;
            if (source.isEmpty()) {
                return;
            }
            int address = source.getSelectedAddress();
            HexEditorGamePrefs prefs = GamePrefs.getInstance().getHexEditorGamePrefs();
            if (prefs.containsBookmark(this.dataSource.getIndex(), address)) {
                prefs.removeBookmark(this.dataSource.getIndex(), address);
                this.bookmarksUpdated();
                return;
            }
            switch (source.getIndex()) {
                case 0: {
                    formattedAddress = String.format("CPU $%04X", address);
                    break;
                }
                case 1: {
                    formattedAddress = String.format("PPU $%04X", address);
                    break;
                }
                case 2: {
                    formattedAddress = String.format("File $%06X", address);
                    break;
                }
                default: {
                    formattedAddress = "";
                }
            }
            do {
                dialog = new InputDialog((Window)this.hexEditorFrame, "Bookmark name", "Create Bookmark");
                dialog.setInput(formattedAddress);
                dialog.setOkButtonText("Create");
                dialog.setOkButtonMnemonic('r');
                dialog.setTextRequired();
                dialog.setVisible(true);
                if (!dialog.isOk()) break block8;
            } while ((input = dialog.getInput().trim()).isEmpty());
            prefs.addBookmark(source.getIndex(), address, input);
            this.bookmarksUpdated();
        }
    }

    private void bookmarksUpdated() {
        GamePrefs.save();
        this.hexEditorFrame.updateBookmarksMenu();
        this.colorBookmarks();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void colorBookmarks() {
        Set[] addresses = new Set[3];
        for (int i = addresses.length - 1; i >= 0; --i) {
            addresses[i] = new HashSet();
        }
        Class<GamePrefs> i = GamePrefs.class;
        synchronized (GamePrefs.class) {
            for (Bookmark bookmark : GamePrefs.getInstance().getHexEditorGamePrefs().getBookmarks()) {
                addresses[bookmark.getDataSourceIndex()].add(bookmark.getAddress());
            }
            // ** MonitorExit[i] (shouldn't be in output)
            for (int i2 = this.dataSources.length - 1; i2 >= 0; --i2) {
                int[] cache = this.dataSources[i2].getCache();
                Set as = addresses[i2];
                for (int j = cache.length - 1; j >= 0; --j) {
                    int color = cache[j] >> 8 & 0xFF;
                    if (as.contains(j)) {
                        if (color <= this.editColor) {
                            color = color == this.editColor ? this.editBookmarkColor : this.bookmarkColor;
                        }
                    } else if (color == this.editBookmarkColor) {
                        color = this.editColor;
                    } else if (color == this.bookmarkColor) {
                        color = 0;
                    }
                    cache[j] = color << 8 | cache[j] & 0xFFFF00FF;
                }
            }
            return;
        }
    }

    public void removeAllBookmarks() {
        GamePrefs.getInstance().getHexEditorGamePrefs().removeAllBookmarks();
        this.bookmarksUpdated();
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
        if (machine == null) {
            for (int i = this.dataSources.length - 1; i >= 0; --i) {
                this.dataSources[i] = new NoDataSource(i);
            }
        } else {
            this.dataSources[0] = new CpuDataSource(machine.getMapper());
            this.dataSources[1] = new PpuDataSource(machine.getPPU());
            NesFile nesFile = App.getNesFile();
            UnifFile unifFile = App.getUnifFile();
            FdsFile fdsFile = App.getFdsFile();
            this.dataSources[2] = nesFile != null ? new FileDataSource(nesFile, machine.getMapper()) : (unifFile != null ? new FileDataSource(unifFile) : (fdsFile != null ? new FileDataSource(fdsFile) : new NoDataSource(2)));
        }
        this.setDataSource(this.dataSources[this.dataSource == null ? 0 : this.dataSource.getIndex()]);
    }

    public Machine getMachine() {
        return this.machine;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    private int convertCoordinatesIntoAddress(int x, int y) {
        int column = (x - 1) / this.charWidth;
        int row = (y - 1) / this.charHeight;
        if (column >= 60 && column <= 75) {
            this.selectedText = true;
            return row << 4 | column - 60;
        }
        if (column >= 9 && column <= 56) {
            this.selectedText = false;
            return row << 4 | (column - 9) / 3;
        }
        return -1;
    }

    public int getFileIndex() {
        DataSource source = this.dataSource;
        if (source.getIndex() == 2 || source.isEmpty()) {
            return -1;
        }
        int index = App.getFileIndex(source.getSelectedAddress(), source.getIndex() == 0);
        DataSource fileSource = this.dataSources[2];
        if (index < 0 || index >= fileSource.getSize()) {
            return -1;
        }
        return index;
    }

    public void goToBookmark(Bookmark bookmark) {
        this.goToAddress(bookmark.getDataSourceIndex(), bookmark.getAddress());
    }

    public boolean goToAddress(int dataSourceIndex, int address) {
        DataSource source = this.dataSources[dataSourceIndex];
        if (address < 0 || address >= source.getSize()) {
            return false;
        }
        source.setSelection(address);
        if (dataSourceIndex != this.dataSource.getIndex()) {
            this.setDataSource(dataSourceIndex);
        }
        this.goToAddress(address);
        return true;
    }

    public void goToAddress(int address) {
        this.centerAddressIfNotVisible(this.dataSource, address);
        this.repaint();
    }

    private void centerAddressIfNotVisible(DataSource source, int address) {
        JViewport viewport = (JViewport)this.getParent();
        JScrollPane scrollPane = (JScrollPane)viewport.getParent();
        JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
        Rectangle r = viewport.getViewRect();
        int startAddress = MathUtil.roundUpDivision(r.y, this.charHeight) << 4;
        int endAddress = (r.y + r.height) / this.charHeight << 4;
        if (address < startAddress || address > endAddress) {
            source.setScrollY(1 + this.charHeight * ((address -= (r.height >> 1) / this.charHeight << 4) >> 4));
            scrollBar.setValue(source.getScrollY());
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int address;
        int i;
        int lineAddress;
        int y;
        int endOffset;
        int startOffset;
        int y2;
        g.getClipBounds(this.clip);
        DataSource source = this.dataSource;
        JViewport viewport = (JViewport)this.getParent();
        JScrollPane scrollPane = (JScrollPane)viewport.getParent();
        JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
        if (this.metrics == null) {
            this.metrics = g.getFontMetrics(this.font);
            this.charWidth = this.metrics.getWidths()[77];
            this.charHeight = this.metrics.getHeight();
            this.charAscent = this.metrics.getAscent();
            this.addressMaxX = 1 + 6 * this.charWidth;
            this.preferredSize = new Dimension(2 + 76 * this.charWidth, 2 + (source.getSize() >> 4) * this.charHeight);
            scrollBar.setUnitIncrement(this.charHeight);
            scrollBar.setBlockIncrement(16 * this.charHeight);
            EventQueue.invokeLater(() -> scrollPane.setViewportView(null));
            EventQueue.invokeLater(() -> scrollPane.setViewportView(this));
            EventQueue.invokeLater(scrollPane::updateUI);
            EventQueue.invokeLater(() -> scrollBar.setValue(source.getScrollY()));
        } else {
            source.setScrollY(scrollBar.getValue());
        }
        Rectangle r = viewport.getViewRect();
        this.startViewAddress = (r.y - 1) / this.charHeight << 4;
        this.endViewAddress = (r.y + r.height - 1) / this.charHeight << 4;
        g.setColor(Color.WHITE);
        g.fillRect(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
        int startRow = (this.clip.y - 1) / this.charHeight;
        int startY = 1 + startRow * this.charHeight + this.charAscent;
        int startAddress = startRow << 4;
        int startColumn = (this.clip.x - 1) / this.charWidth;
        int endColumn = MathUtil.roundUpDivision(this.clip.x + this.clip.width - 1, this.charWidth);
        int endRow = MathUtil.roundUpDivision(this.clip.y + this.clip.height - 1, this.charHeight);
        int endY = 1 + endRow * this.charHeight + this.charAscent;
        int startSelected = source.getStartSelectedAddress();
        int endSelected = source.getEndSelectedAddress();
        if (startSelected > endSelected) {
            int temp = endSelected;
            endSelected = startSelected;
            startSelected = temp;
        }
        if (startSelected < 0) {
            startSelected = 0;
        }
        if (endSelected < 0) {
            endSelected = 0;
        }
        g.setColor(Color.BLACK);
        if (startColumn <= 5) {
            y2 = startY;
            int address2 = startAddress;
            while (y2 <= endY) {
                g.drawString(String.format("%06X", address2), 1, y2);
                y2 += this.charHeight;
                address2 += 16;
            }
        }
        if (startColumn <= 6 && endColumn >= 6) {
            for (y2 = startY; y2 <= endY; y2 += this.charHeight) {
                g.drawString(":", this.addressMaxX, y2);
            }
        }
        if (startColumn <= 56 && endColumn >= 9) {
            startOffset = (startColumn - 9) / 3;
            endOffset = (endColumn - 9) / 3;
            if (startOffset < 0) {
                startOffset = 0;
            }
            if (endOffset > 15) {
                endOffset = 15;
            }
            y = startY;
            lineAddress = startAddress;
            while (y <= endY) {
                for (i = startOffset; i <= endOffset; ++i) {
                    address = lineAddress | i;
                    int x = 1 + (9 + i * 3) * this.charWidth;
                    boolean selected = startSelected <= address && address <= endSelected;
                    int v = source.readCache(address);
                    if (selected) {
                        g.setColor(Color.BLACK);
                        g.fillRect(x, y - this.charAscent, this.charWidth << 1, this.charHeight);
                        g.setColor(this.selectedColors[v >> 8 & 0xFF]);
                    } else {
                        g.setColor(this.changedColors[v >> 8 & 0xFF]);
                    }
                    g.drawString(String.format("%02X", v & 0xFF), x, y);
                    if (!selected || !this.editing) continue;
                    g.setColor(Color.WHITE);
                    g.fillRect(x, y - this.charAscent, this.charWidth, this.charHeight);
                    g.setColor(Color.RED);
                    g.drawString(String.format("%X", this.writeValue), x, y);
                }
                y += this.charHeight;
                lineAddress += 16;
            }
        }
        g.setColor(Color.BLACK);
        if (startColumn <= 58 && endColumn >= 58) {
            int x = 1 + 58 * this.charWidth;
            for (int y3 = startY; y3 <= endY; y3 += this.charHeight) {
                g.drawString(":", x, y3);
            }
        }
        if (startColumn <= 75 && endColumn >= 60) {
            startOffset = startColumn - 60;
            endOffset = endColumn - 60;
            if (startOffset < 0) {
                startOffset = 0;
            }
            if (endOffset > 15) {
                endOffset = 15;
            }
            y = startY;
            lineAddress = startAddress;
            while (y <= endY) {
                for (i = startOffset; i <= endOffset; ++i) {
                    boolean selected;
                    address = lineAddress | i;
                    int v = source.readCache(address);
                    int c = v & 0xFF;
                    int x = 1 + (60 + i) * this.charWidth;
                    boolean bl = selected = startSelected <= address && address <= endSelected;
                    if (selected) {
                        g.setColor(Color.BLACK);
                        g.fillRect(x, y - this.charAscent, this.charWidth, this.charHeight);
                        g.setColor(this.selectedColors[v >> 8 & 0xFF]);
                    } else {
                        g.setColor(this.changedColors[v >> 8 & 0xFF]);
                    }
                    g.drawString(this.charTable.getString(c), x, y);
                }
                y += this.charHeight;
                lineAddress += 16;
            }
        }
    }

    private int markEdited(int value) {
        return this.editColor << 8 | value & 0xFF;
    }

    private void write(int address, int value, DataSource source) {
        if (address < 0 || address >= source.getSize()) {
            return;
        }
        int cachedValue = source.readCache(address);
        int color = cachedValue & 0xFF00;
        int priorValue = source.peek(address);
        source.write(address, value);
        if (priorValue != source.peek(address)) {
            source.addEdit(new Edit(address, color | priorValue));
            source.writeCache(address, this.markEdited(value));
        } else {
            source.writeCache(address, color | value & 0xFF);
        }
    }
}

