/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.change;

import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nintaco.gui.IntPoint;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.gui.historyeditor.change.RangeChange;
import nintaco.movie.Movie;
import nintaco.movie.MovieBlock;

public class DeleteChange
extends RangeChange
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected final int rowCount;
    protected byte[] saveState;
    protected byte[] priorSaveState;

    public DeleteChange(int rowIndex, int rowCount) {
        super(rowIndex, new int[rowCount]);
        this.rowCount = rowCount;
    }

    public byte[] getSaveState() {
        return this.saveState;
    }

    public void setSaveState(byte[] saveState) {
        this.saveState = saveState;
    }

    @Override
    public int apply(HistoryTableModel model) {
        Movie movie = model.getMovie();
        List<MovieBlock> blocks = null;
        if (movie != null) {
            movie.clearCachedFrames();
            blocks = movie.getMovieBlocks();
        }
        if (this.saveState != null && blocks != null && !blocks.isEmpty()) {
            this.priorSaveState = blocks.get((int)0).saveState;
        }
        int row = this.delete(model);
        if (this.saveState != null && blocks != null && !blocks.isEmpty()) {
            blocks.get((int)0).saveState = this.saveState;
        }
        return row;
    }

    @Override
    public int revert(HistoryTableModel model) {
        Movie movie = model.getMovie();
        List<MovieBlock> blocks = null;
        if (movie != null) {
            movie.clearCachedFrames();
            blocks = movie.getMovieBlocks();
        }
        int row = this.insert(model);
        if (this.saveState != null && blocks != null && !blocks.isEmpty()) {
            blocks.get((int)0).saveState = this.priorSaveState;
        }
        return row;
    }

    @Override
    public Map<IntPoint, Color> heat(HistoryTableModel model, int[] columnIndices, Map<IntPoint, Color> hotCells, Color color) {
        HashMap<IntPoint, Color> hcs = new HashMap<IntPoint, Color>();
        for (Map.Entry<IntPoint, Color> entry : hotCells.entrySet()) {
            IntPoint p = entry.getKey();
            if (p.y < this.rowIndex) {
                hcs.put(p, entry.getValue());
                continue;
            }
            if (p.y < this.rowIndex + this.rowCount) continue;
            hcs.put(new IntPoint(p.x, p.y - this.rowCount), entry.getValue());
        }
        return hcs;
    }
}

