/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.change;

import java.awt.Color;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import nintaco.gui.IntPoint;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.gui.historyeditor.change.HistoryChange;
import nintaco.util.CollectionsUtil;

public class Multichange<T extends HistoryChange>
extends HistoryChange
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final T[] changes;

    public Multichange(List<T> changes) {
        this((HistoryChange[])CollectionsUtil.convertToArray(changes));
    }

    public Multichange(T[] changes) {
        this.changes = changes;
    }

    @Override
    public int apply(HistoryTableModel model) {
        int rowIndex = Integer.MAX_VALUE;
        for (int i = 0; i < this.changes.length; ++i) {
            int row = ((HistoryChange)this.changes[i]).apply(model);
            if (row < 0 || row >= rowIndex || row >= model.getRowCount()) continue;
            rowIndex = row;
        }
        return rowIndex;
    }

    @Override
    public int revert(HistoryTableModel model) {
        int rowIndex = Integer.MAX_VALUE;
        for (int i = this.changes.length - 1; i >= 0; --i) {
            int row = ((HistoryChange)this.changes[i]).revert(model);
            if (row < 0 || row >= rowIndex || row >= model.getRowCount()) continue;
            rowIndex = row;
        }
        return rowIndex;
    }

    @Override
    public Map<IntPoint, Color> heat(HistoryTableModel model, int[] columnIndices, Map<IntPoint, Color> hotCells, Color color) {
        for (int i = 0; i < this.changes.length; ++i) {
            hotCells = ((HistoryChange)this.changes[i]).heat(model, columnIndices, hotCells, color);
        }
        return hotCells;
    }
}

