/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.image;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.swing.JComponent;
import nintaco.App;
import nintaco.ScreenRenderer;
import nintaco.gui.fonts.FontUtil;
import nintaco.gui.image.CursorType;
import nintaco.gui.image.filters.VideoFilter;
import nintaco.gui.image.filters.VideoFilterDescriptor;
import nintaco.gui.image.preferences.View;
import nintaco.gui.overscan.OverscanPrefs;
import nintaco.gui.screenshots.ScreenshotSaver;
import nintaco.input.InputUtil;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.tv.PixelAspectRatio;
import nintaco.tv.ScreenBorders;
import nintaco.tv.TVSystem;
import nintaco.util.GuiUtil;
import nintaco.util.ThreadUtil;

public class ImagePane
extends JComponent
implements ScreenRenderer {
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_HEIGHT = 240;
    private static final int CURSOR_TIMEOUT = 120;
    private static final int MESSAGE_TIMEOUT = 120;
    private static final long FPS_INTERVAL = 1250000000L;
    private static final String DEFAULT_FPS_STRING = "         ";
    private final Toolkit toolkit = Toolkit.getDefaultToolkit();
    private final Cursor crosshairsCursor;
    private final Cursor blankCursor;
    private final Object screenMonitor = new Object();
    private final int[][] screens = new int[4][61440];
    private final Thread renderThread = new Thread(this::renderLoop, "Render Thread");
    private final BufferedImage image = new BufferedImage(256, 240, 1);
    private final int[] data = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    private CursorType cursorType = CursorType.Default;
    private volatile boolean cursorVisible = true;
    private volatile int cursorCounter = 120;
    private volatile boolean hideInactiveMouseCursor;
    private volatile boolean hideFullscreenMouseCursor;
    private int writeIndex;
    private int lastWriteIndex;
    private int readIndex;
    private volatile BufferStrategy bufferStrategy;
    private volatile int imageX;
    private volatile int imageY;
    private volatile int imageWidth;
    private volatile int imageHeight;
    private volatile int imageTop;
    private volatile int imageBottom;
    private volatile int imageLeft;
    private volatile int imageRight;
    private volatile int paneWidth;
    private volatile int paneHeight;
    private volatile Bars bars = Bars.NONE;
    private volatile BufferedImage paintImage;
    private volatile int[] palette = PaletteUtil.getExtendedPalette(TVSystem.NTSC);
    private volatile TVSystem tvSystem;
    private volatile ScreenBorders screenBorders = TVSystem.NTSC.getScreenBorders();
    private volatile PixelAspectRatio pixelAspectRatio = PixelAspectRatio.SQUARE;
    private volatile boolean useTvAspectRatio;
    private volatile boolean smoothScaling;
    private volatile boolean uniformPixelScaling;
    private volatile int screenScale = 2;
    private int lastFrameColor;
    private volatile Color frameColor = Color.BLACK;
    private volatile VideoFilterDescriptor videoFilterDescriptor = VideoFilterDescriptor.NoFilter;
    private volatile VideoFilter[] videoFilters;
    private volatile FilterThread[] filterThreads = new FilterThread[0];
    private int runningThreads;
    private int filterScale = 1;
    private double filterScaleX = 1.0;
    private double filterScaleY = 1.0;
    private boolean repaintRequested;
    private volatile boolean rendering = true;
    private volatile boolean requestScreenshot;
    private volatile boolean showFPS;
    private volatile boolean showStatusMessages;
    private volatile boolean rewinding;
    private volatile boolean paused;
    private volatile String message;
    private volatile int messageTimer;
    private int generatedFrames;
    private int displayedFrames;
    private long frameTime;
    private String fpsStr = "         ";

    public ImagePane() {
        View view = AppPrefs.getInstance().getView();
        this.setShowFPS(view.isShowFPS());
        this.setShowStatusMessages(view.isShowStatusMessages());
        this.renderThread.start();
        this.createVideoFilterThreads();
        this.paintImage = this.image;
        for (int i = this.screens.length - 1; i >= 0; --i) {
            Arrays.fill(this.screens[i], PaletteUtil.getPalettePPU().getMap()[15]);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ImagePane.this.paneResized();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ImagePane.this.paneResized();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                InputUtil.setMouseCoordinates(-1);
                ImagePane.this.showCursor();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ImagePane.this.showCursor();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (x >= ImagePane.this.imageX && y >= ImagePane.this.imageY && x < ImagePane.this.imageX + ImagePane.this.imageWidth && y < ImagePane.this.imageY + ImagePane.this.imageHeight) {
                    x = ((ImagePane)ImagePane.this).screenBorders.left + (x - ImagePane.this.imageX) * (256 - ((ImagePane)ImagePane.this).screenBorders.left - ((ImagePane)ImagePane.this).screenBorders.right) / ImagePane.this.imageWidth;
                    y = ((ImagePane)ImagePane.this).screenBorders.top + (y - ImagePane.this.imageY) * (240 - ((ImagePane)ImagePane.this).screenBorders.top - ((ImagePane)ImagePane.this).screenBorders.bottom) / ImagePane.this.imageHeight;
                    InputUtil.setMouseCoordinates(256 * y + x);
                } else {
                    InputUtil.setMouseCoordinates(-1);
                }
                ImagePane.this.showCursor();
            }
        });
        this.adjustPreferredSize();
        this.crosshairsCursor = GuiUtil.getCursor("nintaco/gui/image/crosshairs.png", new Point(15, 15));
        this.blankCursor = this.toolkit.createCustomCursor(new BufferedImage(16, 16, 2), new Point(0, 0), "blank cursor");
    }

    public void createVideoFilterThreads() {
        App.runVsDualImagePane(this, ImagePane::createVideoFilterThreads);
        this.createVideoFilterThreads(AppPrefs.getInstance().getUserInterfacePrefs().isUseMulticoreFiltering() ? Math.max(1, Runtime.getRuntime().availableProcessors() - 1) : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createVideoFilterThreads(int count) {
        Class<FilterThread> clazz = FilterThread.class;
        synchronized (FilterThread.class) {
            if (count != this.filterThreads.length) {
                int i;
                this.destroyVideoFilterThreads();
                this.filterThreads = new FilterThread[count];
                int scanlines = 240 / count;
                for (i = count - 1; i >= 0; --i) {
                    this.filterThreads[i] = new FilterThread(i, scanlines * i, i == count - 1 ? 240 : scanlines * (i + 1));
                }
                this.createVideoFilters();
                for (i = count - 1; i >= 0; --i) {
                    this.filterThreads[i].start();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void destroy() {
        this.rendering = false;
        this.destroyVideoFilterThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyVideoFilterThreads() {
        Class<FilterThread> clazz = FilterThread.class;
        synchronized (FilterThread.class) {
            for (int i = this.filterThreads.length - 1; i >= 0; --i) {
                this.filterThreads[i].dispose();
            }
            ThreadUtil.joinAll(this.filterThreads);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setVideoFilterDescriptor(VideoFilterDescriptor videoFilterDescriptor) {
        App.runVsDualImagePane(this, p -> p.setVideoFilterDescriptor(videoFilterDescriptor));
        if (this.videoFilterDescriptor != videoFilterDescriptor) {
            this.videoFilterDescriptor = videoFilterDescriptor;
            this.createVideoFilters();
            this.paneResized();
            this.repaint();
        }
    }

    public VideoFilterDescriptor getVideoFilterDescriptor() {
        return this.videoFilterDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createVideoFilters() {
        Class<FilterThread> clazz = FilterThread.class;
        synchronized (FilterThread.class) {
            if (this.videoFilters != null) {
                for (int i = this.videoFilters.length - 1; i >= 0; --i) {
                    this.videoFilters[i].dispose();
                }
            }
            this.videoFilters = this.videoFilterDescriptor.createFilters(this.filterThreads.length, PaletteUtil.getExtendedPalettes());
            if (this.videoFilters == null) {
                this.filterScale = 1;
                this.filterScaleY = 1.0;
                this.filterScaleX = 1.0;
                this.paintImage = this.image;
            } else {
                this.filterScale = this.videoFilterDescriptor.getScale();
                this.filterScaleX = (double)this.videoFilterDescriptor.getWidth() / 256.0;
                this.filterScaleY = (double)this.videoFilterDescriptor.getHeight() / 240.0;
                this.paintImage = this.videoFilters[0].getImage();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtendedPalettes(int[][] extendedPalettes) {
        App.runVsDualImagePane(this, p -> p.setExtendedPalettes(extendedPalettes));
        Class<FilterThread> clazz = FilterThread.class;
        synchronized (FilterThread.class) {
            if (this.videoFilters != null) {
                this.videoFilters[0].setExtendedPalettes(extendedPalettes);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setShowFPS(boolean showFPS) {
        App.runVsDualImagePane(this, p -> p.setShowFPS(showFPS));
        this.showFPS = showFPS;
        this.frameTime = System.nanoTime();
        this.generatedFrames = 0;
        this.displayedFrames = 0;
        this.fpsStr = DEFAULT_FPS_STRING;
    }

    public boolean isShowFPS() {
        return this.showFPS;
    }

    public void setShowStatusMessages(boolean showStatusMessages) {
        App.runVsDualImagePane(this, p -> p.setShowStatusMessages(this.showFPS));
        this.showStatusMessages = showStatusMessages;
    }

    public boolean isShowStatusMessages() {
        return this.showStatusMessages;
    }

    public void setRewinding(boolean rewinding) {
        App.runVsDualImagePane(this, p -> p.setRewinding(rewinding));
        this.rewinding = rewinding;
    }

    public boolean isRewinding() {
        return this.rewinding;
    }

    public void setPaused(boolean paused) {
        App.runVsDualImagePane(this, p -> p.setPaused(paused));
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void showMessage(String message) {
        App.runVsDualImagePane(this, p -> p.showMessage(message));
        this.message = message;
        this.messageTimer = message == null ? 0 : 120;
    }

    public void setCursorType(CursorType cursorType) {
        if (EventQueue.isDispatchThread()) {
            App.runVsDualImagePane(this, p -> p.setCursorType(cursorType));
            if (this.cursorType != cursorType) {
                this.cursorType = cursorType;
                this.updateCursor();
            }
        } else {
            EventQueue.invokeLater(() -> this.setCursorType(cursorType));
        }
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public void setHideInactiveMouseCursor(boolean hideInactiveMouseCursor) {
        App.runVsDualImagePane(this, p -> p.setHideInactiveMouseCursor(hideInactiveMouseCursor));
        this.hideInactiveMouseCursor = hideInactiveMouseCursor;
    }

    public boolean isHideInactiveMouseCursor() {
        return this.hideInactiveMouseCursor;
    }

    public void setHideFullscreenMouseCursor(boolean hideFullscreenMouseCursor) {
        App.runVsDualImagePane(this, p -> p.setHideFullscreenMouseCursor(hideFullscreenMouseCursor));
        this.hideFullscreenMouseCursor = hideFullscreenMouseCursor;
    }

    public boolean isHideFullscreenMouseCursor() {
        return this.hideFullscreenMouseCursor;
    }

    public void setCursorVisible(boolean cursorVisible) {
        App.runVsDualImagePane(this, p -> p.setCursorVisible(cursorVisible));
        if (this.cursorVisible != cursorVisible) {
            if (EventQueue.isDispatchThread()) {
                this.cursorVisible = cursorVisible;
                this.updateCursor();
            } else {
                EventQueue.invokeLater(() -> this.setCursorVisible(cursorVisible));
            }
        }
    }

    public boolean isCursorVisible() {
        return this.cursorVisible;
    }

    private void showCursor() {
        this.cursorCounter = 120;
        if (this.bufferStrategy == null || !this.hideFullscreenMouseCursor) {
            this.setCursorVisible(true);
        }
    }

    private void updateCursor() {
        if (this.cursorVisible || this.cursorType == CursorType.Crosshairs) {
            switch (this.cursorType) {
                case Crosshairs: {
                    this.setCursor(this.crosshairsCursor);
                    break;
                }
                case Blank: {
                    this.setCursor(this.blankCursor);
                    break;
                }
                default: {
                    this.setCursor(Cursor.getDefaultCursor());
                    break;
                }
            }
        } else {
            this.setCursor(this.blankCursor);
        }
    }

    public void updateScreenBorders() {
        App.runVsDualImagePane(this, ImagePane::updateScreenBorders);
        AppPrefs appPrefs = AppPrefs.getInstance();
        if (appPrefs.getView().isUnderscan()) {
            this.screenBorders = ScreenBorders.EMPTY_BORDERS;
        } else {
            OverscanPrefs prefs = appPrefs.getOverscanPrefs();
            switch (this.tvSystem) {
                case NTSC: {
                    this.screenBorders = prefs.getNtscBorders();
                    break;
                }
                case PAL: {
                    this.screenBorders = prefs.getPalBorders();
                    break;
                }
                case Dendy: {
                    this.screenBorders = prefs.getDendyBorders();
                }
            }
        }
        this.adjustPreferredSize();
        App.getImageFrame().adjustSize();
        this.repaint();
    }

    public TVSystem getTVSystem() {
        return this.tvSystem;
    }

    public void setTVSystem(TVSystem tvSystem) {
        if (EventQueue.isDispatchThread()) {
            App.runVsDualImagePane(this, p -> p.setTVSystem(tvSystem));
            if (this.tvSystem != tvSystem) {
                this.tvSystem = tvSystem;
                this.palette = PaletteUtil.getExtendedPalette(tvSystem);
                this.pixelAspectRatio = tvSystem.getPixelAspectRatio();
                this.updateScreenBorders();
            }
        } else {
            EventQueue.invokeLater(() -> this.setTVSystem(tvSystem));
        }
    }

    public void setUseTvAspectRatio(boolean useTvAspectRatio) {
        this.useTvAspectRatio = useTvAspectRatio;
        this.adjustPreferredSize();
        this.repaint();
    }

    public boolean isUseTvAspectRatio() {
        return this.useTvAspectRatio;
    }

    public void setScreenScale(int screenScale) {
        this.screenScale = screenScale;
        this.adjustPreferredSize();
        this.repaint();
    }

    public int getScreenScale() {
        return this.screenScale;
    }

    public void setSmoothScaling(boolean smoothScaling) {
        App.runVsDualImagePane(this, p -> p.setSmoothScaling(smoothScaling));
        this.smoothScaling = smoothScaling;
        this.repaint();
    }

    public boolean isSmoothScaling() {
        return this.smoothScaling;
    }

    public void setUniformPixelScaling(boolean uniformPixelScaling) {
        App.runVsDualImagePane(this, p -> p.setUniformPixelScaling(uniformPixelScaling));
        this.uniformPixelScaling = uniformPixelScaling;
        this.repaint();
    }

    public boolean isUniformPixelScaling() {
        return this.uniformPixelScaling;
    }

    private void adjustPreferredSize() {
        if (EventQueue.isDispatchThread()) {
            double aspectRatio = this.useTvAspectRatio ? (double)this.pixelAspectRatio.horizontal / (double)this.pixelAspectRatio.vertical : 1.0;
            this.setPreferredSize(new Dimension((int)Math.round(aspectRatio * (double)this.screenScale * (double)(256 - this.screenBorders.left - this.screenBorders.right)), this.screenScale * (240 - this.screenBorders.top - this.screenBorders.bottom)));
            this.invalidate();
        } else {
            GuiUtil.invokeAndWait(this::adjustPreferredSize);
        }
    }

    public BufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public void setBufferStrategy(BufferStrategy bufferStrategy) {
        this.bufferStrategy = bufferStrategy;
        if (bufferStrategy != null && this.hideFullscreenMouseCursor) {
            this.setCursorVisible(false);
        }
        EventQueue.invokeLater(this::redraw);
    }

    public void redraw() {
        this.paneResized();
        this.repaint();
    }

    public void setFrameColor(int color) {
        App.runVsDualImagePane(this, p -> this.setFrameColor(color));
        if (this.lastFrameColor != color) {
            this.lastFrameColor = color;
            this.frameColor = new Color(color);
            Graphics g = this.getGraphics();
            if (g == null) {
                return;
            }
            this.paintComponent(g);
            g.dispose();
        }
    }

    public int getFrameColor() {
        return this.lastFrameColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(int[] screen) {
        Object object = this.screenMonitor;
        synchronized (object) {
            ++this.generatedFrames;
            System.arraycopy(screen, 0, this.screens[this.writeIndex], 0, screen.length);
            this.lastWriteIndex = this.writeIndex;
            do {
                ++this.writeIndex;
                this.writeIndex &= 3;
            } while (this.writeIndex == this.readIndex);
            this.screenMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] render() {
        Object object = this.screenMonitor;
        synchronized (object) {
            ++this.generatedFrames;
            this.lastWriteIndex = this.writeIndex;
            do {
                ++this.writeIndex;
                this.writeIndex &= 3;
            } while (this.writeIndex == this.readIndex);
            this.screenMonitor.notifyAll();
            return this.screens[this.writeIndex];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void renderLoop() {
        while (this.rendering) {
            block25: {
                Class<FilterThread> clazz = this.screenMonitor;
                // MONITORENTER : clazz
                while (this.lastWriteIndex == this.readIndex) {
                    ThreadUtil.threadWait(this.screenMonitor);
                }
                this.readIndex = this.lastWriteIndex;
                int[] screen = this.screens[this.readIndex];
                // MONITOREXIT : clazz
                if (this.requestScreenshot) {
                    this.requestScreenshot = false;
                    ScreenshotSaver.save(screen, this.tvSystem);
                }
                if (this.showStatusMessages) {
                    if (this.rewinding) {
                        FontUtil.drawString(screen, "REWIND", this.screenBorders.left + 8, this.screenBorders.top + 8, false);
                    } else if (this.message != null) {
                        FontUtil.drawString(screen, this.message, this.screenBorders.left + 8, this.screenBorders.top + 8, false);
                    }
                }
                if (this.showFPS) {
                    FontUtil.drawString(screen, this.fpsStr, 248 - this.screenBorders.right - (this.fpsStr.length() << 3), this.screenBorders.top + 8, true);
                }
                if (this.videoFilterDescriptor == VideoFilterDescriptor.Ntsc) {
                    System.arraycopy(screen, 0, this.data, 0, screen.length);
                } else {
                    PaletteUtil.applyPalette(screen, this.data, this.palette);
                }
                clazz = FilterThread.class;
                // MONITORENTER : nintaco.gui.image.ImagePane$FilterThread.class
                if (this.videoFilters != null) {
                    this.runningThreads = this.filterThreads.length;
                    for (int i = this.filterThreads.length - 1; i >= 0; --i) {
                        this.filterThreads[i].execute();
                    }
                    while (this.runningThreads != 0) {
                        ThreadUtil.threadWait(FilterThread.class);
                    }
                    this.paintImage = this.videoFilters[0].getImage();
                } else {
                    this.paintImage = this.image;
                }
                // MONITOREXIT : clazz
                try {
                    BufferStrategy strategy = this.bufferStrategy;
                    if (strategy != null) {
                        Graphics2D g = (Graphics2D)strategy.getDrawGraphics();
                        if (g != null) {
                            this.render(g, this.paintImage);
                            g.dispose();
                            if (!strategy.contentsLost()) {
                                strategy.show();
                            }
                            this.toolkit.sync();
                        }
                        break block25;
                    }
                    EventQueue.invokeAndWait(() -> this.paintImmediately(0, 0, this.paneWidth, this.paneHeight));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (--this.cursorCounter <= 0) {
                this.cursorCounter = 0;
                if (this.hideInactiveMouseCursor) {
                    this.setCursorVisible(false);
                }
            }
            if (--this.messageTimer > 0) continue;
            this.messageTimer = 0;
            this.message = null;
        }
    }

    public void requestScreenshot() {
        App.runVsDualImagePane(this, ImagePane::requestScreenshot);
        if (this.paused) {
            ScreenshotSaver.save(this.screens[this.readIndex], this.tvSystem);
        } else {
            this.requestScreenshot = true;
        }
    }

    public void clearScreen() {
        int i;
        int BLACK = PaletteUtil.getPalettePPU().getMap()[15];
        App.runVsDualImagePane(this, ImagePane::clearScreen);
        this.rewinding = false;
        this.messageTimer = 0;
        this.message = null;
        for (i = this.screens.length - 1; i >= 0; --i) {
            Arrays.fill(this.render(), BLACK);
        }
        Arrays.fill(this.data, 0);
        for (i = this.screens.length - 1; i >= 0; --i) {
            Arrays.fill(this.screens[i], BLACK);
        }
        VideoFilter[] filters = this.videoFilters;
        if (filters != null) {
            filters[0].reset();
        }
        GuiUtil.invokeAndWait(this::repaint);
    }

    public void requestRepaint() {
        App.runVsDualImagePane(this, ImagePane::requestRepaint);
        this.repaintRequested = true;
    }

    public void paneResized() {
        this.paneWidth = this.getWidth();
        this.paneHeight = this.getHeight();
        double aspectRatio = this.useTvAspectRatio ? (double)this.pixelAspectRatio.horizontal / (double)this.pixelAspectRatio.vertical : 1.0;
        int IMG_WIDTH = (int)Math.round((double)(256 - this.screenBorders.left - this.screenBorders.right) * aspectRatio * (double)this.filterScale);
        int IMG_HEIGHT = (240 - this.screenBorders.top - this.screenBorders.bottom) * this.filterScale;
        if (this.uniformPixelScaling && this.paneWidth >= IMG_WIDTH && this.paneHeight >= IMG_HEIGHT) {
            int xs = 1;
            while (IMG_WIDTH * (xs + 1) <= this.paneWidth) {
                ++xs;
            }
            int ys = 1;
            while (IMG_HEIGHT * (ys + 1) <= this.paneHeight) {
                ++ys;
            }
            int scale = Math.min(xs, ys);
            this.imageWidth = IMG_WIDTH * scale;
            this.imageHeight = IMG_HEIGHT * scale;
            this.imageX = (this.paneWidth - this.imageWidth) / 2;
            this.imageY = (this.paneHeight - this.imageHeight) / 2;
            this.bars = this.imageWidth == this.paneWidth ? (this.imageHeight == this.paneHeight ? Bars.NONE : Bars.TOP_BOTTOM) : (this.imageHeight == this.paneHeight ? Bars.LEFT_RIGHT : Bars.ALL_SIDES);
        } else if (IMG_HEIGHT * this.paneWidth >= IMG_WIDTH * this.paneHeight) {
            this.imageHeight = this.paneHeight;
            this.imageY = 0;
            this.imageWidth = IMG_WIDTH * this.imageHeight / IMG_HEIGHT;
            this.imageX = (this.paneWidth - this.imageWidth) / 2;
            this.bars = this.paneWidth == this.imageWidth ? Bars.NONE : Bars.LEFT_RIGHT;
        } else {
            this.imageWidth = this.paneWidth;
            this.imageHeight = IMG_HEIGHT * this.imageWidth / IMG_WIDTH;
            this.imageY = (this.paneHeight - this.imageHeight) / 2;
            this.imageX = 0;
            this.bars = this.paneHeight == this.imageHeight ? Bars.NONE : Bars.TOP_BOTTOM;
        }
        this.imageTop = (int)Math.round((double)this.screenBorders.top * this.filterScaleY);
        this.imageBottom = (int)Math.round((double)(240 - this.screenBorders.bottom) * this.filterScaleY);
        this.imageLeft = (int)Math.round((double)this.screenBorders.left * this.filterScaleX);
        this.imageRight = (int)Math.round((double)(256 - this.screenBorders.right) * this.filterScaleX);
        if (this.bufferStrategy == null && App.getImageFrame().isVisible()) {
            this.setPreferredSize(new Dimension(this.paneWidth, this.paneHeight));
        }
        if (this.repaintRequested) {
            this.repaintRequested = false;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.render((Graphics2D)g, this.paintImage);
    }

    private void render(Graphics2D g, BufferedImage buffer) {
        if (this.smoothScaling) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        switch (this.bars) {
            case LEFT_RIGHT: {
                g.setColor(this.frameColor);
                g.fillRect(0, 0, this.imageX, this.paneHeight);
                g.fillRect(this.imageX + this.imageWidth, 0, this.paneWidth - (this.imageX + this.imageWidth), this.paneHeight);
                break;
            }
            case TOP_BOTTOM: {
                g.setColor(this.frameColor);
                g.fillRect(0, 0, this.paneWidth, this.imageY);
                g.fillRect(0, this.imageY + this.imageHeight, this.paneWidth, this.paneHeight - (this.imageY + this.imageHeight));
                break;
            }
            case ALL_SIDES: {
                g.setColor(this.frameColor);
                g.fillRect(0, 0, this.imageX, this.paneHeight);
                g.fillRect(this.imageX + this.imageWidth, 0, this.paneWidth - (this.imageX + this.imageWidth), this.paneHeight);
                g.fillRect(this.imageX, 0, this.imageWidth, this.imageY);
                g.fillRect(this.imageX, this.imageY + this.imageHeight, this.imageWidth, this.paneHeight - (this.imageY + this.imageHeight));
            }
        }
        g.drawImage(buffer, this.imageX, this.imageY, this.imageX + this.imageWidth, this.imageY + this.imageHeight, this.imageLeft, this.imageTop, this.imageRight, this.imageBottom, null);
        if (this.showFPS) {
            ++this.displayedFrames;
            long duration = System.nanoTime() - this.frameTime;
            if (duration > 1250000000L) {
                double seconds = (double)duration * 1.0E-9;
                this.fpsStr = String.format("%.1f/%.1f", (double)this.displayedFrames / seconds, (double)this.generatedFrames / seconds);
                this.generatedFrames = 0;
                this.displayedFrames = 0;
                this.frameTime = System.nanoTime();
            }
        }
    }

    private class FilterThread
    extends Thread {
        private final int index;
        private final int yFirst;
        private final int yLast;
        private boolean execute;
        private volatile boolean running = true;

        public FilterThread(int index, int yFirst, int yLast) {
            this.index = index;
            this.yFirst = yFirst;
            this.yLast = yLast;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void execute() {
            if (this.running) {
                this.execute = true;
                this.notifyAll();
                return;
            }
            Class<FilterThread> clazz = FilterThread.class;
            synchronized (FilterThread.class) {
                ImagePane.this.runningThreads--;
                FilterThread.class.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private synchronized void waitForExecute() {
            while (!this.execute && this.running) {
                ThreadUtil.threadWait(this);
            }
            this.execute = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (this.running) {
                this.waitForExecute();
                if (!this.running) continue;
                VideoFilter[] filters = ImagePane.this.videoFilters;
                if (filters != null && this.index < filters.length) {
                    filters[this.index].filter(ImagePane.this.data, this.yFirst, this.yLast);
                }
                Class<FilterThread> clazz = FilterThread.class;
                // MONITORENTER : nintaco.gui.image.ImagePane$FilterThread.class
                ImagePane.this.runningThreads--;
                FilterThread.class.notifyAll();
                // MONITOREXIT : clazz
            }
        }

        public synchronized void dispose() {
            this.running = false;
            this.notifyAll();
        }
    }

    private static enum Bars {
        NONE,
        LEFT_RIGHT,
        TOP_BOTTOM,
        ALL_SIDES;

    }
}

