/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.image.filters;

import java.util.Arrays;
import nintaco.gui.image.filters.VideoFilter;

public final class Retro3x
extends VideoFilter {
    private static final int[][] GAUSSIAN = new int[][]{{1, 2, 1}, {2, 4, 2}, {1, 2, 1}};
    private static final int[][] PRECEDENCE = new int[][]{{1, 1}, {0, 1}, {1, 2}, {2, 0}, {1, 1}, {2, 1}, {1, 0}, {2, 2}, {1, 1}, {0, 1}, {1, 2}, {0, 2}, {1, 1}, {2, 1}, {1, 0}, {0, 0}};
    private static final int[][][] BLURS = new int[256][3][3];
    private final int[] SCREEN;
    private final int[] RANDOM_VALUES = new int[3001];
    private final int[] row = new int[256];
    private int randomIndex;
    private int jag;
    private boolean ghosting = true;

    private static void initBlurs() {
        for (int i = 255; i >= 0; --i) {
            Retro3x.distributeRemainder(Retro3x.distributeIntensity(9 * i, BLURS[i]), BLURS[i]);
        }
    }

    private static int distributeIntensity(int intensity, int[][] blur) {
        int sum = 0;
        for (int i = 2; i >= 0; --i) {
            for (int j = 2; j >= 0; --j) {
                blur[i][j] = intensity * GAUSSIAN[i][j] >> 4;
                if (blur[i][j] > 255) {
                    blur[i][j] = 255;
                }
                sum += blur[i][j];
            }
        }
        return intensity - sum;
    }

    private static void distributeRemainder(int remainder, int[][] blur) {
        while (remainder > 0) {
            for (int i = 0; i < PRECEDENCE.length; ++i) {
                int[] p = PRECEDENCE[i];
                if (blur[p[1]][p[0]] >= 255) continue;
                int[] nArray = blur[p[1]];
                int n = p[0];
                nArray[n] = nArray[n] + 1;
                if (--remainder != 0) continue;
                return;
            }
        }
    }

    public Retro3x() {
        super(3);
        this.SCREEN = new int[61440];
        this.initRandomValues();
    }

    public Retro3x(Retro3x retro3x) {
        super(retro3x.getImage(), retro3x.getImageData());
        this.SCREEN = retro3x.SCREEN;
        this.initRandomValues();
    }

    @Override
    public void setGhosting(boolean ghosting) {
        this.ghosting = ghosting;
    }

    private void initRandomValues() {
        for (int i = this.RANDOM_VALUES.length - 1; i >= 0; --i) {
            this.RANDOM_VALUES[i] = (int)(13.0 * Math.random()) - 6;
        }
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.SCREEN, 0);
    }

    @Override
    public final void filter(int[] in, int yFirst, int yLast) {
        Retro3x.scale(in, this.out, yFirst, yLast, BLURS, this.SCREEN, this.RANDOM_VALUES, this.randomIndex, this.row, this.jag, this.ghosting);
        this.randomIndex = (this.randomIndex + 61440) % 3001;
        ++this.jag;
    }

    private static void scale(int[] in, int[] out, int yFirst, int yLast, int[][][] blurs, int[] screen, int[] randomValues, int rand, int[] row, int jag, boolean ghosting) {
        for (int y = yLast - 1; y >= yFirst; --y) {
            int yx;
            int x;
            int offset;
            int[] pixels;
            int ys = y << 8;
            int Y0 = 2304 * y;
            int Y1 = Y0 + 768;
            int Y2 = Y1 + 768;
            row[0] = in[ys];
            int i = (y + jag) % 3;
            for (int x2 = 1; x2 < 256; ++x2) {
                int yx2 = ys + x2;
                int p1 = in[yx2 - 1];
                int p2 = in[yx2];
                if (p1 == p2) {
                    row[x2] = p2;
                } else {
                    int b;
                    int g;
                    int r;
                    int r1 = p1 >> 16 & 0xFF;
                    int g1 = p1 >> 8 & 0xFF;
                    int b1 = p1 & 0xFF;
                    int r2 = p2 >> 16 & 0xFF;
                    int g2 = p2 >> 8 & 0xFF;
                    int b2 = p2 & 0xFF;
                    switch (i) {
                        case 0: {
                            r = r1 + 3 * r2 >> 2;
                            g = g2;
                            b = b2;
                            break;
                        }
                        case 1: {
                            r = r2;
                            g = g1 + 3 * g2 >> 2;
                            b = b2;
                            break;
                        }
                        default: {
                            r = r2;
                            g = g2;
                            b = b1 + 3 * b2 >> 2;
                        }
                    }
                    row[x2] = r << 16 | g << 8 | b;
                }
                i = i == 2 ? 0 : i + 1;
            }
            if (ghosting) {
                pixels = screen;
                offset = ys;
                for (x = 255; x >= 0; --x) {
                    yx = ys + x;
                    int r = (3 * (screen[yx] >> 16 & 0xFF) + 5 * (row[x] >> 16 & 0xFF) >> 3) + randomValues[rand];
                    if (++rand == 3001) {
                        rand = 0;
                    }
                    if (r < 0) {
                        r = 0;
                    } else if (r > 255) {
                        r = 255;
                    }
                    int g = (3 * (screen[yx] >> 8 & 0xFF) + 5 * (row[x] >> 8 & 0xFF) >> 3) + randomValues[rand];
                    if (++rand == 3001) {
                        rand = 0;
                    }
                    if (g < 0) {
                        g = 0;
                    } else if (g > 255) {
                        g = 255;
                    }
                    int b = (3 * (screen[yx] & 0xFF) + 5 * (row[x] & 0xFF) >> 3) + randomValues[rand];
                    if (++rand == 3001) {
                        rand = 0;
                    }
                    if (b < 0) {
                        b = 0;
                    } else if (b > 255) {
                        b = 255;
                    }
                    screen[yx] = r << 16 | g << 8 | b;
                }
            } else {
                pixels = row;
                offset = 0;
            }
            for (x = 255; x >= 0; --x) {
                yx = offset + x;
                int x3 = x * 3;
                int y0 = Y0 + x3;
                int y1 = Y1 + x3;
                int y2 = Y2 + x3;
                int p = pixels[yx];
                int[][] R = blurs[p >> 16 & 0xFF];
                int[][] G = blurs[p >> 8 & 0xFF];
                int[][] B = blurs[p & 0xFF];
                out[y0] = R[0][1] << 16 | G[0][0] << 8;
                out[y0 + 1] = R[0][2] << 16 | G[0][1] << 8 | B[0][0];
                out[y0 + 2] = G[0][2] << 8 | B[0][1];
                out[y1] = R[1][1] << 16 | G[1][0] << 8;
                out[y1 + 1] = R[1][2] << 16 | G[1][1] << 8 | B[1][0];
                out[y1 + 2] = G[1][2] << 8 | B[1][1];
                out[y2] = R[2][1] << 16 | G[2][0] << 8;
                out[y2 + 1] = R[2][2] << 16 | G[2][1] << 8 | B[2][0];
                out[y2 + 2] = G[2][2] << 8 | B[2][1];
                if (x != 0) {
                    int[][] b = blurs[pixels[yx - 1] & 0xFF];
                    int n = y0;
                    out[n] = out[n] | b[0][2];
                    int n2 = y1;
                    out[n2] = out[n2] | b[1][2];
                    int n3 = y2;
                    out[n3] = out[n3] | b[2][2];
                }
                if (x == 255) continue;
                int[][] r = blurs[pixels[yx + 1] >> 16 & 0xFF];
                int n = y0 + 2;
                out[n] = out[n] | r[0][0] << 16;
                int n4 = y1 + 2;
                out[n4] = out[n4] | r[1][0] << 16;
                int n5 = y2 + 2;
                out[n5] = out[n5] | r[2][0] << 16;
            }
        }
    }

    static {
        Retro3x.initBlurs();
    }
}

