/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.image.filters;

import nintaco.gui.image.filters.VideoFilter;

public final class Scanlines
extends VideoFilter {
    private final int SCALE;
    private final int W;
    private final int[][] kernels;
    private final float I_SCALE;

    public Scanlines(int scale) {
        super(scale);
        this.SCALE = scale;
        this.I_SCALE = 1.0f / (float)this.SCALE;
        this.W = this.SCALE << 8;
        this.kernels = new int[256][this.SCALE];
        for (int i = 255; i >= 0; --i) {
            double sum = 0.0;
            double e = 1.0 - 0.95 * Math.pow((double)i / 255.0, 0.5);
            for (int j = this.SCALE - 1; j >= 0; --j) {
                sum += (double)i * Math.pow((1.0 + Math.cos(Math.PI * (2.0 * ((0.5 + (double)j) / (double)this.SCALE) - 1.0))) / 2.0, e);
            }
            double intensity = (double)(i * i * this.SCALE) / sum;
            double E = 1.0 - 0.95 * Math.pow(intensity / 255.0, 0.5);
            int[] kernel = this.kernels[i];
            for (int j = this.SCALE - 1; j >= 0; --j) {
                kernel[j] = Math.min(255, (int)Math.round(intensity * Math.pow((1.0 + Math.cos(Math.PI * (2.0 * ((0.5 + (double)j) / (double)this.SCALE) - 1.0))) / 2.0, E)));
            }
        }
    }

    public Scanlines(Scanlines scanlines) {
        super(scanlines.getImage(), scanlines.getImageData());
        this.SCALE = scanlines.SCALE;
        this.W = scanlines.W;
        this.kernels = scanlines.kernels;
        this.I_SCALE = scanlines.I_SCALE;
    }

    @Override
    public void filter(int[] in, int yFirst, int yLast) {
        int[] out = this.out;
        int first = this.W * this.SCALE * yFirst;
        for (int o = this.W * (this.SCALE * yLast - 1); o >= first; o -= this.W) {
            for (int j = this.W - 1; j >= 0; --j) {
                out[o + j] = 0;
            }
        }
        for (int y = yLast - 1; y >= yFirst; --y) {
            int sy = this.SCALE * y;
            int oy = y << 8;
            for (int x = 255; x >= 0; --x) {
                int sx = this.SCALE * x;
                int q = x == 0 ? in[oy + x] : in[oy + x - 1];
                int p = in[oy + x];
                for (int s = 16; s >= 0; s -= 8) {
                    int vq = q >> s & 0xFF;
                    int vp = p >> s & 0xFF;
                    if (vq == vp) {
                        int[] kernel = this.kernels[vq];
                        for (int i = this.SCALE - 1; i >= 0; --i) {
                            int k = kernel[i];
                            int o = (sy + i) * this.W + sx;
                            for (int j = this.SCALE - 1; j >= 0; --j) {
                                int n = o + j;
                                out[n] = out[n] | k << s;
                            }
                        }
                        continue;
                    }
                    float delta = vp - vq;
                    for (int j = this.SCALE - 1; j >= 0; --j) {
                        int o = sx + j;
                        int[] kernel = this.kernels[(int)((float)vq + delta * (float)(j + 1) * this.I_SCALE)];
                        for (int i = this.SCALE - 1; i >= 0; --i) {
                            int n = (sy + i) * this.W + o;
                            out[n] = out[n] | kernel[i] << s;
                        }
                    }
                }
            }
        }
    }
}

