/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.netplay.server;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentListener;
import nintaco.App;
import nintaco.gui.LocalIPAddressRenderer;
import nintaco.gui.netplay.server.NetplayServerPrefs;
import nintaco.input.Ports;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;
import nintaco.util.NetworkUtil;
import nintaco.util.PasswordUtil;
import nintaco.util.StringUtil;

public class NetplayServerFrame
extends JFrame {
    private static final Color GREEN = new Color(32768);
    private JCheckBox[] playerCheckBoxes;
    private DocumentListener passwordListener;
    private DocumentListener portListener;
    private boolean passwordEdited;
    private JLabel activityLabel;
    private JScrollPane activityScrollPane;
    private JTextArea activityTextArea;
    private JButton clearActivityButton;
    private JButton hideWindowButton;
    private JCheckBox highSpeedCheckBox;
    private JTextField jTextField1;
    private JComboBox localIPComboBox;
    private JLabel localIPLabel;
    private JLabel localPlayersLabel;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JCheckBox player1CheckBox;
    private JCheckBox player2CheckBox;
    private JCheckBox player3CheckBox;
    private JCheckBox player4CheckBox;
    private JLabel portLabel;
    private JTextField portTextField;
    private JCheckBox quickSavesCheckBox;
    private JCheckBox rewindTimeCheckBox;
    private JCheckBox spectatorsCheckBox;
    private JToggleButton startServerButton;
    private JLabel statusLabel;

    public NetplayServerFrame() {
        this.initComponents();
        this.initPlayerCheckBoxes();
        this.initLocalIPComboBox();
        this.initTextFields();
        this.loadFields();
        this.setServerStatus(false);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void initPlayerCheckBoxes() {
        this.playerCheckBoxes = new JCheckBox[]{this.player1CheckBox, this.player2CheckBox, this.player3CheckBox, this.player4CheckBox};
    }

    private void initLocalIPComboBox() {
        this.localIPComboBox.setRenderer(new LocalIPAddressRenderer());
        List<InetAddress> localIPAddresses = NetworkUtil.sortAddresses(NetworkUtil.getNetworkInterfaces());
        localIPAddresses.add(0, null);
        this.localIPComboBox.setModel(new DefaultComboBoxModel<InetAddress>(NetworkUtil.toArray(localIPAddresses)));
    }

    private void initTextFields() {
        GuiUtil.addLoseFocusListener((Window)this, this.portTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.passwordField);
        this.passwordListener = GuiUtil.createDocumentListener(() -> {
            this.passwordEdited = true;
        });
        this.passwordField.getDocument().addDocumentListener(this.passwordListener);
        this.portListener = GuiUtil.createDocumentListener(this::enableComponents);
        this.portTextField.getDocument().addDocumentListener(this.portListener);
        GuiUtil.makeMonospaced(this.activityTextArea);
        this.activityTextArea.setCursor(new Cursor(2));
        GuiUtil.enableAutoscroll(this.activityTextArea);
    }

    private void setPassword(int passwordLength) {
        StringBuilder sb = new StringBuilder();
        for (int i = passwordLength - 1; i >= 0; --i) {
            sb.append('*');
        }
        this.setPassword(sb.toString());
    }

    private void setPassword(String password) {
        this.passwordField.getDocument().removeDocumentListener(this.passwordListener);
        this.passwordField.setText(password);
        this.passwordField.getDocument().addDocumentListener(this.passwordListener);
    }

    private void setPort(int port) {
        this.setPort(Integer.toString(port));
    }

    private void setPort(String port) {
        this.portTextField.getDocument().removeDocumentListener(this.portListener);
        this.portTextField.setText(port);
        this.portTextField.getDocument().addDocumentListener(this.portListener);
    }

    private void loadFields() {
        NetplayServerPrefs prefs = AppPrefs.getInstance().getNetplayServerPrefs();
        this.localIPComboBox.setSelectedItem(prefs.getLocalIPAddress());
        this.setPort(prefs.getPort());
        boolean[] localPlayers = prefs.getLocalPlayers();
        for (int i = localPlayers.length - 1; i >= 0; --i) {
            this.playerCheckBoxes[i].setSelected(localPlayers[i]);
        }
        this.passwordCheckBox.setSelected(prefs.isEnablePassword());
        this.setPassword(prefs.getPasswordLength());
        this.rewindTimeCheckBox.setSelected(prefs.isAllowRewindTime());
        this.highSpeedCheckBox.setSelected(prefs.isAllowHighSpeed());
        this.spectatorsCheckBox.setSelected(prefs.isAllowSpectators());
        this.quickSavesCheckBox.setSelected(prefs.isAllowQuickSaves());
    }

    private void saveFields() {
        NetplayServerPrefs prefs = AppPrefs.getInstance().getNetplayServerPrefs();
        prefs.setAllowRewindTime(this.rewindTimeCheckBox.isSelected());
        prefs.setAllowHighSpeed(this.highSpeedCheckBox.isSelected());
        prefs.setAllowSpectators(this.spectatorsCheckBox.isSelected());
        prefs.setAllowQuickSaves(this.quickSavesCheckBox.isSelected());
        prefs.setLocalIPAddress((InetAddress)this.localIPComboBox.getSelectedItem());
        boolean[] localPlayers = new boolean[4];
        for (int i = localPlayers.length - 1; i >= 0; --i) {
            localPlayers[i] = this.playerCheckBoxes[i].isSelected();
        }
        prefs.setLocalPlayers(localPlayers);
        prefs.setPort(StringUtil.parseInt(this.portTextField.getText(), 8888));
        prefs.setEnablePassword(this.passwordCheckBox.isSelected());
        if (this.passwordCheckBox.isSelected()) {
            if (this.passwordEdited) {
                char[] password = this.passwordField.getPassword();
                byte[] salt = PasswordUtil.createSalt();
                prefs.setPasswordLength(password.length);
                prefs.setPasswordSalt(salt);
                prefs.setPasswordHash(PasswordUtil.createHash(password, salt));
                Arrays.fill(password, '0');
            }
        } else {
            prefs.setPasswordSalt(null);
            prefs.setPasswordHash(null);
            prefs.setPasswordLength(0);
        }
        AppPrefs.save();
    }

    public void enableComponents() {
        boolean serverDown = !this.startServerButton.isSelected();
        boolean passwordEnabled = this.passwordCheckBox.isSelected();
        Ports ports = AppPrefs.getInstance().getInputs().getPorts();
        boolean fourPlayers = ports.isMultitap() || ports.getConsoleType() == 2;
        this.localIPLabel.setEnabled(serverDown);
        this.localIPComboBox.setEnabled(serverDown);
        this.portLabel.setEnabled(serverDown);
        this.portTextField.setEnabled(serverDown);
        this.localPlayersLabel.setEnabled(serverDown);
        this.player1CheckBox.setEnabled(serverDown);
        this.player2CheckBox.setEnabled(serverDown);
        this.player3CheckBox.setEnabled(serverDown && fourPlayers);
        this.player4CheckBox.setEnabled(serverDown && fourPlayers);
        this.passwordCheckBox.setEnabled(serverDown);
        this.passwordLabel.setEnabled(serverDown && passwordEnabled);
        this.passwordField.setEnabled(serverDown && passwordEnabled);
        this.spectatorsCheckBox.setEnabled(serverDown);
        this.rewindTimeCheckBox.setEnabled(serverDown);
        this.highSpeedCheckBox.setEnabled(serverDown);
        this.quickSavesCheckBox.setEnabled(serverDown);
        this.startServerButton.setEnabled(!serverDown || StringUtil.parseInt(this.portTextField.getText(), -1) >= 0);
        this.startServerButton.setText((serverDown ? "Start" : "Stop") + " Server");
    }

    public void destroy() {
        App.stopNetplayServer();
        this.saveFields();
        this.dispose();
    }

    private void closeFrame() {
        if (this.startServerButton.isSelected()) {
            this.setVisible(false);
        } else {
            App.destroyNetplayServerFrame();
        }
    }

    public void addActivity(String activity, Object ... params) {
        if (EventQueue.isDispatchThread()) {
            this.activityTextArea.append(String.format(activity, params) + "\n");
        } else {
            EventQueue.invokeLater(() -> this.addActivity(activity, params));
        }
    }

    public void setServerStatus(boolean serverUp) {
        if (EventQueue.isDispatchThread()) {
            this.startServerButton.setSelected(serverUp);
            if (serverUp) {
                this.statusLabel.setBackground(GREEN);
                this.statusLabel.setText("<html><b>RUNNING</b></html>");
            } else {
                this.statusLabel.setBackground(Color.RED);
                this.statusLabel.setText("<html><b>DOWN</b></html>");
            }
            this.enableComponents();
        } else {
            EventQueue.invokeLater(() -> this.setServerStatus(serverUp));
        }
    }

    private void initComponents() {
        this.jTextField1 = new JTextField();
        this.startServerButton = new JToggleButton();
        this.localIPLabel = new JLabel();
        this.localIPComboBox = new JComboBox();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.localPlayersLabel = new JLabel();
        this.player1CheckBox = new JCheckBox();
        this.player2CheckBox = new JCheckBox();
        this.player3CheckBox = new JCheckBox();
        this.player4CheckBox = new JCheckBox();
        this.spectatorsCheckBox = new JCheckBox();
        this.passwordLabel = new JLabel();
        this.passwordCheckBox = new JCheckBox();
        this.passwordField = new JPasswordField();
        this.hideWindowButton = new JButton();
        this.activityLabel = new JLabel();
        this.clearActivityButton = new JButton();
        this.activityScrollPane = new JScrollPane();
        this.activityTextArea = new JTextArea();
        this.statusLabel = new JLabel();
        this.rewindTimeCheckBox = new JCheckBox();
        this.quickSavesCheckBox = new JCheckBox();
        this.highSpeedCheckBox = new JCheckBox();
        this.jTextField1.setText("jTextField1");
        this.setDefaultCloseOperation(0);
        this.setTitle("Start Netplay Server");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NetplayServerFrame.this.formWindowClosing(evt);
            }
        });
        this.startServerButton.setMnemonic('S');
        this.startServerButton.setText("Start Server");
        this.startServerButton.setFocusPainted(false);
        this.startServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetplayServerFrame.this.startServerButtonActionPerformed(evt);
            }
        });
        this.localIPLabel.setText("Local IP address:");
        this.localIPComboBox.setFocusable(false);
        this.portLabel.setText("Port:");
        this.portTextField.setColumns(6);
        this.localPlayersLabel.setText("Local players:");
        this.player1CheckBox.setText("1P");
        this.player1CheckBox.setFocusPainted(false);
        this.player2CheckBox.setText("2P");
        this.player2CheckBox.setFocusPainted(false);
        this.player3CheckBox.setText("3P");
        this.player3CheckBox.setFocusPainted(false);
        this.player4CheckBox.setText("4P");
        this.player4CheckBox.setFocusPainted(false);
        this.spectatorsCheckBox.setText("Allow spectators");
        this.spectatorsCheckBox.setFocusPainted(false);
        this.passwordLabel.setText("Password:");
        this.passwordCheckBox.setText("Enable password");
        this.passwordCheckBox.setFocusPainted(false);
        this.passwordCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetplayServerFrame.this.passwordCheckBoxActionPerformed(evt);
            }
        });
        this.passwordField.setColumns(16);
        this.hideWindowButton.setMnemonic('H');
        this.hideWindowButton.setText("Hide Window");
        this.hideWindowButton.setFocusPainted(false);
        this.hideWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetplayServerFrame.this.hideWindowButtonActionPerformed(evt);
            }
        });
        this.activityLabel.setText("Activity");
        this.clearActivityButton.setMnemonic('A');
        this.clearActivityButton.setText("Clear Activity");
        this.clearActivityButton.setFocusPainted(false);
        this.clearActivityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetplayServerFrame.this.clearActivityButtonActionPerformed(evt);
            }
        });
        this.activityScrollPane.setVerticalScrollBarPolicy(22);
        this.activityScrollPane.setMaximumSize(null);
        this.activityScrollPane.setMinimumSize(null);
        this.activityScrollPane.setPreferredSize(null);
        this.activityTextArea.setEditable(false);
        this.activityTextArea.setColumns(60);
        this.activityTextArea.setRows(8);
        this.activityTextArea.setMaximumSize(null);
        this.activityTextArea.setMinimumSize(null);
        this.activityTextArea.setPreferredSize(null);
        this.activityScrollPane.setViewportView(this.activityTextArea);
        this.statusLabel.setForeground(Color.white);
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setText(" ");
        this.statusLabel.setBorder(new SoftBevelBorder(1));
        this.statusLabel.setMaximumSize(null);
        this.statusLabel.setMinimumSize(null);
        this.statusLabel.setOpaque(true);
        this.statusLabel.setPreferredSize(null);
        this.rewindTimeCheckBox.setText("Allow remote players to rewind time");
        this.rewindTimeCheckBox.setFocusPainted(false);
        this.quickSavesCheckBox.setText("Allow remote players to access quick saves");
        this.quickSavesCheckBox.setFocusPainted(false);
        this.highSpeedCheckBox.setText("Allow remote players to control high-speed ");
        this.highSpeedCheckBox.setFocusPainted(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.statusLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.startServerButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearActivityButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideWindowButton)).addComponent(this.activityScrollPane, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.localIPLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localIPComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.portLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.localPlayersLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.player1CheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.player2CheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.player3CheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.player4CheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.passwordCheckBox).addGap(18, 18, 18).addComponent(this.passwordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordField, -2, -1, -2)).addComponent(this.activityLabel).addGroup(layout.createSequentialGroup().addComponent(this.rewindTimeCheckBox).addGap(18, 18, 18).addComponent(this.highSpeedCheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.spectatorsCheckBox).addGap(18, 18, 18).addComponent(this.quickSavesCheckBox))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.clearActivityButton, this.hideWindowButton, this.startServerButton, this.statusLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localIPLabel).addComponent(this.localIPComboBox, -2, -1, -2).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localPlayersLabel).addComponent(this.player1CheckBox).addComponent(this.player2CheckBox).addComponent(this.player3CheckBox).addComponent(this.player4CheckBox)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordCheckBox).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spectatorsCheckBox).addComponent(this.quickSavesCheckBox)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.highSpeedCheckBox).addComponent(this.rewindTimeCheckBox)).addGap(18, 18, 18).addComponent(this.activityLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.activityScrollPane, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startServerButton).addComponent(this.hideWindowButton).addComponent(this.clearActivityButton).addComponent(this.statusLabel, -2, -1, -2)).addContainerGap()));
        layout.linkSize(1, this.clearActivityButton, this.hideWindowButton, this.startServerButton, this.statusLabel);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void passwordCheckBoxActionPerformed(ActionEvent evt) {
        this.enableComponents();
    }

    private void hideWindowButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void clearActivityButtonActionPerformed(ActionEvent evt) {
        this.activityTextArea.setText("");
    }

    private void startServerButtonActionPerformed(ActionEvent evt) {
        if (this.startServerButton.isSelected()) {
            this.saveFields();
            App.startNetplayServer();
            this.setTitle("Netplay Server Controls");
        } else {
            App.stopNetplayServer();
            this.setTitle("Start Netplay Server");
        }
        this.enableComponents();
    }
}

