/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.nsf;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nintaco.App;
import nintaco.AppMode;
import nintaco.Machine;
import nintaco.apu.APU;
import nintaco.apu.SystemAudioProcessor;
import nintaco.files.NsfFile;
import nintaco.gui.nsf.PauseIcon;
import nintaco.gui.nsf.PlayIcon;
import nintaco.gui.nsf.SwitchTrackIcon;
import nintaco.gui.sound.volumemixer.VolumeMixerFrame;
import nintaco.input.InputUtil;
import nintaco.input.other.RequestSong;
import nintaco.input.other.SetSongPaused;
import nintaco.mappers.Mapper;
import nintaco.mappers.nsf.NsfMapper;
import nintaco.preferences.AppPrefs;

public class NsfPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private static final String DEFAULT_SONG_LENGTH_STR = " / \u2013\u2013:\u2013\u2013";
    private final Timer timer = new Timer(500, e -> this.updateClock());
    private final ActionListener trackListener = e -> this.handleTrackChange();
    private String songLengthStr = " / \u2013\u2013:\u2013\u2013";
    private volatile NsfMapper mapper;
    private volatile NsfFile nsfFile;
    private JLabel artistLabel;
    private JLabel artistTextLabel;
    private JPanel buttonsPanel;
    private JLabel copyrightLabel;
    private JLabel copyrightTextLabel;
    private JPanel infoPanel;
    private JButton nextTrackButton;
    private JToggleButton playToggleButton;
    private JButton previousTrackButton;
    private JLabel soundChipsLabel;
    private JLabel soundChipsTextLabel;
    private JLabel timeLabel;
    private JLabel titleLabel;
    private JLabel titleTextLabel;
    private JComboBox<String> trackComboBox;
    private JPanel trackPanel;
    private JLabel tracksCountLabel;
    private JSlider volumeSlider;

    public NsfPanel() {
        this.initComponents();
        this.trackComboBox.addActionListener(this.trackListener);
        this.setVolume(AppPrefs.getInstance().getVolumeMixerPrefs().getMasterVolume());
    }

    public void init(Mapper mapper, NsfFile nsfFile) {
        if (mapper != null && nsfFile != null && mapper.isNsfMapper()) {
            this.nsfFile = nsfFile;
            this.mapper = (NsfMapper)mapper;
            String[] albumInfo = nsfFile.getAlbumInfo();
            this.titleLabel.setText(albumInfo[0]);
            this.artistLabel.setText(albumInfo[1]);
            this.copyrightLabel.setText(albumInfo[2]);
            this.setSoundChips(nsfFile);
            this.setTracks(nsfFile);
            this.timer.start();
        } else {
            this.close();
        }
    }

    public void setMachine(Machine machine) {
        if (machine != null && machine.getMapper().isNsfMapper()) {
            this.mapper = (NsfMapper)machine.getMapper();
        }
    }

    public void appModeChanged(AppMode appMode) {
        boolean enabled = appMode == AppMode.Default;
        this.trackComboBox.setEnabled(enabled);
        this.previousTrackButton.setEnabled(enabled);
        this.playToggleButton.setEnabled(enabled);
        this.nextTrackButton.setEnabled(enabled);
    }

    private void close() {
        if (EventQueue.isDispatchThread()) {
            this.mapper = null;
            this.nsfFile = null;
            this.songLengthStr = DEFAULT_SONG_LENGTH_STR;
            this.timer.stop();
        } else {
            EventQueue.invokeLater(this::close);
        }
    }

    public void updateClock() {
        NsfMapper m = this.mapper;
        if (m != null) {
            this.playToggleButton.setSelected(!m.isSongPaused());
            if (App.getImageFrame().isFocused()) {
                this.playToggleButton.requestFocus();
            }
            if (m.getRequestedSong() != this.trackComboBox.getSelectedIndex()) {
                this.fireTrackChanged(m.getRequestedSong());
            }
            if (!m.isAudioActive() && !App.getNetplayClient().isRunning()) {
                this.switchTracks(1);
            } else {
                this.timeLabel.setText(String.format("%s%s", this.toMMSS((int)((double)m.getSongCpuCycles() / m.getTVSystem().getCyclesPerSecond())), this.songLengthStr));
            }
        }
    }

    private long getAdjustedTrackMillis(NsfFile nsfFile, int trackIndex) {
        long trackLength;
        long fadeLength = nsfFile.getFadeMillis()[trackIndex];
        if (fadeLength < 0L) {
            fadeLength = 8000L;
        }
        return (trackLength = nsfFile.getTrackMillis()[trackIndex]) >= 0L ? trackLength + fadeLength : -1L;
    }

    private void setTracks(NsfFile nsfFile) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        String[] labels = nsfFile.getTrackLabels();
        for (int i = 0; i < labels.length; ++i) {
            long songMillis;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toString(i + 1));
            if (!"<?>".equals(labels[i])) {
                sb.append(" - ").append(labels[i]);
            }
            if ((songMillis = this.getAdjustedTrackMillis(nsfFile, i)) > 0L) {
                sb.append(" (").append(this.toMMSS((int)(songMillis / 1000L))).append(")");
            }
            model.addElement(sb.toString());
        }
        this.trackComboBox.setModel(model);
        this.tracksCountLabel.setText(String.format("/ %d", labels.length));
        if (!App.getNetplayClient().isRunning()) {
            this.trackComboBox.setSelectedIndex(nsfFile.getStartingSong());
        }
    }

    private String toMMSS(int seconds) {
        return String.format("%02d:%02d", Math.min(99, seconds / 60), seconds % 60);
    }

    private void setSoundChips(NsfFile nsfFile) {
        if (nsfFile.getChipCount() == 0) {
            this.soundChipsLabel.setText("<standard>");
        } else {
            StringBuilder sb = new StringBuilder();
            this.appendSoundChip(sb, nsfFile.isUsesFdsAudio(), "FDS");
            this.appendSoundChip(sb, nsfFile.isUsesMMC5Audio(), "MMC5");
            this.appendSoundChip(sb, nsfFile.isUsesNamco163Audio(), "Namco 163");
            this.appendSoundChip(sb, nsfFile.isUsesSunsoft5BAudio(), "Sunsoft 5B");
            this.appendSoundChip(sb, nsfFile.isUsesVRC6Audio(), "VRC6");
            this.appendSoundChip(sb, nsfFile.isUsesVRC7Audio(), "VRC7");
            this.soundChipsLabel.setText(sb.toString());
        }
    }

    private void appendSoundChip(StringBuilder sb, boolean test, String name) {
        if (test) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
        }
    }

    private void switchTracks(int offset) {
        int songIndex = this.trackComboBox.getSelectedIndex();
        if (songIndex >= 0) {
            this.trackComboBox.setSelectedIndex((songIndex + offset) % this.trackComboBox.getItemCount());
        }
    }

    private void handleTrackChange() {
        int songIndex = this.trackComboBox.getSelectedIndex();
        if (songIndex >= 0) {
            InputUtil.addOtherInput(new RequestSong(songIndex));
        }
    }

    public void fireTrackChanged(int songIndex) {
        NsfFile f = this.nsfFile;
        NsfMapper m = this.mapper;
        if (m != null && f != null) {
            long songMillis;
            this.trackComboBox.removeActionListener(this.trackListener);
            this.trackComboBox.setSelectedIndex(songIndex);
            this.trackComboBox.addActionListener(this.trackListener);
            this.playToggleButton.setSelected(!m.isSongPaused());
            if (m.isSongPaused()) {
                InputUtil.addOtherInput(new SetSongPaused(false));
            }
            this.songLengthStr = (songMillis = this.getAdjustedTrackMillis(f, songIndex)) > 0L ? " / " + this.toMMSS((int)(songMillis / 1000L)) : DEFAULT_SONG_LENGTH_STR;
            this.updateClock();
        }
    }

    public void setVolume(int volume) {
        if (this.volumeSlider.getValue() != volume) {
            this.volumeSlider.setValue(volume);
        }
    }

    private void initComponents() {
        this.timeLabel = new JLabel();
        this.infoPanel = new JPanel();
        this.soundChipsTextLabel = new JLabel();
        this.soundChipsLabel = new JLabel();
        this.artistLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.copyrightLabel = new JLabel();
        this.titleTextLabel = new JLabel();
        this.copyrightTextLabel = new JLabel();
        this.artistTextLabel = new JLabel();
        this.trackPanel = new JPanel();
        this.tracksCountLabel = new JLabel();
        this.trackComboBox = new JComboBox();
        this.buttonsPanel = new JPanel();
        this.previousTrackButton = new JButton();
        this.nextTrackButton = new JButton();
        this.playToggleButton = new JToggleButton();
        this.volumeSlider = new JSlider();
        this.setMaximumSize(null);
        this.timeLabel.setText("00:00 / 00:00");
        this.soundChipsTextLabel.setText("Sound chips:");
        this.soundChipsLabel.setText("[sound chips]");
        this.artistLabel.setText("[artist]");
        this.titleLabel.setText("[title]");
        this.copyrightLabel.setText("[copyright]");
        this.titleTextLabel.setText("Title:");
        this.copyrightTextLabel.setText("Copyright:");
        this.artistTextLabel.setText("Artist:");
        GroupLayout infoPanelLayout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.soundChipsTextLabel).addComponent(this.copyrightTextLabel).addComponent(this.artistTextLabel).addComponent(this.titleTextLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleLabel).addComponent(this.artistLabel).addComponent(this.copyrightLabel).addComponent(this.soundChipsLabel)).addGap(0, 0, 0)));
        infoPanelLayout.linkSize(0, this.artistTextLabel, this.copyrightTextLabel, this.soundChipsTextLabel, this.titleTextLabel);
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleTextLabel).addComponent(this.titleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.artistTextLabel).addComponent(this.artistLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.copyrightTextLabel).addComponent(this.copyrightLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.soundChipsTextLabel).addComponent(this.soundChipsLabel)).addGap(0, 0, 0)));
        this.tracksCountLabel.setText("/ X");
        this.trackComboBox.setFocusable(false);
        GroupLayout trackPanelLayout = new GroupLayout(this.trackPanel);
        this.trackPanel.setLayout(trackPanelLayout);
        trackPanelLayout.setHorizontalGroup(trackPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(trackPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.trackComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tracksCountLabel).addContainerGap()));
        trackPanelLayout.setVerticalGroup(trackPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(trackPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(trackPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.trackComboBox, -2, -1, -2).addComponent(this.tracksCountLabel)).addGap(0, 0, 0)));
        this.previousTrackButton.setIcon(new SwitchTrackIcon(true));
        this.previousTrackButton.setText(" ");
        this.previousTrackButton.setFocusPainted(false);
        this.previousTrackButton.setHorizontalTextPosition(0);
        this.previousTrackButton.setIconTextGap(0);
        this.previousTrackButton.setMargin(new Insets(4, 4, 4, 4));
        this.previousTrackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NsfPanel.this.previousTrackButtonActionPerformed(evt);
            }
        });
        this.nextTrackButton.setIcon(new SwitchTrackIcon(false));
        this.nextTrackButton.setText(" ");
        this.nextTrackButton.setFocusPainted(false);
        this.nextTrackButton.setHorizontalTextPosition(0);
        this.nextTrackButton.setIconTextGap(0);
        this.nextTrackButton.setMargin(new Insets(4, 4, 4, 4));
        this.nextTrackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NsfPanel.this.nextTrackButtonActionPerformed(evt);
            }
        });
        this.playToggleButton.setIcon(new PlayIcon());
        this.playToggleButton.setText(" ");
        this.playToggleButton.setCursor(new Cursor(0));
        this.playToggleButton.setFocusPainted(false);
        this.playToggleButton.setHorizontalTextPosition(0);
        this.playToggleButton.setIconTextGap(0);
        this.playToggleButton.setMargin(new Insets(6, 6, 6, 6));
        this.playToggleButton.setRolloverIcon(new PlayIcon());
        this.playToggleButton.setSelectedIcon(new PauseIcon());
        this.playToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NsfPanel.this.playToggleButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonsPanelLayout = new GroupLayout(this.buttonsPanel);
        this.buttonsPanel.setLayout(buttonsPanelLayout);
        buttonsPanelLayout.setHorizontalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.previousTrackButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.playToggleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextTrackButton).addGap(0, 0, 0)));
        buttonsPanelLayout.setVerticalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.playToggleButton).addComponent(this.previousTrackButton).addComponent(this.nextTrackButton)).addGap(0, 0, 0)));
        this.volumeSlider.setPaintTicks(true);
        this.volumeSlider.setFocusable(false);
        this.volumeSlider.setPreferredSize(new Dimension(this.infoPanel.getPreferredSize().width, this.volumeSlider.getPreferredSize().height));
        this.volumeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NsfPanel.this.volumeSliderStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.infoPanel, -2, -1, -2).addComponent(this.buttonsPanel, -2, -1, -2).addComponent(this.timeLabel).addComponent(this.volumeSlider, -2, -1, -2).addComponent(this.trackPanel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(15, Short.MAX_VALUE).addComponent(this.infoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addComponent(this.trackPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeSlider, -2, -1, -2).addGap(15, 15, 15)));
    }

    private void playToggleButtonActionPerformed(ActionEvent evt) {
        InputUtil.addOtherInput(new SetSongPaused(!this.playToggleButton.isSelected()));
    }

    private void nextTrackButtonActionPerformed(ActionEvent evt) {
        this.switchTracks(1);
    }

    private void previousTrackButtonActionPerformed(ActionEvent evt) {
        this.switchTracks(-1);
    }

    private void volumeSliderStateChanged(ChangeEvent evt) {
        VolumeMixerFrame frame = App.getVolumeMixerFrame();
        if (frame != null) {
            frame.setMasterVolume(this.volumeSlider.getValue());
        }
        AppPrefs.getInstance().getVolumeMixerPrefs().setMasterVolume(this.volumeSlider.getValue());
        APU.setMasterVolume(this.volumeSlider.getValue());
        SystemAudioProcessor.setMasterVolume(this.volumeSlider.getValue());
    }
}

