/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.oam;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import nintaco.App;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.PPU;
import nintaco.gui.ImagePanel;
import nintaco.gui.MaxLengthDocument;
import nintaco.gui.oam.OamDataPrefs;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;
import nintaco.util.GuiUtil;

public class OamDataFrame
extends JFrame {
    private static final int[] GRAY_PALETTE = new int[]{0, 0xFFFFFF, 0xB2B2B2, 0x757575};
    public static final int IMAGE_WIDTH = 147;
    public static final int IMAGE_HEIGHT = 71;
    private static final int ROWS_17 = 2499;
    private final DocumentListener scanlineListener = GuiUtil.createDocumentListener(this::scanlineUpdated);
    private volatile MachineRunner machineRunner;
    private volatile Machine machine;
    private volatile PPU ppu;
    private volatile boolean updateOnSprite0Hit;
    private volatile boolean colorSprites;
    private volatile boolean showHiddenSprites;
    private volatile boolean highlightSelectedSprite;
    private volatile int updateScanline;
    private volatile int sprite0Hits;
    private volatile int framesPerUpdate;
    private volatile int frames;
    private volatile int spriteIndex;
    private volatile int hoverSpriteIndex;
    private int mouseX;
    private int mouseY;
    private JLabel attributeLabel;
    private JTextField attributeTextField;
    private JButton closeButton;
    private JCheckBox colorCheckBox;
    private JButton defaultsButton;
    private JPanel displayPanel;
    private JComboBox<String> framesPerUpdateComboBox;
    private JLabel framesPerUpdateLabel;
    private JCheckBox highlightCheckBox;
    private JLabel oamAddressLabel;
    private JTextField oamAddressTextField;
    private JPanel oamDataPanel;
    private JLabel priorityLabel;
    private JTextField priorityTextField;
    private JButton resizeButton;
    private JLabel scanlineLabel;
    private JTextField scanlineTextField;
    private JCheckBox showHiddenSpritesCheckBox;
    private JCheckBox sprite0CheckBox;
    private JComboBox<String> spriteIndexComboBox;
    private JLabel spriteIndexLabel;
    private JPanel spritePanel;
    private JLabel tileAddressLabel;
    private JTextField tileAddressTextField;
    private JLabel tileLabel;
    private JTextField tileTextField;
    private JCheckBox xFlipCheckBox;
    private JLabel xLabel;
    private JTextField xTextField;
    private JCheckBox yFlipCheckBox;
    private JLabel yLabel;
    private JTextField yTextField;

    public OamDataFrame(MachineRunner machineRunner) {
        this.initComponents();
        this.initSpriteIndexComboBox();
        this.scanlineTextField.setDocument(new MaxLengthDocument(3, this.scanlineListener));
        this.loadFields();
        this.setMachineRunner(machineRunner);
        this.oamDataPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                OamDataFrame.this.mouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                OamDataFrame.this.mouseUpdated(e.getX(), e.getY());
            }
        });
        this.oamDataPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OamDataFrame.this.mouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                OamDataFrame.this.mouseUpdated(e.getX(), e.getY());
                OamDataFrame.this.mouseButtonPressed(e.getX(), e.getY(), e.isControlDown());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                OamDataFrame.this.mouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                OamDataFrame.this.mouseUpdated(e.getX(), e.getY());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OamDataFrame.this.mouseOutOfBounds();
            }
        });
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void initSpriteIndexComboBox() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("None");
        for (int i = 0; i < 64; ++i) {
            model.addElement(Integer.toString(i));
        }
        this.spriteIndexComboBox.setModel(model);
    }

    private void setScanlineTextFieldText(String text) {
        this.scanlineTextField.getDocument().removeDocumentListener(this.scanlineListener);
        this.scanlineTextField.setText(text);
        this.scanlineTextField.getDocument().addDocumentListener(this.scanlineListener);
    }

    private void scanlineUpdated() {
        this.updateScanline = 0;
        try {
            int value = Integer.parseInt(this.scanlineTextField.getText().trim());
            Machine m = this.machine;
            if (value >= -1 && value < (m == null ? TVSystem.PAL.getScanlineCount() : m.getMapper().getTVSystem().getScanlineCount()) - 1) {
                this.updateScanline = value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void destroy() {
        PPU.clearHighlightedSprite();
        this.saveFields();
        this.dispose();
    }

    private void closeFrame() {
        App.destroyOamDataFrame();
    }

    private void loadFields() {
        this.loadFields(AppPrefs.getInstance().getOamDataPrefs());
    }

    private void loadFields(OamDataPrefs prefs) {
        this.updateScanline = prefs.getUpdateScanline();
        this.framesPerUpdate = prefs.getFramesPerUpdate();
        this.updateOnSprite0Hit = prefs.isUpdateOnSprite0Hit();
        this.spriteIndex = prefs.getSpriteIndex();
        this.colorSprites = prefs.isColorSprites();
        this.showHiddenSprites = prefs.isShowHiddenSprites();
        this.highlightSelectedSprite = prefs.isHighlightSelectedSprite();
        this.setScanlineTextFieldText(Integer.toString(this.updateScanline));
        this.framesPerUpdateComboBox.setSelectedItem(Integer.toString(this.framesPerUpdate));
        this.sprite0CheckBox.setSelected(this.updateOnSprite0Hit);
        this.spriteIndexComboBox.setSelectedIndex(this.spriteIndex + 1);
        this.colorCheckBox.setSelected(this.colorSprites);
        this.showHiddenSpritesCheckBox.setSelected(this.showHiddenSprites);
        this.highlightCheckBox.setSelected(this.highlightSelectedSprite);
        this.updateScanlineComponents();
    }

    private void saveFields() {
        OamDataPrefs prefs = AppPrefs.getInstance().getOamDataPrefs();
        prefs.setUpdateScanline(this.updateScanline);
        prefs.setFramesPerUpdate(this.framesPerUpdate);
        prefs.setUpdateOnSprite0Hit(this.updateOnSprite0Hit);
        prefs.setSpriteIndex(this.spriteIndex);
        prefs.setColorSprites(this.colorSprites);
        prefs.setShowHiddenSprites(this.showHiddenSprites);
        prefs.setHighlightSelectedSprite(this.highlightSelectedSprite);
        AppPrefs.save();
    }

    public final void setMachineRunner(MachineRunner machineRunner) {
        this.machineRunner = machineRunner;
        if (machineRunner == null) {
            this.machine = null;
            this.ppu = null;
            ((ImagePanel)this.oamDataPanel).clearScreen();
        } else {
            this.machine = machineRunner.getMachine();
            this.ppu = this.machine.getPPU();
            if (machineRunner.isPaused()) {
                this.update(this.machine, this.ppu);
            }
        }
        boolean enabled = this.machine != null;
        EventQueue.invokeLater(() -> this.enableComponents(enabled));
    }

    public void update(int scanline) {
        Machine m = this.machine;
        PPU p = this.ppu;
        if (m == null || p == null) {
            return;
        }
        if (this.updateOnSprite0Hit) {
            if (!p.isSprite0Hit()) {
                this.sprite0Hits = 0;
                return;
            }
            if (++this.sprite0Hits != 2) {
                return;
            }
        } else if (scanline != this.updateScanline) {
            return;
        }
        if (--this.frames > 0) {
            return;
        }
        this.frames = this.framesPerUpdate;
        this.update(m, p);
    }

    public void update(Machine m, PPU p) {
        boolean yFlip;
        boolean xFlip;
        boolean priority;
        int tileAddress;
        int oamAddress;
        int attribute;
        int tile;
        int y;
        int offset;
        int Y;
        int X;
        int x;
        int x2;
        int i;
        ImagePanel imagePanel = (ImagePanel)this.oamDataPanel;
        if (m == null || p == null) {
            imagePanel.clearScreen();
            return;
        }
        int[] screen = imagePanel.getScreen();
        for (i = screen.length - 1; i >= 0; --i) {
            screen[i] = 0;
        }
        for (i = 4; i >= 0; --i) {
            int so = 147 + i * 2499;
            for (x2 = 144; x2 >= 0; --x2) {
                screen[1 + so + x2] = 0x3F3F3F;
            }
        }
        for (int so = 10143; so >= 147; so -= 147) {
            for (x = 1; x < 147; x += 9) {
                screen[so + x] = 0x3F3F3F;
            }
        }
        if (this.spriteIndex >= 0) {
            X = 1 + (this.spriteIndex & 0xF) * 9;
            Y = 147 + (this.spriteIndex >> 4) * 2499;
            for (x2 = 9; x2 >= 0; --x2) {
                offset = Y + X + x2;
                screen[offset] = 0xFFFFFF;
                screen[offset + 2499] = 0xFFFFFF;
            }
            y = 16;
            offset = Y + X + 147;
            while (y >= 1) {
                screen[offset] = 0xFFFFFF;
                screen[offset + 9] = 0xFFFFFF;
                --y;
                offset += 147;
            }
        }
        if (this.hoverSpriteIndex >= 0) {
            X = 1 + (this.hoverSpriteIndex & 0xF) * 9;
            Y = 147 + (this.hoverSpriteIndex >> 4) * 2499;
            for (x2 = 9; x2 >= 0; --x2) {
                offset = Y + X + x2;
                screen[offset] = 0xFFFF00;
                screen[offset + 2499] = 0xFFFF00;
            }
            y = 16;
            offset = Y + X + 147;
            while (y >= 1) {
                screen[offset] = 0xFFFF00;
                screen[offset + 9] = 0xFFFF00;
                --y;
                offset += 147;
            }
        }
        this.renderSpriteTiles(m, p, screen);
        imagePanel.render();
        int[] OAM = p.getOAM();
        if (this.spriteIndex >= 0) {
            int index = this.spriteIndex << 2;
            y = OAM[index];
            tile = OAM[index + 1];
            attribute = OAM[index + 2];
            x = OAM[index + 3];
            oamAddress = index;
            tileAddress = this.ppu.isSpriteSize8x16() ? (tile & 1) << 12 | (tile & 0xFE) << 4 : this.ppu.getSpritePatternTableAddress() | tile << 4;
            priority = BitUtil.getBitBool(attribute, 5);
            xFlip = BitUtil.getBitBool(attribute, 6);
            yFlip = BitUtil.getBitBool(attribute, 7);
            if (this.highlightSelectedSprite) {
                PPU.setHighlightedSprite(x, y);
            }
        } else {
            tileAddress = -1;
            oamAddress = -1;
            attribute = -1;
            tile = -1;
            y = -1;
            x = -1;
            yFlip = false;
            xFlip = false;
            priority = false;
            PPU.clearHighlightedSprite();
        }
        EventQueue.invokeLater(() -> {
            if (x >= 0) {
                this.updateSpriteFields(x, y, tile, attribute, oamAddress, tileAddress, priority, xFlip, yFlip);
            }
            this.mouseUpdated(this.mouseX, this.mouseY);
        });
    }

    private void renderSpriteTiles(Machine machine, PPU ppu, int[] screen) {
        int[] OAM = ppu.getOAM();
        int[] palette = PaletteUtil.getExtendedPalette(machine);
        int[] paletteRAM = ppu.getPaletteRAM();
        int patternTableAddress = ppu.getSpritePatternTableAddress();
        boolean size8x16 = ppu.isSpriteSize8x16();
        for (int i = 252; i >= 0; i -= 4) {
            boolean hidden;
            int x = 2 + (i >> 2 & 0xF) * 9;
            int y = 2 + (i >> 6 & 3) * 17;
            int spriteY = OAM[i];
            boolean bl = hidden = spriteY >= 239;
            if (hidden && !this.showHiddenSprites) continue;
            int tileIndex = OAM[i + 1];
            int attribute = OAM[i + 2];
            int paletteIndex = 0x10 | (attribute & 3) << 2;
            boolean flipHorizontally = BitUtil.getBitBool(attribute, 6);
            boolean flipVertically = BitUtil.getBitBool(attribute, 7);
            if (size8x16) {
                int address0 = (tileIndex & 1) << 12 | (tileIndex & 0xFE) << 4;
                int address1 = address0 | 0x10;
                if (flipVertically) {
                    int temp = address0;
                    address0 = address1;
                    address1 = temp;
                }
                this.renderTile(ppu, screen, address0, paletteIndex, paletteRAM, palette, x, y, flipHorizontally, flipVertically);
                this.renderTile(ppu, screen, address1, paletteIndex, paletteRAM, palette, x, y + 8, flipHorizontally, flipVertically);
            } else {
                this.renderTile(ppu, screen, patternTableAddress | tileIndex << 4, paletteIndex, paletteRAM, palette, x, y, flipHorizontally, flipVertically);
            }
            if (!hidden) continue;
            for (int j = 15; j >= 0; --j) {
                screen[(y + j) * 147 + x + (j >> 1)] = 0xFF0000;
            }
        }
    }

    private void renderTile(PPU ppu, int[] screen, int patternTableAddress, int paletteIndex, int[] paletteRAM, int[] palette, int x, int y, boolean flipHorizontally, boolean flipVertically) {
        for (int i = 7; i >= 0; --i) {
            int address = patternTableAddress | i;
            int b0 = ppu.peekVRAM(address);
            int b1 = ppu.peekVRAM(address | 8);
            if (flipHorizontally) {
                b0 = BitUtil.reverseBits(b0);
                b1 = BitUtil.reverseBits(b1);
            }
            int rowIndex = (y + (flipVertically ? 7 - i : i)) * 147;
            for (int j = 7; j >= 0; --j) {
                int v = (b1 & 1) << 1 | b0 & 1;
                b0 >>= 1;
                b1 >>= 1;
                int index = paletteIndex | v;
                if ((index & 3) == 0) continue;
                screen[rowIndex + x + j] = this.colorSprites ? palette[paletteRAM[index & 0x1F]] : GRAY_PALETTE[index & 3];
            }
        }
    }

    private void updateSpriteFields(int x, int y, int tile, int attribute, int oamAddress, int tileAddress, boolean priority, boolean xFlip, boolean yFlip) {
        this.xTextField.setText(Integer.toString(x));
        this.yTextField.setText(Integer.toString(y));
        this.tileTextField.setText(String.format("%02X", tile));
        this.attributeTextField.setText(String.format("%02X", attribute));
        this.oamAddressTextField.setText(String.format("%02X", oamAddress));
        this.tileAddressTextField.setText(String.format("%04X", tileAddress));
        this.priorityTextField.setText(priority ? "Behind" : "In Front");
        this.xFlipCheckBox.setSelected(xFlip);
        this.yFlipCheckBox.setSelected(yFlip);
    }

    private void updateScanlineComponents() {
        boolean enabled = !this.sprite0CheckBox.isSelected();
        this.scanlineLabel.setEnabled(enabled);
        this.scanlineTextField.setEnabled(enabled);
    }

    private void mouseUpdated(int x, int y) {
        if (this.mouseX == x && this.mouseY == y) {
            return;
        }
        this.mouseX = x;
        this.mouseY = y;
        this.hoverSpriteIndex = this.getSpriteIndex(x, y);
        MachineRunner r = this.machineRunner;
        if (r != null && r.isPaused()) {
            this.update(this.machine, this.ppu);
        }
    }

    private void mouseOutOfBounds() {
        this.mouseX = -1;
        this.mouseY = -1;
        this.hoverSpriteIndex = -1;
        MachineRunner r = this.machineRunner;
        if (r != null && r.isPaused()) {
            this.update(this.machine, this.ppu);
        }
    }

    private void mouseButtonPressed(int x, int y, boolean controlDown) {
        int index = this.getSpriteIndex(x, y);
        this.spriteIndexComboBox.setSelectedIndex(index == this.spriteIndex && controlDown ? 0 : index + 1);
        MachineRunner r = this.machineRunner;
        if (r != null && r.isPaused()) {
            this.update(this.machine, this.ppu);
        }
    }

    private int getSpriteIndex(int x, int y) {
        if (x >= 1 && y >= 1 && x <= 144 && y <= 68) {
            return (x - 1) / 9 + ((y - 1) / 17 << 4);
        }
        return -1;
    }

    private void enableComponents(boolean enabled) {
        this.framesPerUpdateLabel.setEnabled(enabled);
        this.framesPerUpdateComboBox.setEnabled(enabled);
        this.colorCheckBox.setEnabled(enabled);
        this.showHiddenSpritesCheckBox.setEnabled(enabled);
        this.sprite0CheckBox.setEnabled(enabled);
        this.scanlineLabel.setEnabled(enabled);
        this.scanlineTextField.setEnabled(enabled);
        this.spriteIndexLabel.setEnabled(enabled);
        this.spriteIndexComboBox.setEnabled(enabled);
        this.highlightCheckBox.setEnabled(enabled);
        this.defaultsButton.setEnabled(enabled);
        this.enableSpriteComponents(enabled);
        if (!enabled) {
            this.spriteIndexComboBox.setSelectedIndex(0);
        }
    }

    private void enableSpriteComponents(boolean enabled) {
        this.xLabel.setEnabled(enabled &= this.spriteIndex >= 0);
        this.xTextField.setEnabled(enabled);
        this.yLabel.setEnabled(enabled);
        this.yTextField.setEnabled(enabled);
        this.tileLabel.setEnabled(enabled);
        this.tileTextField.setEnabled(enabled);
        this.attributeLabel.setEnabled(enabled);
        this.attributeTextField.setEnabled(enabled);
        this.oamAddressLabel.setEnabled(enabled);
        this.oamAddressTextField.setEnabled(enabled);
        this.tileAddressLabel.setEnabled(enabled);
        this.tileAddressTextField.setEnabled(enabled);
        this.xFlipCheckBox.setEnabled(enabled);
        this.yFlipCheckBox.setEnabled(enabled);
        this.priorityLabel.setEnabled(enabled);
        this.priorityTextField.setEnabled(enabled);
        if (!enabled) {
            this.xTextField.setText("");
            this.yTextField.setText("");
            this.tileTextField.setText("");
            this.attributeTextField.setText("");
            this.oamAddressTextField.setText("");
            this.tileAddressTextField.setText("");
            this.xFlipCheckBox.setSelected(false);
            this.yFlipCheckBox.setSelected(false);
            this.priorityTextField.setText("");
        }
    }

    private void initComponents() {
        this.closeButton = new JButton();
        this.resizeButton = new JButton();
        this.oamDataPanel = new ImagePanel(147, 71, 3);
        this.displayPanel = new JPanel();
        this.scanlineLabel = new JLabel();
        this.framesPerUpdateComboBox = new JComboBox();
        this.framesPerUpdateLabel = new JLabel();
        this.scanlineTextField = new JTextField();
        this.colorCheckBox = new JCheckBox();
        this.sprite0CheckBox = new JCheckBox();
        this.showHiddenSpritesCheckBox = new JCheckBox();
        this.highlightCheckBox = new JCheckBox();
        this.spritePanel = new JPanel();
        this.spriteIndexLabel = new JLabel();
        this.spriteIndexComboBox = new JComboBox();
        this.xLabel = new JLabel();
        this.xTextField = new JTextField();
        this.yLabel = new JLabel();
        this.yTextField = new JTextField();
        this.tileLabel = new JLabel();
        this.tileTextField = new JTextField();
        this.attributeLabel = new JLabel();
        this.attributeTextField = new JTextField();
        this.oamAddressLabel = new JLabel();
        this.oamAddressTextField = new JTextField();
        this.tileAddressLabel = new JLabel();
        this.tileAddressTextField = new JTextField();
        this.priorityLabel = new JLabel();
        this.priorityTextField = new JTextField();
        this.xFlipCheckBox = new JCheckBox();
        this.yFlipCheckBox = new JCheckBox();
        this.defaultsButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("OAM Data");
        this.setMaximumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OamDataFrame.this.formWindowClosing(evt);
            }
        });
        this.closeButton.setMnemonic('C');
        this.closeButton.setText(" Close ");
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OamDataFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.resizeButton.setMnemonic('R');
        this.resizeButton.setText("Resize");
        this.resizeButton.setFocusPainted(false);
        this.resizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OamDataFrame.this.resizeButtonActionPerformed(evt);
            }
        });
        this.oamDataPanel.setMaximumSize(null);
        GroupLayout oamDataPanelLayout = new GroupLayout(this.oamDataPanel);
        this.oamDataPanel.setLayout(oamDataPanelLayout);
        oamDataPanelLayout.setHorizontalGroup(oamDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        oamDataPanelLayout.setVerticalGroup(oamDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 154, Short.MAX_VALUE));
        this.displayPanel.setBorder(BorderFactory.createTitledBorder("Display"));
        this.displayPanel.setMaximumSize(null);
        this.scanlineLabel.setText("Update on scanline:");
        this.scanlineLabel.setMaximumSize(null);
        this.scanlineLabel.setMinimumSize(null);
        this.scanlineLabel.setPreferredSize(null);
        this.framesPerUpdateComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "5", "15", "30", "60"}));
        this.framesPerUpdateComboBox.setFocusable(false);
        this.framesPerUpdateComboBox.setMaximumSize(null);
        this.framesPerUpdateComboBox.setMinimumSize(null);
        this.framesPerUpdateComboBox.setPreferredSize(null);
        this.framesPerUpdateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OamDataFrame.this.framesPerUpdateComboBoxActionPerformed(evt);
            }
        });
        this.framesPerUpdateLabel.setText("Frames per update:");
        this.framesPerUpdateLabel.setMaximumSize(null);
        this.framesPerUpdateLabel.setMinimumSize(null);
        this.framesPerUpdateLabel.setPreferredSize(null);
        this.scanlineTextField.setColumns(4);
        this.scanlineTextField.setMaximumSize(null);
        this.scanlineTextField.setMinimumSize(null);
        this.scanlineTextField.setPreferredSize(null);
        this.scanlineTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OamDataFrame.this.scanlineTextFieldActionPerformed(evt);
            }
        });
        this.colorCheckBox.setSelected(true);
        this.colorCheckBox.setText("Color");
        this.colorCheckBox.setFocusPainted(false);
        this.colorCheckBox.setMaximumSize(null);
        this.colorCheckBox.setMinimumSize(null);
        this.colorCheckBox.setPreferredSize(null);
        this.colorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OamDataFrame.this.colorCheckBoxActionPerformed(evt);
            }
        });
        this.sprite0CheckBox.setText("Update on sprite 0 hit");
        this.sprite0CheckBox.setFocusPainted(false);
        this.sprite0CheckBox.setMaximumSize(null);
        this.sprite0CheckBox.setMinimumSize(null);
        this.sprite0CheckBox.setPreferredSize(null);
        this.sprite0CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OamDataFrame.this.sprite0CheckBoxActionPerformed(evt);
            }
        });
        this.showHiddenSpritesCheckBox.setText("Show hidden sprites");
        this.showHiddenSpritesCheckBox.setFocusPainted(false);
        this.showHiddenSpritesCheckBox.setMaximumSize(null);
        this.showHiddenSpritesCheckBox.setMinimumSize(null);
        this.showHiddenSpritesCheckBox.setPreferredSize(null);
        this.showHiddenSpritesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OamDataFrame.this.showHiddenSpritesCheckBoxActionPerformed(evt);
            }
        });
        this.highlightCheckBox.setText("Highlight selected sprite");
        this.highlightCheckBox.setFocusPainted(false);
        this.highlightCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OamDataFrame.this.highlightCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout displayPanelLayout = new GroupLayout(this.displayPanel);
        this.displayPanel.setLayout(displayPanelLayout);
        displayPanelLayout.setHorizontalGroup(displayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(displayPanelLayout.createSequentialGroup().addContainerGap().addGroup(displayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.highlightCheckBox).addGroup(displayPanelLayout.createSequentialGroup().addComponent(this.framesPerUpdateLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.framesPerUpdateComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.colorCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showHiddenSpritesCheckBox, -2, -1, -2)).addGroup(displayPanelLayout.createSequentialGroup().addComponent(this.sprite0CheckBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.scanlineLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanlineTextField, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        displayPanelLayout.setVerticalGroup(displayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(displayPanelLayout.createSequentialGroup().addContainerGap().addGroup(displayPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.framesPerUpdateLabel, -2, -1, -2).addComponent(this.framesPerUpdateComboBox, -2, -1, -2).addComponent(this.colorCheckBox, -2, -1, -2).addComponent(this.showHiddenSpritesCheckBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(displayPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sprite0CheckBox, -2, -1, -2).addComponent(this.scanlineLabel, -2, -1, -2).addComponent(this.scanlineTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.highlightCheckBox).addContainerGap()));
        this.spritePanel.setBorder(BorderFactory.createTitledBorder("Sprite"));
        this.spritePanel.setMaximumSize(null);
        this.spriteIndexLabel.setText("Index:");
        this.spriteIndexLabel.setMaximumSize(null);
        this.spriteIndexLabel.setMinimumSize(null);
        this.spriteIndexLabel.setPreferredSize(null);
        this.spriteIndexComboBox.setFocusable(false);
        this.spriteIndexComboBox.setMaximumSize(null);
        this.spriteIndexComboBox.setMinimumSize(null);
        this.spriteIndexComboBox.setPreferredSize(null);
        this.spriteIndexComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OamDataFrame.this.spriteIndexComboBoxActionPerformed(evt);
            }
        });
        this.xLabel.setText("X:");
        this.xLabel.setMaximumSize(null);
        this.xLabel.setMinimumSize(null);
        this.xLabel.setPreferredSize(null);
        this.xTextField.setEditable(false);
        this.xTextField.setColumns(3);
        this.xTextField.setFocusable(false);
        this.xTextField.setMaximumSize(null);
        this.xTextField.setMinimumSize(null);
        this.xTextField.setPreferredSize(null);
        this.yLabel.setText("Y:");
        this.yLabel.setMaximumSize(null);
        this.yLabel.setMinimumSize(null);
        this.yLabel.setPreferredSize(null);
        this.yTextField.setEditable(false);
        this.yTextField.setColumns(3);
        this.yTextField.setFocusable(false);
        this.yTextField.setMaximumSize(null);
        this.yTextField.setMinimumSize(null);
        this.yTextField.setPreferredSize(null);
        this.tileLabel.setText("Tile:");
        this.tileLabel.setMaximumSize(null);
        this.tileLabel.setMinimumSize(null);
        this.tileLabel.setPreferredSize(null);
        this.tileTextField.setEditable(false);
        this.tileTextField.setColumns(2);
        this.tileTextField.setFocusable(false);
        this.tileTextField.setMaximumSize(null);
        this.tileTextField.setMinimumSize(null);
        this.tileTextField.setPreferredSize(null);
        this.attributeLabel.setText("Attribute:");
        this.attributeLabel.setMaximumSize(null);
        this.attributeLabel.setMinimumSize(null);
        this.attributeLabel.setPreferredSize(null);
        this.attributeTextField.setEditable(false);
        this.attributeTextField.setColumns(2);
        this.attributeTextField.setFocusable(false);
        this.attributeTextField.setMaximumSize(null);
        this.attributeTextField.setMinimumSize(null);
        this.attributeTextField.setPreferredSize(null);
        this.oamAddressLabel.setText("OAM address:");
        this.oamAddressLabel.setMaximumSize(null);
        this.oamAddressLabel.setMinimumSize(null);
        this.oamAddressLabel.setPreferredSize(null);
        this.oamAddressTextField.setEditable(false);
        this.oamAddressTextField.setColumns(2);
        this.oamAddressTextField.setFocusable(false);
        this.oamAddressTextField.setMaximumSize(null);
        this.oamAddressTextField.setMinimumSize(null);
        this.oamAddressTextField.setPreferredSize(null);
        this.tileAddressLabel.setText("Tile address:");
        this.tileAddressLabel.setMaximumSize(null);
        this.tileAddressLabel.setMinimumSize(null);
        this.tileAddressLabel.setPreferredSize(null);
        this.tileAddressTextField.setEditable(false);
        this.tileAddressTextField.setColumns(4);
        this.tileAddressTextField.setFocusable(false);
        this.tileAddressTextField.setMaximumSize(null);
        this.tileAddressTextField.setMinimumSize(null);
        this.tileAddressTextField.setPreferredSize(null);
        this.priorityLabel.setText("Priority:");
        this.priorityLabel.setMaximumSize(null);
        this.priorityLabel.setMinimumSize(null);
        this.priorityLabel.setPreferredSize(null);
        this.priorityTextField.setEditable(false);
        this.priorityTextField.setColumns(8);
        this.priorityTextField.setFocusable(false);
        this.priorityTextField.setMaximumSize(null);
        this.priorityTextField.setMinimumSize(null);
        this.priorityTextField.setPreferredSize(null);
        this.xFlipCheckBox.setText("X-flip");
        this.xFlipCheckBox.setFocusPainted(false);
        this.xFlipCheckBox.setFocusable(false);
        this.xFlipCheckBox.setMaximumSize(null);
        this.xFlipCheckBox.setMinimumSize(null);
        this.xFlipCheckBox.setPreferredSize(null);
        this.yFlipCheckBox.setText("Y-flip");
        this.yFlipCheckBox.setFocusPainted(false);
        this.yFlipCheckBox.setFocusable(false);
        this.yFlipCheckBox.setMaximumSize(null);
        this.yFlipCheckBox.setMinimumSize(null);
        this.yFlipCheckBox.setPreferredSize(null);
        GroupLayout spritePanelLayout = new GroupLayout(this.spritePanel);
        this.spritePanel.setLayout(spritePanelLayout);
        spritePanelLayout.setHorizontalGroup(spritePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spritePanelLayout.createSequentialGroup().addContainerGap().addGroup(spritePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spritePanelLayout.createSequentialGroup().addComponent(this.xFlipCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.yFlipCheckBox, -2, -1, -2)).addGroup(spritePanelLayout.createSequentialGroup().addComponent(this.spriteIndexLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spriteIndexComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.xLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.yLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tileLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tileTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.attributeLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attributeTextField, -2, -1, -2)).addGroup(spritePanelLayout.createSequentialGroup().addComponent(this.oamAddressLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oamAddressTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tileAddressLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tileAddressTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.priorityLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.priorityTextField, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        spritePanelLayout.setVerticalGroup(spritePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spritePanelLayout.createSequentialGroup().addContainerGap().addGroup(spritePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spriteIndexLabel, -2, -1, -2).addComponent(this.spriteIndexComboBox, -2, -1, -2).addComponent(this.xLabel, -2, -1, -2).addComponent(this.xTextField, -2, -1, -2).addComponent(this.yLabel, -2, -1, -2).addComponent(this.yTextField, -2, -1, -2).addComponent(this.tileLabel, -2, -1, -2).addComponent(this.tileTextField, -2, -1, -2).addComponent(this.attributeLabel, -2, -1, -2).addComponent(this.attributeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(spritePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.oamAddressLabel, -2, -1, -2).addComponent(this.oamAddressTextField, -2, -1, -2).addComponent(this.tileAddressLabel, -2, -1, -2).addComponent(this.tileAddressTextField, -2, -1, -2).addComponent(this.priorityLabel, -2, -1, -2).addComponent(this.priorityTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(spritePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xFlipCheckBox, -2, -1, -2).addComponent(this.yFlipCheckBox, -2, -1, -2)).addContainerGap()));
        this.defaultsButton.setMnemonic('D');
        this.defaultsButton.setText("Defaults");
        this.defaultsButton.setFocusPainted(false);
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OamDataFrame.this.defaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.defaultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resizeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent(this.oamDataPanel, -1, -1, Short.MAX_VALUE).addComponent(this.displayPanel, -1, -1, Short.MAX_VALUE).addComponent(this.spritePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.closeButton, this.defaultsButton, this.resizeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.oamDataPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.displayPanel, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spritePanel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.resizeButton).addComponent(this.defaultsButton)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void resizeButtonActionPerformed(ActionEvent evt) {
        this.pack();
    }

    private void framesPerUpdateComboBoxActionPerformed(ActionEvent evt) {
        Object item = this.framesPerUpdateComboBox.getSelectedItem();
        if (item != null) {
            try {
                this.framesPerUpdate = Integer.parseInt(item.toString().trim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void scanlineTextFieldActionPerformed(ActionEvent evt) {
        this.requestFocusInWindow();
    }

    private void sprite0CheckBoxActionPerformed(ActionEvent evt) {
        this.updateOnSprite0Hit = this.sprite0CheckBox.isSelected();
        this.updateScanlineComponents();
    }

    private void spriteIndexComboBoxActionPerformed(ActionEvent evt) {
        this.spriteIndex = this.spriteIndexComboBox.getSelectedIndex() - 1;
        this.enableSpriteComponents(this.machine != null);
    }

    private void colorCheckBoxActionPerformed(ActionEvent evt) {
        this.colorSprites = this.colorCheckBox.isSelected();
        MachineRunner r = this.machineRunner;
        if (r != null && r.isPaused()) {
            this.update(this.machine, this.ppu);
        }
    }

    private void showHiddenSpritesCheckBoxActionPerformed(ActionEvent evt) {
        this.showHiddenSprites = this.showHiddenSpritesCheckBox.isSelected();
        MachineRunner r = this.machineRunner;
        if (r != null && r.isPaused()) {
            this.update(this.machine, this.ppu);
        }
    }

    private void highlightCheckBoxActionPerformed(ActionEvent evt) {
        this.highlightSelectedSprite = this.highlightCheckBox.isSelected();
        if (!this.highlightSelectedSprite) {
            PPU.clearHighlightedSprite();
        }
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        this.loadFields(new OamDataPrefs());
    }
}

