/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.palettes;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import nintaco.App;
import nintaco.files.FileUtil;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.InputDialog;
import nintaco.gui.image.preferences.Paths;
import nintaco.gui.palettes.PalettePanel;
import nintaco.palettes.PalettePPU;
import nintaco.palettes.PaletteUtil;
import nintaco.palettes.Palettes;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;

public class PaletteOptionsDialog
extends JDialog {
    private static final int MAX_PALETTE_NAME_LENGTH = 15;
    public static final FileExtensionFilter palExtensionFilter = new FileExtensionFilter(0, "Palette files (*.pal)", "pal");
    private static final PalettePPU[] palettePpuValues = new PalettePPU[]{PalettePPU._2C02, PalettePPU._2C03_2C05, PalettePPU.RP2C04_0001, PalettePPU.RP2C04_0002, PalettePPU.RP2C04_0003, PalettePPU.RP2C04_0004};
    private final Map<PalettePPU, String> ppuPaletteMapping = new HashMap<PalettePPU, String>();
    private final Map<String, int[]> palettes = new HashMap<String, int[]>();
    private final Map<String, int[]> originalPalettes = new HashMap<String, int[]>();
    private final List<String> paletteNames = new ArrayList<String>();
    private final JComboBox[] comboBoxes;
    private final JComboBox[] ppuMappingComboBoxes;
    private JComboBox<String> RP2C04_0001ComboBox;
    private JLabel RP2C04_0001Label;
    private JComboBox<String> RP2C04_0002ComboBox;
    private JLabel RP2C04_0002Label;
    private JComboBox<String> RP2C04_0003ComboBox;
    private JLabel RP2C04_0003Label;
    private JComboBox<String> RP2C04_0004ComboBox;
    private JLabel RP2C04_0004Label;
    private JComboBox<String> _2C02ComboBox;
    private JLabel _2C02Label;
    private JComboBox<String> _2C03and2C05ComboBox;
    private JLabel _2C03and2C05Label;
    private JButton cancelButton;
    private JLabel colorLabel;
    private JLabel colorValueLabel;
    private JButton defaultsButton;
    private JButton duplicateButton;
    private JPanel editPanel;
    private JButton exportButton;
    private JButton importButton;
    private JLabel indexLabel;
    private JLabel indexValueLabel;
    private JPanel mappingPanel;
    private JButton okButton;
    private JComboBox<String> paletteComboBox;
    private JLabel paletteLabel;
    private JPanel palettePanel;
    private JButton removeButton;
    private JButton renameButton;
    private JButton resetButton;

    public PaletteOptionsDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.comboBoxes = new JComboBox[]{this.paletteComboBox, this._2C02ComboBox, this._2C03and2C05ComboBox, this.RP2C04_0001ComboBox, this.RP2C04_0002ComboBox, this.RP2C04_0003ComboBox, this.RP2C04_0004ComboBox};
        this.ppuMappingComboBoxes = new JComboBox[]{this._2C02ComboBox, this._2C03and2C05ComboBox, this.RP2C04_0001ComboBox, this.RP2C04_0002ComboBox, this.RP2C04_0003ComboBox, this.RP2C04_0004ComboBox};
        this.initDataStructures();
        this.populateComboBoxes();
        this.setPpuMappingComboBoxes();
        GuiUtil.makeMonospaced(this.indexValueLabel);
        GuiUtil.makeMonospaced(this.colorValueLabel);
        GuiUtil.scaleFonts(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.paletteSelected();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initDataStructures() {
        Palettes prefs = AppPrefs.getInstance().getPalettes();
        prefs.getPpuPaletteMapping(this.ppuPaletteMapping);
        prefs.getPalettes(this.palettes);
        prefs.getPaletteNames(this.paletteNames);
    }

    private void populateComboBoxes() {
        for (JComboBox comboBox : this.comboBoxes) {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            for (String name : this.paletteNames) {
                model.addElement(name);
            }
            comboBox.setModel(model);
        }
    }

    private void setPpuMappingComboBoxes() {
        for (int i = this.ppuMappingComboBoxes.length - 1; i >= 0; --i) {
            this.ppuMappingComboBoxes[i].setSelectedItem(this.ppuPaletteMapping.get((Object)palettePpuValues[i]));
        }
    }

    public void paletteSelectionChanged(int index, int color) {
        if (index < 0) {
            this.indexValueLabel.setText("-  ");
            this.colorValueLabel.setText("-      ");
        } else {
            this.indexValueLabel.setText(String.format("$%02X", index));
            this.colorValueLabel.setText(String.format("$%06X", color));
        }
    }

    private void paletteSelected() {
        String paletteName = (String)this.paletteComboBox.getSelectedItem();
        ((PalettePanel)this.palettePanel).setPalette(this.palettes.get(paletteName));
        boolean enabled = !PaletteUtil.isStandardPaletteName(paletteName);
        this.removeButton.setEnabled(enabled);
        this.renameButton.setEnabled(enabled);
    }

    private boolean validateName(String name) {
        return (name = name.trim()).length() > 0 && name.length() <= 15 && this.isUniqueName(name);
    }

    private boolean isUniqueName(String name) {
        for (int i = this.paletteNames.size() - 1; i >= 0; --i) {
            if (!this.paletteNames.get(i).equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    private void saveFields() {
        Palettes prefs = AppPrefs.getInstance().getPalettes();
        prefs.setPalettes(this.palettes);
        prefs.setPpuPaletteMapping(this.ppuPaletteMapping);
        AppPrefs.save();
    }

    private void closeDialog() {
        this.dispose();
    }

    private void mappingChanged(PalettePPU palettePPU, JComboBox comboBox) {
        String paletteName = (String)comboBox.getSelectedItem();
        this.ppuPaletteMapping.put(palettePPU, paletteName);
        this.paletteComboBox.setSelectedItem(paletteName);
    }

    private void initComponents() {
        this.mappingPanel = new JPanel();
        this.paletteLabel = new JLabel();
        this.resetButton = new JButton();
        this.paletteComboBox = new JComboBox();
        this.colorLabel = new JLabel();
        this.importButton = new JButton();
        this.removeButton = new JButton();
        this.colorValueLabel = new JLabel();
        this.renameButton = new JButton();
        this.indexLabel = new JLabel();
        this.palettePanel = new PalettePanel(this);
        this.indexValueLabel = new JLabel();
        this.exportButton = new JButton();
        this.duplicateButton = new JButton();
        this.editPanel = new JPanel();
        this._2C02Label = new JLabel();
        this._2C03and2C05Label = new JLabel();
        this.RP2C04_0001Label = new JLabel();
        this.RP2C04_0002Label = new JLabel();
        this.RP2C04_0003Label = new JLabel();
        this.RP2C04_0004Label = new JLabel();
        this._2C02ComboBox = new JComboBox();
        this._2C03and2C05ComboBox = new JComboBox();
        this.RP2C04_0001ComboBox = new JComboBox();
        this.RP2C04_0002ComboBox = new JComboBox();
        this.RP2C04_0003ComboBox = new JComboBox();
        this.RP2C04_0004ComboBox = new JComboBox();
        this.defaultsButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Palette Options");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PaletteOptionsDialog.this.formWindowClosing(evt);
            }
        });
        this.mappingPanel.setBorder(BorderFactory.createTitledBorder("Edit Palette"));
        this.paletteLabel.setText("Palette:");
        this.resetButton.setMnemonic('s');
        this.resetButton.setText("Reset");
        this.resetButton.setFocusPainted(false);
        this.resetButton.setRequestFocusEnabled(false);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.resetButtonActionPerformed(evt);
            }
        });
        this.paletteComboBox.setFocusable(false);
        this.paletteComboBox.setRequestFocusEnabled(false);
        this.paletteComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.paletteComboBoxActionPerformed(evt);
            }
        });
        this.colorLabel.setText("Color:");
        this.importButton.setMnemonic('I');
        this.importButton.setText("Import...");
        this.importButton.setFocusPainted(false);
        this.importButton.setRequestFocusEnabled(false);
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.importButtonActionPerformed(evt);
            }
        });
        this.removeButton.setMnemonic('R');
        this.removeButton.setText("Remove");
        this.removeButton.setFocusPainted(false);
        this.removeButton.setRequestFocusEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.removeButtonActionPerformed(evt);
            }
        });
        this.colorValueLabel.setText("-      ");
        this.renameButton.setMnemonic('n');
        this.renameButton.setText("Rename");
        this.renameButton.setFocusPainted(false);
        this.renameButton.setRequestFocusEnabled(false);
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.renameButtonActionPerformed(evt);
            }
        });
        this.indexLabel.setText("Index:");
        this.palettePanel.setRequestFocusEnabled(false);
        GroupLayout palettePanelLayout = new GroupLayout(this.palettePanel);
        this.palettePanel.setLayout(palettePanelLayout);
        palettePanelLayout.setHorizontalGroup(palettePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        palettePanelLayout.setVerticalGroup(palettePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.indexValueLabel.setText("-  ");
        this.exportButton.setMnemonic('x');
        this.exportButton.setText("Export...");
        this.exportButton.setFocusPainted(false);
        this.exportButton.setRequestFocusEnabled(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.exportButtonActionPerformed(evt);
            }
        });
        this.duplicateButton.setText("Duplicate...");
        this.duplicateButton.setFocusPainted(false);
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.duplicateButtonActionPerformed(evt);
            }
        });
        GroupLayout mappingPanelLayout = new GroupLayout(this.mappingPanel);
        this.mappingPanel.setLayout(mappingPanelLayout);
        mappingPanelLayout.setHorizontalGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.palettePanel, -1, -1, Short.MAX_VALUE).addGroup(mappingPanelLayout.createSequentialGroup().addComponent(this.paletteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paletteComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.renameButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(mappingPanelLayout.createSequentialGroup().addComponent(this.indexLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexValueLabel).addGap(18, 18, 18).addComponent(this.colorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.duplicateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportButton))).addContainerGap()));
        mappingPanelLayout.linkSize(0, this.duplicateButton, this.exportButton, this.importButton);
        mappingPanelLayout.linkSize(0, this.removeButton, this.renameButton, this.resetButton);
        mappingPanelLayout.setVerticalGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.paletteLabel).addComponent(this.paletteComboBox, -2, -1, -2).addComponent(this.removeButton).addComponent(this.renameButton).addComponent(this.resetButton)).addGap(18, 18, 18).addComponent(this.palettePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.importButton).addComponent(this.exportButton).addComponent(this.duplicateButton)).addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.indexLabel).addComponent(this.indexValueLabel).addComponent(this.colorLabel).addComponent(this.colorValueLabel))).addContainerGap()));
        this.editPanel.setBorder(BorderFactory.createTitledBorder("PPU Palette Mapping"));
        this._2C02Label.setText("2C02:");
        this._2C03and2C05Label.setText("2C03/2C05:");
        this.RP2C04_0001Label.setText("RP2C04-0001:");
        this.RP2C04_0002Label.setText("RP2C04-0002:");
        this.RP2C04_0003Label.setText("RP2C04-0003:");
        this.RP2C04_0004Label.setText("RP2C04-0004:");
        this._2C02ComboBox.setFocusable(false);
        this._2C02ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this._2C02ComboBoxActionPerformed(evt);
            }
        });
        this._2C03and2C05ComboBox.setFocusable(false);
        this._2C03and2C05ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this._2C03and2C05ComboBoxActionPerformed(evt);
            }
        });
        this.RP2C04_0001ComboBox.setFocusable(false);
        this.RP2C04_0001ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.RP2C04_0001ComboBoxActionPerformed(evt);
            }
        });
        this.RP2C04_0002ComboBox.setFocusable(false);
        this.RP2C04_0002ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.RP2C04_0002ComboBoxActionPerformed(evt);
            }
        });
        this.RP2C04_0003ComboBox.setFocusable(false);
        this.RP2C04_0003ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.RP2C04_0003ComboBoxActionPerformed(evt);
            }
        });
        this.RP2C04_0004ComboBox.setFocusable(false);
        this.RP2C04_0004ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.RP2C04_0004ComboBoxActionPerformed(evt);
            }
        });
        this.defaultsButton.setMnemonic('D');
        this.defaultsButton.setText("Restore Defaults");
        this.defaultsButton.setFocusPainted(false);
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.defaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout editPanelLayout = new GroupLayout(this.editPanel);
        this.editPanel.setLayout(editPanelLayout);
        editPanelLayout.setHorizontalGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editPanelLayout.createSequentialGroup().addContainerGap().addGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._2C02Label).addComponent(this._2C03and2C05Label).addComponent(this.RP2C04_0001Label).addComponent(this.RP2C04_0002Label).addComponent(this.RP2C04_0003Label).addComponent(this.RP2C04_0004Label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._2C02ComboBox, -2, -1, -2).addComponent(this._2C03and2C05ComboBox, -2, -1, -2).addComponent(this.RP2C04_0001ComboBox, -2, -1, -2).addComponent(this.RP2C04_0002ComboBox, -2, -1, -2).addComponent(this.RP2C04_0003ComboBox, -2, -1, -2).addComponent(this.RP2C04_0004ComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, editPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.defaultsButton)));
        editPanelLayout.setVerticalGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editPanelLayout.createSequentialGroup().addContainerGap().addGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._2C02Label).addComponent(this._2C02ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._2C03and2C05Label).addComponent(this._2C03and2C05ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RP2C04_0001Label).addComponent(this.RP2C04_0001ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RP2C04_0002Label).addComponent(this.RP2C04_0002ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RP2C04_0003Label).addComponent(this.RP2C04_0003ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RP2C04_0004Label).addComponent(this.RP2C04_0004ComboBox, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addComponent(this.defaultsButton).addContainerGap()));
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setRequestFocusEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaletteOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.editPanel, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mappingPanel, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addGap(8, 8, 8).addComponent(this.cancelButton))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editPanel, -1, -1, Short.MAX_VALUE).addComponent(this.mappingPanel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
    }

    private void paletteComboBoxActionPerformed(ActionEvent evt) {
        this.paletteSelected();
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        int[] palette;
        String paletteName = (String)this.paletteComboBox.getSelectedItem();
        int[] pal = this.palettes.get(paletteName);
        if (!AppPrefs.getInstance().getPalettes().getOriginalPalette(paletteName, pal) && (palette = this.originalPalettes.get(paletteName)) != null) {
            System.arraycopy(palette, 0, pal, 0, 64);
        }
        this.paletteSelected();
        this.repaint();
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        PaletteUtil.getDefaultMapping(this.ppuPaletteMapping);
        this.setPpuMappingComboBoxes();
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        InputDialog dialog = new InputDialog((Window)this, "Please provide a name for the new palette:", "Duplicate Palette");
        dialog.setTextRequired();
        dialog.setInputValidator(this::validateName);
        dialog.setMaxInputLength(15);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            String name = dialog.getInput();
            int[] palette = new int[64];
            System.arraycopy(this.palettes.get((String)this.paletteComboBox.getSelectedItem()), 0, palette, 0, 64);
            this.palettes.put(name, palette);
            palette = new int[64];
            System.arraycopy(this.palettes.get((String)this.paletteComboBox.getSelectedItem()), 0, palette, 0, 64);
            this.originalPalettes.put(name, palette);
            this.paletteNames.add(name);
            Collections.sort(this.paletteNames, String.CASE_INSENSITIVE_ORDER);
            this.populateComboBoxes();
            this.setPpuMappingComboBoxes();
            this.paletteComboBox.setSelectedItem(name);
            this.paletteSelected();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        String name = (String)this.paletteComboBox.getSelectedItem();
        if (PaletteUtil.isStandardPaletteName(name)) {
            return;
        }
        for (PalettePPU palettePPU : PalettePPU.values()) {
            if (!this.ppuPaletteMapping.get((Object)palettePPU).equals(name)) continue;
            this.ppuPaletteMapping.put(palettePPU, PaletteUtil.getDefaultName(palettePPU));
        }
        this.paletteNames.remove(name);
        this.palettes.remove(name);
        this.populateComboBoxes();
        this.setPpuMappingComboBoxes();
        this.paletteSelected();
    }

    private void _2C02ComboBoxActionPerformed(ActionEvent evt) {
        this.mappingChanged(PalettePPU._2C02, this._2C02ComboBox);
    }

    private void _2C03and2C05ComboBoxActionPerformed(ActionEvent evt) {
        this.mappingChanged(PalettePPU._2C03_2C05, this._2C03and2C05ComboBox);
    }

    private void RP2C04_0001ComboBoxActionPerformed(ActionEvent evt) {
        this.mappingChanged(PalettePPU.RP2C04_0001, this.RP2C04_0001ComboBox);
    }

    private void RP2C04_0002ComboBoxActionPerformed(ActionEvent evt) {
        this.mappingChanged(PalettePPU.RP2C04_0002, this.RP2C04_0002ComboBox);
    }

    private void RP2C04_0003ComboBoxActionPerformed(ActionEvent evt) {
        this.mappingChanged(PalettePPU.RP2C04_0003, this.RP2C04_0003ComboBox);
    }

    private void RP2C04_0004ComboBoxActionPerformed(ActionEvent evt) {
        this.mappingChanged(PalettePPU.RP2C04_0004, this.RP2C04_0004ComboBox);
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        InputDialog dialog = new InputDialog((Window)this, "Please provide a new name for this palette:", "Rename Palette");
        dialog.setTextRequired();
        dialog.setInputValidator(this::validateName);
        dialog.setMaxInputLength(15);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            String oldName = (String)this.paletteComboBox.getSelectedItem();
            String newName = dialog.getInput();
            this.paletteNames.remove(oldName);
            this.paletteNames.add(newName);
            Collections.sort(this.paletteNames, String.CASE_INSENSITIVE_ORDER);
            for (PalettePPU palettePPU : PalettePPU.values()) {
                if (!this.ppuPaletteMapping.get((Object)palettePPU).equals(oldName)) continue;
                this.ppuPaletteMapping.put(palettePPU, newName);
            }
            this.palettes.put(newName, this.palettes.remove(oldName));
            this.populateComboBoxes();
            this.setPpuMappingComboBoxes();
            this.paletteComboBox.setSelectedItem(newName);
            this.paletteSelected();
        }
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        Paths paths = AppPrefs.getInstance().getPaths();
        String palettesDir = paths.getPalettesDir();
        FileUtil.mkdir(palettesDir);
        JFileChooser chooser = GuiUtil.createFileChooser("Import Palette", palettesDir, palExtensionFilter);
        if (GuiUtil.showOpenDialog(this, chooser, (p, d) -> p.setPalettesDir((String)d)) == 0) {
            int[] loadedPalette;
            try {
                loadedPalette = PaletteUtil.loadPalette(chooser.getSelectedFile());
            }
            catch (Throwable t) {
                GuiUtil.displayError(this, "Failed to read palette file.");
                return;
            }
            InputDialog dialog = new InputDialog((Window)this, "Please provide a name for the new palette:", "Import Palette");
            dialog.setTextRequired();
            dialog.setInputValidator(this::validateName);
            dialog.setMaxInputLength(15);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                String name = dialog.getInput();
                this.palettes.put(name, loadedPalette);
                int[] palette = new int[64];
                System.arraycopy(loadedPalette, 0, palette, 0, 64);
                this.originalPalettes.put(name, palette);
                this.paletteNames.add(name);
                Collections.sort(this.paletteNames, String.CASE_INSENSITIVE_ORDER);
                this.populateComboBoxes();
                this.setPpuMappingComboBoxes();
                this.paletteComboBox.setSelectedItem(name);
                this.paletteSelected();
            }
        }
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        String name = (String)this.paletteComboBox.getSelectedItem();
        Paths paths = AppPrefs.getInstance().getPaths();
        String fileName = name + ".pal";
        String palettesDir = paths.getPalettesDir();
        FileUtil.mkdir(palettesDir);
        File file = GuiUtil.showSaveAsDialog(this, palettesDir, fileName, "pal", palExtensionFilter, true, "Export Palette File");
        if (file != null) {
            String dir = file.getParent();
            paths.addRecentDirectory(dir);
            paths.setPalettesDir(dir);
            AppPrefs.save();
            try {
                PaletteUtil.savePalette(this.palettes.get(name), file);
            }
            catch (Throwable t) {
                GuiUtil.displayError(this, "Failed to write palette file.");
                return;
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveFields();
        PaletteUtil.update();
        App.getImageFrame().createPaletteMenu();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }
}

