/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.ramwatch;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import nintaco.gui.ramwatch.RamWatchRow;

public class RamWatchTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Address", "Value", "Description"};
    private List<RamWatchRow> rows = new ArrayList<RamWatchRow>();

    public RamWatchTableModel() {
    }

    public RamWatchTableModel(List<RamWatchRow> rows) {
        this.rows = rows;
    }

    public List<RamWatchRow> getRows() {
        return this.rows;
    }

    public void copyRows(List<RamWatchRow> rows) {
        this.rows.clear();
        for (RamWatchRow row : rows) {
            this.rows.add(new RamWatchRow(row));
        }
    }

    public void setRows(List<RamWatchRow> rows) {
        this.rows = rows;
    }

    public RamWatchRow getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RamWatchRow row = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.getAddressStr();
            }
            case 1: {
                return row.getValueStr();
            }
        }
        return row.getDescription();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }
}

