/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.rob;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import nintaco.gui.rob.RobPane;

public class GyromitePane
extends RobPane {
    private static final Color GYRO_SHAFT = new Color(11843241);
    private static final Color GYRO_BASE = new Color(14145741);
    private static final Color GYRO_HOLDER = Color.BLACK;
    private static final Color A_BUTTON = new Color(2005759);
    private static final Color B_BUTTON = new Color(16722454);
    private static final Color HANDS = new Color(8024190);
    private static final int[][] GYRO_POLYGON = new int[][]{{0, 11, 16, 16, 18, 18, -18, -18, -16, -16, -11}, {0, 5, 44, 149, 149, 152, 152, 149, 149, 44, 5}};
    private static final int[][] GYRO_HOLDER_POLYGON = new int[][]{{0, 10, 18, 66, 66, -66, -66, -18, -10}, {0, 0, 76, 76, 83, 83, 76, 76, 0}};
    private static final int[][] LEFT_HAND_POLYGON = new int[][]{{-76, -16, -16, 16, 16, -16, -16, -76}, {-149, -149, -136, -132, -126, -122, -109, -109}};
    private static final int[][] RIGHT_HAND_POLYGON = new int[][]{{16, -16, -16, 16, 16, -16, -16, 16, 76, 76}, {-109, -115, -122, -126, -132, -136, -142, -149, -149, -109}};

    public GyromitePane() {
        this.state.game = 1;
        this.state.reset();
    }

    @Override
    protected double convertY(double y) {
        return 343.0 + 40.0 * y;
    }

    private void drawHands(Graphics2D g, double x, double y, double open) {
        x = this.convertX(x);
        y = this.convertY(y);
        AffineTransform transform = g.getTransform();
        g.setColor(HANDS);
        g.translate(x - (open *= 40.0), y);
        g.fillPolygon(LEFT_HAND_POLYGON[0], LEFT_HAND_POLYGON[1], LEFT_HAND_POLYGON[0].length);
        g.setTransform(transform);
        g.translate(x + open, y);
        g.fillPolygon(RIGHT_HAND_POLYGON[0], RIGHT_HAND_POLYGON[1], RIGHT_HAND_POLYGON[0].length);
        g.setTransform(transform);
    }

    private void drawButton(Graphics2D g, double x, double y, Color color) {
        AffineTransform transform = g.getTransform();
        g.translate(this.convertX(x), this.convertY(y));
        g.setColor(color);
        g.fillRect(-42, -5, 84, 25);
        g.setTransform(transform);
    }

    private void drawSpinner(Graphics2D g, double x, double y) {
        AffineTransform transform = g.getTransform();
        g.translate(x, y + 34.0);
        g.setColor(GYRO_HOLDER);
        g.fillRect(-48, 0, 96, 12);
        g.fillRect(-40, 12, 80, 4);
        g.setColor(GYRO_SHAFT);
        g.fillRect(-48, 16, 96, 82);
        g.fillRect(-56, 82, 112, 81);
        g.setTransform(transform);
    }

    private void drawGyroHolder(Graphics2D g, double x, double y) {
        AffineTransform transform = g.getTransform();
        g.translate(x, y + 117.0);
        g.scale(1.0, -1.0);
        g.setColor(GYRO_HOLDER);
        g.fillPolygon(GYRO_HOLDER_POLYGON[0], GYRO_HOLDER_POLYGON[1], GYRO_HOLDER_POLYGON[0].length);
        g.setTransform(transform);
    }

    private void drawGyro(Graphics2D g, double x, double y) {
        AffineTransform transform = g.getTransform();
        g.translate(this.convertX(x), this.convertY(y));
        g.scale(1.0, -1.0);
        g.setColor(GYRO_SHAFT);
        g.fillPolygon(GYRO_POLYGON[0], GYRO_POLYGON[1], GYRO_POLYGON[0].length);
        g.setColor(GYRO_BASE);
        g.fillRect(-111, 44, 222, 25);
        g.setTransform(transform);
    }

    @Override
    protected void draw(Graphics2D g) {
        this.drawROB(g, 630.0, 10.0, this.state.testing);
        for (int i = 2; i >= 0; --i) {
            this.drawGyro(g, this.state.pieces[i][0], this.state.pieces[i][1]);
        }
        this.drawGyroHolder(g, 170.0, 425.0);
        this.drawGyroHolder(g, 400.0, 425.0);
        this.drawSpinner(g, 1090.0, 345.0);
        this.drawButton(g, 0.0, this.state.aButtonY, A_BUTTON);
        this.drawButton(g, 1.0, this.state.bButtonY, B_BUTTON);
        this.drawHands(g, this.state.handsX, this.state.handsY, this.state.handsOpen);
    }
}

