/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.rob;

import java.io.Serializable;
import nintaco.gui.rob.RobCommand;
import nintaco.gui.rob.RobState;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public abstract class RobController
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int TEST_STEPS = 60;
    protected final RobState state = new RobState();
    protected RobCommand executingCommand;
    protected int counter;
    protected int shiftRegister;
    protected volatile RobCommand requestedCommand;

    public RobState getState() {
        return this.state;
    }

    public void scanMemory(Mapper mapper) {
    }

    public int pollButtons(int buttons, Mapper mapper) {
        return buttons;
    }

    public void request(RobCommand requestedCommand) {
        this.requestedCommand = requestedCommand;
    }

    public void signal(boolean greenScreen) {
        this.shiftRegister = this.shiftRegister << 1 | BitUtil.toBit(greenScreen);
        switch (this.shiftRegister & 0x1FFF) {
            case 686: 
            case 763: {
                this.request(RobCommand.MoveDown);
                break;
            }
            case 698: {
                this.request(RobCommand.MoveLeft);
                break;
            }
            case 699: 
            case 762: {
                this.request(RobCommand.MoveUp);
                break;
            }
            case 702: {
                this.request(RobCommand.CloseHands);
                break;
            }
            case 746: {
                this.request(RobCommand.MoveRight);
                break;
            }
            case 747: {
                this.request(RobCommand.Test);
                break;
            }
            case 750: {
                this.request(RobCommand.OpenHands);
            }
        }
    }

    public boolean update() {
        RobCommand request = this.requestedCommand;
        this.requestedCommand = null;
        if (this.executingCommand == null && request != null) {
            this.executingCommand = request;
            this.initCommand();
        }
        if (this.executingCommand != null) {
            this.executeCommand();
            ++this.state.modifications;
            return true;
        }
        return false;
    }

    protected void initCommand() {
        switch (this.executingCommand) {
            case MoveUp: {
                this.initMoveUp();
                break;
            }
            case MoveDown: {
                this.initMoveDown();
                break;
            }
            case MoveLeft: {
                this.initMoveLeft();
                break;
            }
            case MoveRight: {
                this.initMoveRight();
                break;
            }
            case OpenHands: {
                this.initOpenHands();
                break;
            }
            case CloseHands: {
                this.initCloseHands();
                break;
            }
            case Test: {
                this.initTest();
                break;
            }
            case Repaint: {
                this.initRepaint();
                break;
            }
            case AdvancePhase: {
                this.initAdvancePhase();
            }
        }
    }

    protected void executeCommand() {
        switch (this.executingCommand) {
            case MoveUp: {
                this.executeMoveUp();
                break;
            }
            case MoveDown: {
                this.executeMoveDown();
                break;
            }
            case MoveLeft: {
                this.executeMoveLeft();
                break;
            }
            case MoveRight: {
                this.executeMoveRight();
                break;
            }
            case OpenHands: {
                this.executeOpenHands();
                break;
            }
            case CloseHands: {
                this.executeCloseHands();
                break;
            }
            case Test: {
                this.executeTest();
                break;
            }
            case Repaint: {
                this.executeRepaint();
                break;
            }
            case AdvancePhase: {
                this.executeAdvancePhase();
            }
        }
    }

    protected void initTest() {
        this.getState().testing = true;
        this.counter = 60;
    }

    protected void initRepaint() {
        this.counter = 2;
    }

    protected void initAdvancePhase() {
        this.executingCommand = null;
    }

    protected void executeTest() {
        if (--this.counter == 0) {
            this.getState().testing = false;
            this.executingCommand = null;
        }
    }

    protected void executeRepaint() {
        if (--this.counter == 0) {
            this.executingCommand = null;
        }
    }

    protected void executeAdvancePhase() {
    }

    protected abstract void initMoveUp();

    protected abstract void initMoveDown();

    protected abstract void initMoveLeft();

    protected abstract void initMoveRight();

    protected abstract void initOpenHands();

    protected abstract void initCloseHands();

    protected abstract void executeMoveUp();

    protected abstract void executeMoveDown();

    protected abstract void executeMoveLeft();

    protected abstract void executeMoveRight();

    protected abstract void executeOpenHands();

    protected abstract void executeCloseHands();
}

