/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.sound;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import nintaco.apu.SystemAudioProcessor;
import nintaco.gui.sound.SoundPrefs;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class SoundOptionsDialog
extends JDialog {
    private JButton cancelButton;
    private JComboBox<String> deviceComboBox;
    private JLabel deviceLabel;
    private JLabel latencyLabel;
    private JSpinner latencySpinner;
    private JButton okButton;

    public SoundOptionsDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.okButton.requestFocus();
    }

    private void loadFields() {
        this.setSoundPrefs(AppPrefs.getInstance().getSoundPrefs());
    }

    private void setSoundPrefs(SoundPrefs prefs) {
        String[] audioDevices = SystemAudioProcessor.getAudioDevices();
        this.deviceComboBox.setModel(new DefaultComboBoxModel<String>(audioDevices));
        int deviceIndex = 0;
        String audioDevice = prefs.getAudioDevice();
        if (StringUtil.isBlank(audioDevice) || (deviceIndex = StringUtil.findMatch(audioDevices, audioDevice)) < 0) {
            deviceIndex = SystemAudioProcessor.getDefaultAudioDevice(audioDevices);
        }
        this.deviceComboBox.setSelectedIndex(deviceIndex);
        this.latencySpinner.setValue(prefs.getLatencyMillis());
    }

    private void saveFields() {
        SoundPrefs prefs = AppPrefs.getInstance().getSoundPrefs();
        prefs.setAudioDevice((String)this.deviceComboBox.getSelectedItem());
        prefs.setLatencyMillis((Integer)this.latencySpinner.getValue());
        AppPrefs.save();
        SystemAudioProcessor.applySoundPrefs(prefs);
    }

    private void closeDialog() {
        this.dispose();
    }

    private void initComponents() {
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.deviceLabel = new JLabel();
        this.deviceComboBox = new JComboBox();
        this.latencyLabel = new JLabel();
        this.latencySpinner = new JSpinner();
        this.setDefaultCloseOperation(2);
        this.setTitle("Sound Options");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SoundOptionsDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.deviceLabel.setText("Device:");
        this.deviceLabel.setMaximumSize(null);
        this.deviceLabel.setMinimumSize(null);
        this.deviceLabel.setPreferredSize(null);
        this.deviceComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None"}));
        this.deviceComboBox.setFocusable(false);
        this.deviceComboBox.setMaximumSize(null);
        this.deviceComboBox.setMinimumSize(null);
        this.deviceComboBox.setPreferredSize(null);
        this.latencyLabel.setText("Latency (ms):");
        this.latencySpinner.setModel(new SpinnerNumberModel(50, 20, 500, 1));
        this.latencySpinner.setFocusable(false);
        this.latencySpinner.setMaximumSize(null);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deviceLabel, -2, -1, -2).addComponent(this.latencyLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.latencySpinner, -2, -1, -2).addComponent(this.deviceComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addGap(10, 10, 10)))));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deviceLabel, -2, -1, -2).addComponent(this.deviceComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.latencyLabel).addComponent(this.latencySpinner, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addGap(15, 15, 15)));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveFields();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }
}

