/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.watchhistory;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.basic.BasicSliderUI;
import nintaco.App;
import nintaco.MachineRunner;
import nintaco.apu.SystemAudioProcessor;
import nintaco.gui.exportmedia.ExportMediaFileDialog;
import nintaco.gui.historyeditor.tasks.PlayMovieTask;
import nintaco.gui.historyeditor.tasks.RenderScreenTask;
import nintaco.gui.image.SubMonitorFrame;
import nintaco.gui.nsf.PauseIcon;
import nintaco.gui.nsf.PlayIcon;
import nintaco.gui.nsf.SwitchTrackIcon;
import nintaco.gui.watchhistory.PreviewPane;
import nintaco.gui.watchhistory.WatchHistoryFrame;
import nintaco.gui.watchhistory.WatchMovieTask;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.movie.Movie;
import nintaco.movie.MovieFrame;
import nintaco.task.Task;
import nintaco.task.TaskScheduler;
import nintaco.util.GuiUtil;
import nintaco.util.MathUtil;

public class WatchHistoryPanel
extends JPanel {
    private final WatchHistoryFrame parent;
    private TaskScheduler taskScheduler;
    private TaskScheduler hoverScheduler;
    private PreviewPane previewPane;
    private PopupFactory popupFactory;
    private Task playMovieTask;
    private PlayMovieTask hoverMovieTask;
    private Movie movie;
    private Popup previewPopup;
    private int previewPopupX;
    private int previewPopupY;
    private int endPlayIndex;
    private boolean running;
    private boolean mouseEntered;
    private boolean playingMovie;
    private boolean wasPlayingWhenPressed;
    private JSpinner currentFrameSpinner;
    private JButton currentSeekButton;
    private JButton endCaptureButton;
    private JLabel endFrameLabel;
    private JSpinner endFrameSpinner;
    private JButton endSeekButton;
    private JButton exportButton;
    private JSlider historySlider;
    private JButton nextFrameButton;
    private JToggleButton playButton;
    private JButton previewButton;
    private JButton previousFrameButton;
    private JButton resumeButton;
    private JButton resumeHereButton;
    private JPanel savePanel;
    private JPanel sliderPanel;
    private JButton startCaptureButton;
    private JLabel startFrameLabel;
    private JSpinner startFrameSpinner;
    private JButton startSeekButton;

    public WatchHistoryPanel(WatchHistoryFrame parent) {
        this.parent = parent;
        this.initComponents();
    }

    public Movie getMovie() {
        return this.movie;
    }

    public void setMovie(Movie movie) {
        if (EventQueue.isDispatchThread()) {
            MachineRunner machineRunner = App.getMachineRunner();
            if (machineRunner != null) {
                if (movie == null) {
                    movie = machineRunner.getMovie();
                }
                machineRunner.dispose();
                App.updateFrames(null);
                App.setMachineRunner(null);
            }
            if (movie != null) {
                if (this.movie == movie) {
                    return;
                }
                this.movie = movie;
                this.endPlayIndex = movie.frameCount - 1;
                this.historySlider.setMinimum(0);
                this.historySlider.setMaximum(this.endPlayIndex);
                this.historySlider.setValue(0);
                this.currentFrameSpinner.setModel(new SpinnerNumberModel(0, 0, this.endPlayIndex, 1));
                this.currentFrameSpinner.setEditor(new JSpinner.NumberEditor(this.currentFrameSpinner, "#"));
                this.startFrameSpinner.setModel(new SpinnerNumberModel(0, 0, this.endPlayIndex, 1));
                this.startFrameSpinner.setEditor(new JSpinner.NumberEditor(this.startFrameSpinner, "#"));
                this.endFrameSpinner.setModel(new SpinnerNumberModel(this.endPlayIndex, 0, this.endPlayIndex, 1));
                this.endFrameSpinner.setEditor(new JSpinner.NumberEditor(this.endFrameSpinner, "#"));
                ((JSpinner.DefaultEditor)this.currentFrameSpinner.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            WatchHistoryPanel.this.requestFocusInWindow();
                            EventQueue.invokeLater(() -> WatchHistoryPanel.this.seek(WatchHistoryPanel.this.currentFrameSpinner));
                        }
                    }
                });
                GuiUtil.addLoseFocusListener((Window)this.parent, this.startFrameSpinner);
                GuiUtil.addLoseFocusListener((Window)this.parent, this.endFrameSpinner);
                GuiUtil.addSpinnerEditListener(this.startFrameSpinner, this::updatePreviewAndSave);
                GuiUtil.addSpinnerEditListener(this.endFrameSpinner, this::updatePreviewAndSave);
            }
        } else {
            Movie m = movie;
            EventQueue.invokeLater(() -> this.setMovie(m));
        }
    }

    public void setShowSave(boolean showSave) {
        if (EventQueue.isDispatchThread()) {
            this.parent.setTitle(showSave ? "Export Video/Audio" : "Watch History");
            this.savePanel.setVisible(showSave);
            if (showSave) {
                this.playingMovie = false;
                if (this.playMovieTask != null) {
                    this.playMovieTask.cancel();
                }
            } else {
                this.playMovie(false, false);
            }
            this.updatePlayButton();
        } else {
            EventQueue.invokeLater(() -> this.setShowSave(showSave));
        }
    }

    public void init() {
        if (EventQueue.isDispatchThread()) {
            this.setPreferredSize(null);
            this.running = true;
            if (this.taskScheduler == null) {
                this.taskScheduler = new TaskScheduler();
            }
            if (this.hoverScheduler == null) {
                this.hoverScheduler = new TaskScheduler();
            }
            if (this.previewPane == null) {
                this.previewPane = new PreviewPane();
            }
            this.popupFactory = PopupFactory.getSharedInstance();
            this.setComponentsEnabled(true);
        } else {
            EventQueue.invokeLater(this::init);
        }
    }

    private void setComponentsEnabled(boolean enabled) {
        this.historySlider.setEnabled(enabled);
        this.playButton.setEnabled(enabled);
        this.nextFrameButton.setEnabled(enabled);
        this.previousFrameButton.setEnabled(enabled);
        this.resumeHereButton.setEnabled(enabled);
        this.resumeButton.setEnabled(enabled);
        this.startFrameSpinner.setEnabled(enabled);
        this.endFrameSpinner.setEnabled(enabled);
        this.startCaptureButton.setEnabled(enabled);
        this.endCaptureButton.setEnabled(enabled);
        this.startSeekButton.setEnabled(enabled);
        this.endSeekButton.setEnabled(enabled);
        this.updatePreviewAndSave();
        this.resumeButton.requestFocusInWindow();
    }

    private void updatePreviewAndSave() {
        Integer startFrameIndex = (Integer)this.startFrameSpinner.getValue();
        Integer endFrameIndex = (Integer)this.endFrameSpinner.getValue();
        boolean enabled = this.historySlider.isEnabled() && startFrameIndex != null && endFrameIndex != null && startFrameIndex <= endFrameIndex;
        this.previewButton.setEnabled(enabled);
        this.exportButton.setEnabled(enabled);
    }

    public void movieFramePlayed(Task task, int frameIndex, MachineRunner machineRunner) {
        if (EventQueue.isDispatchThread()) {
            this.historySlider.setValue(frameIndex);
            if (frameIndex >= this.endPlayIndex) {
                this.playingMovie = false;
                this.updatePlayButton();
            }
        } else if (!task.isCanceled()) {
            EventQueue.invokeLater(() -> this.movieFramePlayed(task, frameIndex, machineRunner));
        }
    }

    public void previewFramePlayed(Task task, int frameIndex, MachineRunner machineRunner) {
        if (EventQueue.isDispatchThread()) {
            this.hidePreviewPopup();
            if (this.mouseEntered && App.getImageFrame().isDisplayingImagePane()) {
                this.previewPane.drawRectangle();
                this.previewPopup = this.popupFactory.getPopup(this, this.previewPane, this.previewPopupX, this.previewPopupY);
                this.previewPopup.show();
            }
        } else if (!task.isCanceled()) {
            EventQueue.invokeLater(() -> this.previewFramePlayed(task, frameIndex, machineRunner));
        }
    }

    private void mouseMoved(MouseEvent e) {
        if (this.running) {
            this.mouseEntered = true;
            SliderUI sliderUI = this.historySlider.getUI();
            if (sliderUI instanceof BasicSliderUI) {
                Point p = new Point();
                SwingUtilities.convertPointToScreen(p, this);
                this.mouseHovered(((BasicSliderUI)sliderUI).valueForXPosition(e.getX()), e.getXOnScreen(), p.y);
            }
        }
    }

    private void mouseHovered(int frameIndex, int screenX, int screenY) {
        if (this.running) {
            PlayMovieTask hoverTask = this.hoverMovieTask;
            if (hoverTask != null) {
                hoverTask.cancel();
            }
            this.previewPopupX = screenX - 128;
            this.previewPopupY = screenY - 240;
            int index = frameIndex & 0xFFFFFFC0;
            this.hoverMovieTask = new PlayMovieTask(this.movie, index, index, false, this::previewFramePlayed);
            this.hoverMovieTask.setFrameRenderer(this.previewPane);
            this.hoverMovieTask.setRenderingEnabled(true);
            this.hoverScheduler.add(this.hoverMovieTask);
        }
    }

    public void pause() {
        if (this.running) {
            this.hidePreviewPopup();
            this.cancelPlayTask();
        }
    }

    private void cancelPlayTask() {
        this.cancelPlayTask(true);
    }

    private void cancelPlayTask(boolean updatePlayButton) {
        TaskScheduler scheduler;
        Task playTask = this.playMovieTask;
        if (playTask != null) {
            playTask.cancel();
        }
        if ((scheduler = this.taskScheduler) != null) {
            scheduler.waitForEmpty();
        }
        this.playingMovie = false;
        if (updatePlayButton) {
            this.updatePlayButton();
        }
        SystemAudioProcessor.flush();
    }

    private void playMovie(boolean playButtonPressed, boolean singleFrame) {
        if (this.running) {
            this.endPlayIndex = singleFrame || this.playingMovie ? this.historySlider.getValue() : this.historySlider.getMaximum();
            this.hidePreviewPopup();
            this.cancelPlayTask(false);
            EventQueue.invokeLater(() -> {
                if (playButtonPressed && this.historySlider.getValue() == this.historySlider.getMaximum()) {
                    this.historySlider.setValue(0);
                    this.endPlayIndex = this.historySlider.getMaximum();
                }
                this.playMovieTask = new WatchMovieTask(this.movie, this.historySlider.getValue(), this.endPlayIndex, this::movieFramePlayed);
                this.playingMovie = !singleFrame;
                this.updatePlayButton();
                this.taskScheduler.add(this.playMovieTask);
            });
        }
    }

    private void showFrame(int offset) {
        if (this.running) {
            this.cancelPlayTask();
            EventQueue.invokeLater(() -> {
                this.endPlayIndex = MathUtil.clamp(this.historySlider.getValue() + offset, 0, this.historySlider.getMaximum());
                this.playMovieTask = new RenderScreenTask(this.movie, this.endPlayIndex, (r, f) -> {
                    EventQueue.invokeLater(() -> this.historySlider.setValue(f.frameIndex));
                    RenderScreenTask.DEFAULT_RENDER_SCREEN_LISTENER.completedRendering(r, f);
                });
                this.taskScheduler.add(this.playMovieTask);
            });
        }
    }

    private void hidePreviewPopup() {
        if (this.previewPopup != null) {
            this.previewPopup.hide();
        }
        App.getImageFrame().getImagePane().repaint();
        SubMonitorFrame subMonitorFrame = App.getSubMonitorFrame();
        if (subMonitorFrame != null) {
            subMonitorFrame.getImagePane().repaint();
        }
    }

    private void resumeHere(int frameIndex, boolean clearHistory) {
        if (this.running) {
            this.cancelPlayTask();
            EventQueue.invokeLater(() -> {
                this.hidePreviewPopup();
                this.taskScheduler.cancelAll();
                this.hoverScheduler.cancelAll();
                this.setComponentsEnabled(false);
                this.running = false;
                this.endPlayIndex = frameIndex;
                RenderScreenTask task = new RenderScreenTask(this.movie, frameIndex, (r, f) -> this.resume(r, f, clearHistory));
                task.setDisposeEnabled(false);
                this.taskScheduler.add(task);
            });
        }
    }

    private void resume(MachineRunner machineRunner, MovieFrame movieFrame, boolean clearHistory) {
        SubMonitorFrame subMonitorFrame;
        this.taskScheduler.dispose();
        this.hoverScheduler.dispose();
        this.previewPane.dispose();
        this.taskScheduler = null;
        this.hoverScheduler = null;
        this.previewPane = null;
        this.popupFactory = null;
        boolean vsDualSystem = movieFrame.isVsDualSystem();
        if (clearHistory) {
            this.movie = new Movie(vsDualSystem);
        } else {
            this.movie.frameIndex = movieFrame.frameIndex + 1;
            this.movie.truncate();
        }
        machineRunner.setMovie(this.movie);
        this.movie = null;
        machineRunner.getPPU().setScreenRenderer(App.getImageFrame().getImagePane());
        if (vsDualSystem && (subMonitorFrame = App.getSubMonitorFrame()) != null) {
            ((MainCPU)machineRunner.getCPU()).getSubPPU().setScreenRenderer(subMonitorFrame.getImagePane());
        }
        machineRunner.getAPU().setAudioProcessor(App.getSystemAudioProcessor());
        App.setMachineRunner(machineRunner);
        App.updateFrames(machineRunner);
        new Thread(machineRunner).start();
        App.destroyWatchHistoryFrame();
    }

    public void close() {
        this.cancelPlayTask();
        EventQueue.invokeLater(() -> {
            this.hidePreviewPopup();
            this.running = false;
            if (this.taskScheduler != null) {
                this.taskScheduler.dispose();
            }
            if (this.hoverScheduler != null) {
                this.hoverScheduler.dispose();
            }
            if (this.previewPane != null) {
                this.previewPane.dispose();
            }
            this.setComponentsEnabled(false);
            this.taskScheduler = null;
            this.hoverScheduler = null;
            this.previewPane = null;
            this.popupFactory = null;
            App.destroyWatchHistoryFrame();
        });
    }

    private void seek(JSpinner spinner) {
        Integer value;
        if (this.running && (value = (Integer)spinner.getValue()) != null) {
            this.historySlider.setValue(value);
            this.playMovie(false, true);
        }
    }

    public void resume(boolean clearHistory) {
        this.resumeHere(this.historySlider.getMaximum(), clearHistory);
    }

    private void updatePlayButton() {
        this.playButton.setSelected(this.playingMovie);
        this.currentSeekButton.setEnabled(!this.playButton.isSelected());
    }

    private void initComponents() {
        this.historySlider = new JSlider();
        this.nextFrameButton = new JButton();
        this.previousFrameButton = new JButton();
        this.playButton = new JToggleButton();
        this.resumeHereButton = new JButton();
        this.resumeButton = new JButton();
        this.savePanel = new JPanel();
        this.startFrameLabel = new JLabel();
        this.startFrameSpinner = new JSpinner();
        this.startCaptureButton = new JButton();
        this.endFrameLabel = new JLabel();
        this.endFrameSpinner = new JSpinner();
        this.endCaptureButton = new JButton();
        this.exportButton = new JButton();
        this.startSeekButton = new JButton();
        this.endSeekButton = new JButton();
        this.previewButton = new JButton();
        this.sliderPanel = new JPanel();
        this.currentFrameSpinner = new JSpinner();
        this.currentSeekButton = new JButton();
        this.setMaximumSize(null);
        this.historySlider.setPaintTicks(true);
        this.historySlider.setFocusable(false);
        this.historySlider.setMaximumSize(null);
        this.historySlider.setMinimumSize(null);
        this.historySlider.setPreferredSize(null);
        this.historySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WatchHistoryPanel.this.historySliderStateChanged(evt);
            }
        });
        this.historySlider.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                WatchHistoryPanel.this.historySliderMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                WatchHistoryPanel.this.historySliderMouseMoved(evt);
            }
        });
        this.historySlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                WatchHistoryPanel.this.historySliderMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WatchHistoryPanel.this.historySliderMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                WatchHistoryPanel.this.historySliderMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                WatchHistoryPanel.this.historySliderMouseReleased(evt);
            }
        });
        this.nextFrameButton.setIcon(new SwitchTrackIcon(false));
        this.nextFrameButton.setText(" ");
        this.nextFrameButton.setFocusPainted(false);
        this.nextFrameButton.setFocusable(false);
        this.nextFrameButton.setHorizontalTextPosition(0);
        this.nextFrameButton.setIconTextGap(0);
        this.nextFrameButton.setMargin(new Insets(4, 4, 4, 4));
        this.nextFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.nextFrameButtonActionPerformed(evt);
            }
        });
        this.previousFrameButton.setIcon(new SwitchTrackIcon(true));
        this.previousFrameButton.setText(" ");
        this.previousFrameButton.setFocusPainted(false);
        this.previousFrameButton.setFocusable(false);
        this.previousFrameButton.setHorizontalTextPosition(0);
        this.previousFrameButton.setIconTextGap(0);
        this.previousFrameButton.setMargin(new Insets(4, 4, 4, 4));
        this.previousFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.previousFrameButtonActionPerformed(evt);
            }
        });
        this.playButton.setIcon(new PlayIcon());
        this.playButton.setSelected(true);
        this.playButton.setText(" ");
        this.playButton.setFocusPainted(false);
        this.playButton.setFocusable(false);
        this.playButton.setHorizontalTextPosition(0);
        this.playButton.setIconTextGap(0);
        this.playButton.setMargin(new Insets(6, 6, 6, 6));
        this.playButton.setRolloverIcon(new PlayIcon());
        this.playButton.setSelectedIcon(new PauseIcon());
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.playButtonActionPerformed(evt);
            }
        });
        this.resumeHereButton.setText("Resume Here");
        this.resumeHereButton.setFocusPainted(false);
        this.resumeHereButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.resumeHereButtonActionPerformed(evt);
            }
        });
        this.resumeButton.setText("Resume");
        this.resumeButton.setFocusPainted(false);
        this.resumeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.resumeButtonActionPerformed(evt);
            }
        });
        this.startFrameLabel.setText("Start Frame:");
        this.startFrameSpinner.setPreferredSize(null);
        this.startFrameSpinner.setRequestFocusEnabled(false);
        this.startCaptureButton.setText("Capture");
        this.startCaptureButton.setFocusPainted(false);
        this.startCaptureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.startCaptureButtonActionPerformed(evt);
            }
        });
        this.endFrameLabel.setText("End Frame:");
        this.endFrameSpinner.setPreferredSize(null);
        this.endFrameSpinner.setRequestFocusEnabled(false);
        this.endCaptureButton.setText("Capture");
        this.endCaptureButton.setFocusPainted(false);
        this.endCaptureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.endCaptureButtonActionPerformed(evt);
            }
        });
        this.exportButton.setText("Export...");
        this.exportButton.setFocusPainted(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.exportButtonActionPerformed(evt);
            }
        });
        this.startSeekButton.setText("Seek");
        this.startSeekButton.setFocusPainted(false);
        this.startSeekButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.startSeekButtonActionPerformed(evt);
            }
        });
        this.endSeekButton.setText("Seek");
        this.endSeekButton.setFocusPainted(false);
        this.endSeekButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.endSeekButtonActionPerformed(evt);
            }
        });
        this.previewButton.setText("Preview");
        this.previewButton.setFocusPainted(false);
        this.previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.previewButtonActionPerformed(evt);
            }
        });
        GroupLayout savePanelLayout = new GroupLayout(this.savePanel);
        this.savePanel.setLayout(savePanelLayout);
        savePanelLayout.setHorizontalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addContainerGap().addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startFrameLabel).addComponent(this.endFrameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startFrameSpinner, -1, -1, -2).addComponent(this.endFrameSpinner, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addComponent(this.startCaptureButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startSeekButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(savePanelLayout.createSequentialGroup().addComponent(this.endCaptureButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endSeekButton).addGap(0, 0, Short.MAX_VALUE).addComponent(this.previewButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportButton))).addContainerGap()));
        savePanelLayout.linkSize(0, this.exportButton, this.previewButton);
        savePanelLayout.setVerticalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(savePanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startFrameLabel).addComponent(this.startFrameSpinner, -2, -1, -2).addComponent(this.startCaptureButton).addComponent(this.startSeekButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endFrameLabel).addComponent(this.endFrameSpinner, -2, -1, -2).addComponent(this.endCaptureButton).addComponent(this.exportButton).addComponent(this.endSeekButton).addComponent(this.previewButton)).addGap(0, 0, 0)));
        this.sliderPanel.setPreferredSize(new Dimension(0, 5));
        GroupLayout sliderPanelLayout = new GroupLayout(this.sliderPanel);
        this.sliderPanel.setLayout(sliderPanelLayout);
        sliderPanelLayout.setHorizontalGroup(sliderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        sliderPanelLayout.setVerticalGroup(sliderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 5, Short.MAX_VALUE));
        this.currentFrameSpinner.setPreferredSize(null);
        this.currentFrameSpinner.setRequestFocusEnabled(false);
        this.currentSeekButton.setText("Seek");
        this.currentSeekButton.setFocusPainted(false);
        this.currentSeekButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchHistoryPanel.this.currentSeekButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.historySlider, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.previousFrameButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.playButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextFrameButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentFrameSpinner, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentSeekButton).addGap(0, 0, Short.MAX_VALUE).addComponent(this.resumeHereButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resumeButton))).addContainerGap()).addComponent(this.savePanel, -1, -1, Short.MAX_VALUE).addComponent(this.sliderPanel, -1, 494, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.historySlider, -2, -1, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextFrameButton).addComponent(this.previousFrameButton).addComponent(this.playButton).addComponent(this.resumeHereButton).addComponent(this.resumeButton).addComponent(this.currentFrameSpinner, -2, -1, -2).addComponent(this.currentSeekButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.savePanel, -2, -1, -2).addContainerGap()));
    }

    private void historySliderMouseMoved(MouseEvent evt) {
        this.mouseMoved(evt);
    }

    private void historySliderMouseExited(MouseEvent evt) {
        this.mouseEntered = false;
        PlayMovieTask hoverTask = this.hoverMovieTask;
        if (hoverTask != null) {
            hoverTask.cancel();
        }
        this.hidePreviewPopup();
    }

    private void historySliderMousePressed(MouseEvent evt) {
        if (this.running) {
            this.wasPlayingWhenPressed = this.playingMovie;
            this.mouseEntered = true;
            this.cancelPlayTask();
            EventQueue.invokeLater(() -> {
                SliderUI sliderUI = this.historySlider.getUI();
                if (sliderUI instanceof BasicSliderUI) {
                    this.historySlider.setValue(((BasicSliderUI)sliderUI).valueForXPosition(evt.getX()));
                }
            });
        }
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        if (this.playingMovie) {
            this.cancelPlayTask();
        } else {
            this.playMovie(true, false);
        }
        this.currentSeekButton.setEnabled(!this.playButton.isSelected());
    }

    private void historySliderMouseReleased(MouseEvent evt) {
        this.playMovie(false, !this.wasPlayingWhenPressed);
    }

    private void nextFrameButtonActionPerformed(ActionEvent evt) {
        this.showFrame(1);
    }

    private void previousFrameButtonActionPerformed(ActionEvent evt) {
        this.showFrame(-1);
    }

    private void historySliderMouseDragged(MouseEvent evt) {
        this.mouseMoved(evt);
    }

    private void resumeButtonActionPerformed(ActionEvent evt) {
        this.resume(false);
    }

    private void resumeHereButtonActionPerformed(ActionEvent evt) {
        this.resumeHere(this.historySlider.getValue(), false);
    }

    private void startCaptureButtonActionPerformed(ActionEvent evt) {
        this.startFrameSpinner.setValue(this.historySlider.getValue());
    }

    private void endCaptureButtonActionPerformed(ActionEvent evt) {
        this.endFrameSpinner.setValue(this.historySlider.getValue());
    }

    private void startSeekButtonActionPerformed(ActionEvent evt) {
        this.seek(this.startFrameSpinner);
    }

    private void endSeekButtonActionPerformed(ActionEvent evt) {
        this.seek(this.endFrameSpinner);
    }

    private void previewButtonActionPerformed(ActionEvent evt) {
        if (this.running) {
            Integer startFrameIndex = (Integer)this.startFrameSpinner.getValue();
            Integer endFrameIndex = (Integer)this.endFrameSpinner.getValue();
            if (startFrameIndex != null && endFrameIndex != null && startFrameIndex <= endFrameIndex) {
                this.hidePreviewPopup();
                this.cancelPlayTask();
                EventQueue.invokeLater(() -> {
                    this.playingMovie = true;
                    this.endPlayIndex = endFrameIndex;
                    this.playMovieTask = new WatchMovieTask(this.movie, startFrameIndex, endFrameIndex, (t, i, r) -> this.movieFramePlayed(t, i, r));
                    this.taskScheduler.add(this.playMovieTask);
                    this.updatePlayButton();
                });
            }
        }
    }

    private void historySliderStateChanged(ChangeEvent evt) {
        this.currentFrameSpinner.setValue(this.historySlider.getValue());
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        if (this.running) {
            Integer startFrameIndex = (Integer)this.startFrameSpinner.getValue();
            Integer endFrameIndex = (Integer)this.endFrameSpinner.getValue();
            if (startFrameIndex != null && endFrameIndex != null && startFrameIndex <= endFrameIndex) {
                this.hidePreviewPopup();
                this.cancelPlayTask();
                EventQueue.invokeLater(() -> new ExportMediaFileDialog(App.getImageFrame(), this.movie, startFrameIndex, endFrameIndex, this.previewPane.getImage(), this.previewPane.getScreen()).setVisible(true));
            }
        }
    }

    private void currentSeekButtonActionPerformed(ActionEvent evt) {
        this.seek(this.currentFrameSpinner);
    }

    private void historySliderMouseEntered(MouseEvent evt) {
        this.mouseEntered = true;
    }
}

