/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input;

import java.io.Serializable;
import nintaco.App;
import nintaco.Machine;
import nintaco.input.arkanoid.ArkanoidMapper;
import nintaco.input.bandaihypershot.BandaiHyperShotMapper;
import nintaco.input.barcodebattler.BarcodeBattlerMapper;
import nintaco.input.battlebox.BattleBoxMapper;
import nintaco.input.dongda.DongdaPEC586KeyboardMapper;
import nintaco.input.doremikkokeyboard.DoremikkoKeyboardMapper;
import nintaco.input.excitingboxing.ExcitingBoxingMapper;
import nintaco.input.familybasic.datarecorder.DataRecorderMapper;
import nintaco.input.familybasic.keyboard.KeyboardMapper;
import nintaco.input.familybasic.transformer.TransformerMapper;
import nintaco.input.familytrainermat.FamilyTrainerMatMapper;
import nintaco.input.gamepad.GamepadMapper;
import nintaco.input.glasses.GlassesMapper;
import nintaco.input.horitrack.HoriTrackMapper;
import nintaco.input.konamihypershot.KonamiHyperShotMapper;
import nintaco.input.mahjong.MahjongMapper;
import nintaco.input.miraclepiano.MiraclePianoMapper;
import nintaco.input.multitap.Famicom4PlayersAdapterMapper;
import nintaco.input.multitap.NESFourScoreMapper;
import nintaco.input.none.NoneMapper;
import nintaco.input.oekakids.OekaKidsMapper;
import nintaco.input.pachinko.PachinkoMapper;
import nintaco.input.partytap.PartyTapMapper;
import nintaco.input.powerglove.PowerGloveMapper;
import nintaco.input.powerpad.PowerPadMapper;
import nintaco.input.racermate.RacerMateMapper;
import nintaco.input.snesmouse.SnesMouseMapper;
import nintaco.input.subor.SuborMapper;
import nintaco.input.taptapmat.TapTapMatMapper;
import nintaco.input.topriderbike.TopRiderBikeMapper;
import nintaco.input.turbofile.TurboFileMapper;
import nintaco.input.uforce.UForceMapper;
import nintaco.input.zapper.VsZapperMapper;
import nintaco.input.zapper.ZapperMapper;

public abstract class DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;

    public abstract int getInputDevice();

    public abstract void update(int var1);

    public abstract void writePort(int var1);

    public abstract int readPort(int var1);

    public abstract int peekPort(int var1);

    public void setMachine(Machine machine) {
    }

    public void render(int[] screen) {
    }

    public void close(boolean saveNonVolatileData) {
    }

    static DeviceMapper createDeviceMapper(int port, int inputDevice) {
        switch (inputDevice) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                return new GamepadMapper(port);
            }
            case 4: {
                if (App.isVsUniSystem()) {
                    return new VsZapperMapper(port);
                }
                return new ZapperMapper(port);
            }
            case 5: {
                return new ArkanoidMapper(port);
            }
            case 6: {
                return new BandaiHyperShotMapper();
            }
            case 7: {
                return new BarcodeBattlerMapper();
            }
            case 8: {
                return new BattleBoxMapper();
            }
            case 11: {
                return new DataRecorderMapper();
            }
            case 12: {
                return new DongdaPEC586KeyboardMapper();
            }
            case 13: {
                return new DoremikkoKeyboardMapper();
            }
            case 14: {
                return new ExcitingBoxingMapper();
            }
            case 15: {
                return new FamilyTrainerMatMapper();
            }
            case 16: {
                return new GlassesMapper();
            }
            case 18: {
                return new KeyboardMapper();
            }
            case 19: {
                return new KonamiHyperShotMapper();
            }
            case 17: {
                return new HoriTrackMapper();
            }
            case 20: {
                return new MahjongMapper();
            }
            case 21: {
                return new MiraclePianoMapper();
            }
            case 22: {
                return new OekaKidsMapper();
            }
            case 23: {
                return new PachinkoMapper();
            }
            case 24: {
                return new PartyTapMapper();
            }
            case 25: {
                return new PowerGloveMapper(port);
            }
            case 26: {
                return new PowerPadMapper(port);
            }
            case 27: 
            case 28: {
                return new RacerMateMapper(port);
            }
            case 29: {
                return new SnesMouseMapper(port);
            }
            case 30: {
                return new SuborMapper();
            }
            case 31: {
                return new TapTapMatMapper();
            }
            case 32: {
                return new TopRiderBikeMapper();
            }
            case 33: {
                return new TransformerMapper();
            }
            case 34: {
                return new TurboFileMapper();
            }
            case 35: {
                return new UForceMapper();
            }
            case -3: 
            case -2: {
                return new NESFourScoreMapper(port);
            }
            case -5: 
            case -4: {
                return new Famicom4PlayersAdapterMapper(port);
            }
        }
        return new NoneMapper();
    }
}

