/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input;

import java.io.Serializable;
import nintaco.input.ButtonID;
import nintaco.input.ButtonMapping;

public class HoldDownOrToggleButtonMapping
extends ButtonMapping
implements Serializable {
    private static final long serialVersionUID = 0L;
    private boolean holdDown;

    public HoldDownOrToggleButtonMapping(HoldDownOrToggleButtonMapping buttonMapping) {
        this(buttonMapping.getInputDevice(), buttonMapping.getButtonIndex(), buttonMapping.getButtonIds(), buttonMapping.isHoldDown());
    }

    public HoldDownOrToggleButtonMapping(int inputDevice, int buttonIndex) {
        this(inputDevice, buttonIndex, new ButtonID[]{new ButtonID()}, false);
    }

    public HoldDownOrToggleButtonMapping(int inputDevice, int buttonIndex, ButtonID[] buttonIds, boolean holdDown) {
        super(inputDevice, buttonIndex, buttonIds);
        this.holdDown = holdDown;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = super.getDescription();
            if (!"...".equals(this.description)) {
                this.description = String.format("%s (%s)", this.description, this.holdDown ? "hold" : "toggle");
            }
        }
        return this.description;
    }

    @Override
    public ButtonMapping copy() {
        return new HoldDownOrToggleButtonMapping(this);
    }

    public boolean isHoldDown() {
        return this.holdDown;
    }

    public void setHoldDown(boolean holdDown) {
        this.holdDown = holdDown;
    }
}

