/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import nintaco.App;
import nintaco.AppMode;
import nintaco.Machine;
import nintaco.files.FileUtil;
import nintaco.gui.Int;
import nintaco.gui.image.CursorType;
import nintaco.gui.netplay.server.NetplayServerFrame;
import nintaco.gui.rob.RobController;
import nintaco.input.ButtonID;
import nintaco.input.ButtonMapping;
import nintaco.input.ControllerButton;
import nintaco.input.ControllerQueue;
import nintaco.input.DeviceConfig;
import nintaco.input.DeviceDescriptor;
import nintaco.input.DeviceMapper;
import nintaco.input.InputDeviceID;
import nintaco.input.InputDevices;
import nintaco.input.Inputs;
import nintaco.input.OtherInput;
import nintaco.input.Ports;
import nintaco.input.familybasic.keyboard.KeyboardPaster;
import nintaco.input.gamepad.GamepadMapper;
import nintaco.input.multitap.Famicom4PlayersAdapterMapper;
import nintaco.input.multitap.NESFourScoreMapper;
import nintaco.mappers.nintendo.vs.VsGame;
import nintaco.preferences.AppPrefs;
import nintaco.util.CollectionsUtil;

public final class InputUtil {
    private static final int POV_UP_LEFT = 1;
    private static final int POV_UP = 2;
    private static final int POV_UP_RIGHT = 3;
    private static final int POV_RIGHT = 4;
    private static final int POV_DOWN_RIGHT = 5;
    private static final int POV_DOWN = 6;
    private static final int POV_DOWN_LEFT = 7;
    private static final int POV_LEFT = 8;
    private static final int MAX_EVENTS = 8192;
    private static final Event event = new Event();
    private static final ControllerButton controllerButton = new ControllerButton();
    private static final Map<ControllerButton, Int> pressedButtons = new HashMap<ControllerButton, Int>();
    private static final int[] pressedValues = new int[256];
    private static final Map<InputDeviceID, ControllerQueue> controllerQueuesMap = new HashMap<InputDeviceID, ControllerQueue>();
    private static InputDeviceID defaultKeyboard;
    private static InputDeviceID defaultMouse;
    private static ControllerQueue[] controllerQueues;
    private static int presses;
    private static ControllerButton[][][] buttonCombos;
    private static volatile boolean inputDisabled;
    private static volatile boolean rewindTimeDisabled;
    private static volatile RobController rob;
    private static volatile Ports ports;
    private static volatile DeviceDescriptor[] devices;
    private static volatile DeviceMapper[] deviceMappers;
    private static volatile int consoleType;
    private static volatile int[] portIndices;
    private static volatile int[][] portDeviceOverrides;
    private static volatile boolean multitapOverride;
    private static volatile int consoleOverride;
    private static volatile int mouseCoordinates;
    private static volatile int buttons;
    private static volatile int vsProtectionMask;
    private static volatile boolean vsSystem;
    private static volatile boolean swapControllers;
    private static volatile boolean zapperGame;
    private static volatile float mouseDeltaX;
    private static volatile float mouseDeltaY;
    private static volatile int mouseDeltaWheel;
    private static volatile String barcode;
    private static volatile boolean rewindTimeDisabledByKeyboard;
    private static volatile KeyboardPaster familyBasicTypePaster;
    private static volatile OtherInput[] otherInputs;

    private InputUtil() {
    }

    public static void init() {
        System.setProperty("net.java.games.input.librarypath", FileUtil.getWorkingDirectory("lib", "native"));
        String osName = System.getProperty("os.name");
        if (osName != null && osName.trim().toLowerCase().startsWith("win")) {
            System.setProperty("jinput.useDefaultPlugin", "false");
            System.setProperty("net.java.games.input.useDefaultPlugin", "false");
            System.setProperty("jinput.plugins", "");
            System.setProperty("net.java.games.input.plugins", "net.java.games.input.DirectInputEnvironmentPlugin");
        }
        InputUtil.handleSettingsChange();
    }

    private static String createID(Controller controller) {
        return String.format("%s %s %d", controller.getType(), controller.getName(), controller.getComponents().length);
    }

    private static String createDescription(Controller controller, int index) {
        Controller.Type type = controller.getType();
        if (type == Controller.Type.STICK || type == Controller.Type.GAMEPAD) {
            return String.format("Joy %d", index);
        }
        if (type == Controller.Type.MOUSE) {
            return "Mouse";
        }
        return "";
    }

    private static boolean isValidController(Controller controller) {
        Controller.Type type = controller.getType();
        return type == Controller.Type.STICK || type == Controller.Type.GAMEPAD || type == Controller.Type.KEYBOARD || type == Controller.Type.MOUSE;
    }

    public static InputDeviceID getDefaultKeyboard() {
        return defaultKeyboard;
    }

    public static InputDeviceID getDefaultMouse() {
        return defaultMouse;
    }

    public static float getMouseDeltaX() {
        float value = mouseDeltaX;
        mouseDeltaX = 0.0f;
        return inputDisabled ? 0.0f : value;
    }

    public static float getMouseDeltaY() {
        float value = mouseDeltaY;
        mouseDeltaY = 0.0f;
        return inputDisabled ? 0.0f : value;
    }

    public static int getMouseDeltaWheel() {
        if (mouseDeltaWheel > 0) {
            --mouseDeltaWheel;
            return inputDisabled ? 0 : 1;
        }
        if (mouseDeltaWheel < 0) {
            ++mouseDeltaWheel;
            return inputDisabled ? 0 : -1;
        }
        return 0;
    }

    public static String getBarcode() {
        String value = barcode;
        barcode = null;
        return value;
    }

    public static void setBarcode(String barcode) {
        InputUtil.barcode = barcode;
    }

    private static void addControllerButtons(ControllerQueue controllerQueue, String buttonName) {
        pressedButtons.put(new ControllerButton(controllerQueue, -1, buttonName), new Int());
        pressedButtons.put(new ControllerButton(controllerQueue, 1, buttonName), new Int());
    }

    private static void addControllerButtons(ControllerQueue controllerQueue, Controller controller) {
        for (Component component : controller.getComponents()) {
            InputUtil.addControllerButtons(controllerQueue, component.getIdentifier().getName());
        }
    }

    public static void initControllers() {
        defaultKeyboard = null;
        defaultMouse = null;
        pressedButtons.clear();
        controllerQueuesMap.clear();
        HashMap deviceMap = new HashMap();
        Controller[] cs = ControllerEnvironment.getDefaultEnvironment().getControllers();
        ArrayList<ControllerQueue> qs = new ArrayList<ControllerQueue>();
        for (int i = cs.length - 1; i >= 0; --i) {
            Controller controller = cs[i];
            if (!InputUtil.isValidController(controller)) continue;
            String id = InputUtil.createID(controller);
            ArrayList<InputDeviceID> inputDeviceIds = (ArrayList<InputDeviceID>)deviceMap.get(id);
            if (inputDeviceIds == null) {
                inputDeviceIds = new ArrayList<InputDeviceID>();
                deviceMap.put(id, inputDeviceIds);
            }
            int index = inputDeviceIds.size();
            InputDeviceID inputDeviceID = new InputDeviceID(index, id, InputUtil.createDescription(controller, index));
            inputDeviceIds.add(inputDeviceID);
            if (defaultKeyboard == null && controller.getType() == Controller.Type.KEYBOARD) {
                defaultKeyboard = inputDeviceID;
            }
            if (defaultMouse == null && controller.getType() == Controller.Type.MOUSE) {
                defaultMouse = inputDeviceID;
            }
            ControllerQueue controllerQueue = new ControllerQueue(i, controller, controller.getEventQueue(), inputDeviceID);
            controllerQueuesMap.put(inputDeviceID, controllerQueue);
            qs.add(controllerQueue);
            InputUtil.addControllerButtons(controllerQueue, controller);
        }
        controllerQueues = new ControllerQueue[qs.size()];
        qs.toArray(controllerQueues);
        InputUtil.clearEventQueues();
    }

    public static boolean isInputDisabled() {
        return inputDisabled;
    }

    public static void setInputDisabled(boolean inputDisabled) {
        InputUtil.inputDisabled = inputDisabled;
    }

    public static void setRewindTimeDisabled(boolean rewindTimeDisabled) {
        InputUtil.rewindTimeDisabled = rewindTimeDisabled;
    }

    public static void setVsGame(VsGame vsGame) {
        if (vsGame == null) {
            vsSystem = false;
            swapControllers = false;
            zapperGame = false;
            vsProtectionMask = 0;
        } else {
            vsSystem = true;
            swapControllers = vsGame.isSwapControllers();
            zapperGame = vsGame.isZapperGame();
            vsProtectionMask = vsGame.isProtected() ? 0x8080808 : 0;
        }
    }

    public static void setMouseCoordinates(int mouseCoordinates) {
        InputUtil.mouseCoordinates = mouseCoordinates & 0xFFFF;
    }

    public static int getMouseCoordinates() {
        return inputDisabled ? 65535 : mouseCoordinates;
    }

    public static void clearEventQueues() {
        mouseDeltaWheel = 0;
        mouseDeltaX = mouseDeltaY = (float)0;
        if (controllerQueues == null) {
            return;
        }
        for (int i = controllerQueues.length - 1; i >= 0; --i) {
            ControllerQueue controllerQueue = controllerQueues[i];
            if (controllerQueue == null) continue;
            Controller controller = controllerQueue.controller;
            if (controller.poll()) {
                net.java.games.input.EventQueue queue = controllerQueue.getEventQueue();
                while (queue.getNextEvent(event)) {
                }
                continue;
            }
            InputUtil.controllerQueues[i] = null;
        }
    }

    private static Ports adjustNetplayServerPorts(Ports ports) {
        int[][] portDevices;
        block5: {
            portDevices = ports.getPortDevices();
            if (portDevices.length == 2 || portDevices.length == 4) {
                for (int i = portDevices.length - 1; i >= 0; --i) {
                    if (InputDevices.isGamepad(portDevices[i][1])) {
                        continue;
                    }
                    break block5;
                }
                return ports;
            }
        }
        ArrayList<Integer> gamepads = new ArrayList<Integer>();
        gamepads.add(0);
        gamepads.add(1);
        gamepads.add(2);
        gamepads.add(3);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int[] entry : portDevices) {
            int portIndex = entry[0];
            int inputDevice = entry[1];
            gamepads.remove(new Integer(inputDevice));
            if (portIndex == 4) continue;
            map.put(portIndex, inputDevice);
        }
        int[][] devices = new int[ports.isMultitap() ? 4 : 2][2];
        for (int i = 0; i < devices.length; ++i) {
            devices[i][0] = i;
            Integer inputDevice = (Integer)map.get(i);
            devices[i][1] = inputDevice == null || !InputDevices.isGamepad(inputDevice) ? ((Integer)gamepads.remove(0)).intValue() : inputDevice.intValue();
        }
        return new Ports(devices, ports.isMultitap(), ports.getConsoleType());
    }

    public static synchronized void handleSettingsChange() {
        InputUtil.handleSettingsChange(null);
    }

    private static void handleSettingsChange(Ports ports) {
        NetplayServerFrame serverFrame;
        InputUtil.initControllers();
        Inputs inputs = AppPrefs.getInstance().getInputs();
        if (ports == null) {
            ports = inputs.getPorts();
        }
        if ((serverFrame = App.getNetworkServerFrame()) != null) {
            EventQueue.invokeLater(serverFrame::enableComponents);
        }
        if (App.getAppMode() == AppMode.NetplayServer) {
            ports = InputUtil.adjustNetplayServerPorts(ports);
        }
        int[][] portDevices = portDeviceOverrides != null ? portDeviceOverrides : ports.getPortDevices();
        ControllerButton[][][] combos = new ControllerButton[portDevices.length][][];
        List<DeviceConfig> deviceConfigs = inputs.getDeviceConfigs();
        DeviceDescriptor[] deviceDescriptors = new DeviceDescriptor[portDevices.length];
        int[] portNumbers = new int[portDevices.length];
        DeviceMapper[] mappers = new DeviceMapper[portDevices.length];
        boolean usesZapper = Ports.hasDevice(portDevices, 4) || Ports.hasDevice(portDevices, 6);
        boolean usesMouse = Ports.hasDevice(portDevices, 17) || Ports.hasDevice(portDevices, 29) || Ports.hasDevice(portDevices, 30) || Ports.hasDevice(portDevices, 35);
        int i = 0;
        for (int[] entry : portDevices) {
            int portIndex = entry[0];
            int inputDevice = entry[1];
            if (inputDevice >= 0) {
                List<ButtonMapping> mapping;
                if (usesZapper && App.isVsUniSystem()) {
                    portIndex ^= 1;
                }
                if ((mapping = deviceConfigs.get(inputDevice).getButtonMappings()) != null) {
                    combos[i] = new ControllerButton[mapping.size()][];
                    for (int j = mapping.size() - 1; j >= 0; --j) {
                        combos[i][j] = InputUtil.createButtonsCombo(mapping.get(j));
                    }
                } else {
                    combos[i] = new ControllerButton[0][0];
                }
            } else {
                combos[i] = new ControllerButton[0][0];
            }
            portNumbers[i] = portIndex;
            mappers[i] = DeviceMapper.createDeviceMapper(portIndex, inputDevice);
            deviceDescriptors[i] = DeviceDescriptor.getDescriptor(inputDevice);
            ++i;
        }
        if (consoleOverride >= 0) {
            mappers = InputUtil.createDeviceMappers(multitapOverride, consoleOverride);
        } else if (ports.isMultitap()) {
            mappers = InputUtil.createDeviceMappers(true, ports.getConsoleType());
        }
        familyBasicTypePaster = null;
        consoleType = ports.getConsoleType();
        portIndices = portNumbers;
        devices = deviceDescriptors;
        buttonCombos = combos;
        deviceMappers = mappers;
        InputUtil.ports = new Ports(portDevices, ports.isMultitap(), consoleType);
        if (usesZapper) {
            InputUtil.setImagePaneMouseCursor(inputs.isShowZapperCrosshairs() ? CursorType.Crosshairs : CursorType.Default);
        } else if (usesMouse) {
            InputUtil.setImagePaneMouseCursor(inputs.isHideMouseCursor() ? CursorType.Blank : CursorType.Default);
        } else {
            InputUtil.setImagePaneMouseCursor(CursorType.Default);
        }
        boolean keyboard = Ports.hasDevice(portDevices, 18) || Ports.hasDevice(portDevices, 33) || Ports.hasDevice(portDevices, 13) || Ports.hasDevice(portDevices, 30) || Ports.hasDevice(portDevices, 12);
        App.getImageFrame().setKeyEventsEnabled(!keyboard);
        rewindTimeDisabledByKeyboard = keyboard && inputs.isDisableKeyboardRewindTime();
        for (int i2 = 35; i2 >= 0; --i2) {
            DeviceDescriptor.getDescriptor(i2).handleSettingsChange(inputs);
        }
        if (Ports.hasDevice(portDevices, 7)) {
            App.createBarcodeBattlerFrame();
        } else if (Ports.hasDevice(portDevices, 16)) {
            App.createGlassesFrame();
        }
    }

    private static DeviceMapper[] createDeviceMappers(boolean multitap, int console) {
        DeviceMapper[] mappers = multitap ? (console == 0 ? new DeviceMapper[]{new NESFourScoreMapper(0), new NESFourScoreMapper(1)} : new DeviceMapper[]{new Famicom4PlayersAdapterMapper(0), new Famicom4PlayersAdapterMapper(1)}) : (console == 2 ? new DeviceMapper[]{new GamepadMapper(0), new GamepadMapper(1), new GamepadMapper(2), new GamepadMapper(3)} : new DeviceMapper[]{new GamepadMapper(0), new GamepadMapper(1)});
        return mappers;
    }

    private static void setImagePaneMouseCursor(CursorType cursorType) {
        App.getImageFrame().getImagePane().setCursorType(cursorType);
    }

    private static ControllerButton[] createButtonsCombo(ButtonMapping buttonMapping) {
        ButtonID[] buttonIds = buttonMapping.getButtonIds();
        ArrayList<ControllerButton> controllerButtons = new ArrayList<ControllerButton>();
        for (int i = buttonIds.length - 1; i >= 0; --i) {
            ButtonID buttonID = buttonIds[i];
            ControllerQueue controllerQueue = controllerQueuesMap.get(buttonID.getDevice());
            if (controllerQueue == null) continue;
            controllerButtons.add(new ControllerButton(controllerQueue, buttonID.getValue(), buttonID.getName()));
        }
        ControllerButton[] combo = new ControllerButton[controllerButtons.size()];
        controllerButtons.toArray(combo);
        return combo;
    }

    private static void updatePressedButtons() {
        if (controllerQueues == null) {
            return;
        }
        for (int i = controllerQueues.length - 1; i >= 0; --i) {
            ControllerQueue controllerQueue = controllerQueues[i];
            if (controllerQueue == null) continue;
            Controller controller = controllerQueue.controller;
            if (controller.poll()) {
                boolean mouse = controller.getType() == Controller.Type.MOUSE;
                net.java.games.input.EventQueue queue = controllerQueue.eventQueue;
                for (int j = 0; j < 8192 && queue.getNextEvent(event); ++j) {
                    Component.Identifier id = event.getComponent().getIdentifier();
                    if (mouse) {
                        if (id == Component.Identifier.Axis.X) {
                            mouseDeltaX += event.getValue();
                            continue;
                        }
                        if (id == Component.Identifier.Axis.Y) {
                            mouseDeltaY += event.getValue();
                            continue;
                        }
                        if (id == Component.Identifier.Axis.Z) {
                            float value = event.getValue();
                            if (value > 0.0f) {
                                ++mouseDeltaWheel;
                                continue;
                            }
                            if (!(value < 0.0f)) continue;
                            --mouseDeltaWheel;
                            continue;
                        }
                        InputUtil.handleButton(controllerQueue, InputUtil.getButtonValue(), id.getName());
                        continue;
                    }
                    if (id == Component.Identifier.Axis.POV) {
                        switch ((int)(8.0f * (event.getValue() - event.getComponent().getDeadZone()))) {
                            case 1: {
                                InputUtil.handleButton(controllerQueue, -1, "y");
                                InputUtil.handleButton(controllerQueue, -1, "x");
                                break;
                            }
                            case 2: {
                                InputUtil.handleButton(controllerQueue, -1, "y");
                                InputUtil.handleButton(controllerQueue, 0, "x");
                                break;
                            }
                            case 3: {
                                InputUtil.handleButton(controllerQueue, -1, "y");
                                InputUtil.handleButton(controllerQueue, 1, "x");
                                break;
                            }
                            case 4: {
                                InputUtil.handleButton(controllerQueue, 0, "y");
                                InputUtil.handleButton(controllerQueue, 1, "x");
                                break;
                            }
                            case 5: {
                                InputUtil.handleButton(controllerQueue, 1, "y");
                                InputUtil.handleButton(controllerQueue, 1, "x");
                                break;
                            }
                            case 6: {
                                InputUtil.handleButton(controllerQueue, 1, "y");
                                InputUtil.handleButton(controllerQueue, 0, "x");
                                break;
                            }
                            case 7: {
                                InputUtil.handleButton(controllerQueue, 1, "y");
                                InputUtil.handleButton(controllerQueue, -1, "x");
                                break;
                            }
                            case 8: {
                                InputUtil.handleButton(controllerQueue, 0, "y");
                                InputUtil.handleButton(controllerQueue, -1, "x");
                                break;
                            }
                            default: {
                                InputUtil.handleButton(controllerQueue, 0, "y");
                                InputUtil.handleButton(controllerQueue, 0, "x");
                                break;
                            }
                        }
                        continue;
                    }
                    InputUtil.handleButton(controllerQueue, InputUtil.getButtonValue(), id.getName());
                }
                continue;
            }
            InputUtil.controllerQueues[i] = null;
        }
    }

    private static void setPressed(ControllerQueue controllerQueue, int value, String name, int pressedValue) {
        Int b = pressedButtons.get(controllerButton.setAll(controllerQueue, value, name));
        if (b != null) {
            b.setValue(pressedValue);
        }
    }

    private static void handleButton(ControllerQueue controllerQueue, int value, String name) {
        if (value == 0) {
            InputUtil.setPressed(controllerQueue, -1, name, 0);
            InputUtil.setPressed(controllerQueue, 1, name, 0);
        } else {
            if (++presses == 0) {
                presses = 1;
            }
            InputUtil.setPressed(controllerQueue, value, name, presses);
        }
    }

    private static void updateButtons(boolean play, Machine machine) {
        int bits = 0;
        for (int i = buttonCombos.length - 1; i >= 0; --i) {
            ControllerButton[][] combos = buttonCombos[i];
            block1: for (int j = combos.length - 1; j >= 0; --j) {
                InputUtil.pressedValues[j] = 0;
                if (inputDisabled) continue;
                ControllerButton[] combo = combos[j];
                int maxValue = Integer.MIN_VALUE;
                if (combo == null || combo.length <= 0) continue;
                for (int k = combo.length - 1; k >= 0; --k) {
                    Int b = pressedButtons.get(combo[k]);
                    if (b == null || b.value == 0) continue block1;
                    if (b.value <= maxValue) continue;
                    maxValue = b.value;
                }
                InputUtil.pressedValues[j] = maxValue;
            }
            KeyboardPaster typePaster = familyBasicTypePaster;
            if (typePaster != null && devices[i] == DeviceDescriptor.Keyboard) {
                bits = typePaster.type(bits, consoleType, pressedValues);
                if (!typePaster.isFinished()) continue;
                familyBasicTypePaster = null;
                continue;
            }
            bits = devices[i].setButtonBits(bits, consoleType, portIndices[i], pressedValues);
        }
        RobController r = rob;
        if (r != null && machine != null) {
            r.scanMemory(machine.getMapper());
            if (r.update() && play) {
                App.updateRobFrame(r);
            }
            bits = r.pollButtons(bits, machine.getMapper());
        }
        if (vsSystem) {
            if (zapperGame) {
                bits = 0xFFFFF3FF & bits | (0x400 & bits) << 1 | (0x800 & bits) >> 1;
                buttons = swapControllers ? 0xFFFF0C0C & bits | (0xF3 & bits) << 8 | (0xF300 & bits) >> 8 : bits;
            } else {
                bits = 0xF3F3F3F3 & bits | (0x4040404 & bits) << 1 | (0x8080808 & bits) >> 1 | vsProtectionMask;
                buttons = swapControllers ? 0xC0C0C0C & bits | (0xF300F3 & bits) << 8 | (0xF300F300 & bits) >> 8 : bits;
            }
        } else {
            buttons = bits;
        }
        if (rewindTimeDisabled || rewindTimeDisabledByKeyboard) {
            App.clearRewindTime();
            App.clearHighSpeed();
        } else {
            App.updateRewindTime();
            App.updateHighSpeed();
        }
    }

    public static void familyBasicTypePaste(String str, int shortDelay, int longDelay) {
        familyBasicTypePaster = new KeyboardPaster(str, shortDelay, longDelay);
    }

    public static void setMachine(Machine machine) {
        Ports ports = machine.getMapper().getPorts();
        if (!InputUtil.ports.equals(ports)) {
            InputUtil.handleSettingsChange(ports);
            AppPrefs.getInstance().getInputs().setPorts(ports);
            AppPrefs.save();
        }
        InputUtil.setRob(machine.getPPU().getRob());
    }

    public static void setRob(RobController rob) {
        InputUtil.rob = rob;
    }

    public static RobController getRob() {
        return rob;
    }

    public static void rewindPollControls(Machine machine) {
        if (machine != null) {
            rob = machine.getPPU().getRob();
        }
        InputUtil.updatePressedButtons();
        InputUtil.updateButtons(false, machine);
    }

    public static void pollControllers(Machine machine) {
        if (machine != null) {
            machine.getPPU().setZapper(null);
            machine.getPPU().setRob(rob);
            DeviceMapper[] mappers = deviceMappers;
            for (int i = mappers.length - 1; i >= 0; --i) {
                mappers[i].setMachine(machine);
            }
            machine.getMapper().setDeviceMappers(mappers);
            machine.getMapper().setPorts(ports);
        }
        InputUtil.updatePressedButtons();
        InputUtil.updateButtons(true, machine);
    }

    public static void pollControllers(List<ButtonID> buttonIds) {
        if (controllerQueues == null) {
            return;
        }
        buttonIds.clear();
        for (int i = controllerQueues.length - 1; i >= 0; --i) {
            ControllerQueue controllerQueue = controllerQueues[i];
            if (controllerQueue == null) continue;
            Controller controller = controllerQueue.controller;
            if (controller.poll()) {
                net.java.games.input.EventQueue queue = controllerQueue.eventQueue;
                long lastNanos = -1L;
                ButtonID buttonID = null;
                while (queue.getNextEvent(event)) {
                    int buttonValue;
                    String buttonName;
                    Component component = event.getComponent();
                    if (InputUtil.isMouseAxis(controller, component)) continue;
                    if (component.getIdentifier() == Component.Identifier.Axis.POV) {
                        switch ((int)(8.0f * (event.getValue() - event.getComponent().getDeadZone()))) {
                            case 2: {
                                buttonName = "y";
                                buttonValue = -1;
                                break;
                            }
                            case 4: {
                                buttonName = "x";
                                buttonValue = 1;
                                break;
                            }
                            case 6: {
                                buttonName = "y";
                                buttonValue = 1;
                                break;
                            }
                            case 8: {
                                buttonName = "x";
                                buttonValue = -1;
                                break;
                            }
                            default: {
                                buttonName = "";
                                buttonValue = 0;
                                break;
                            }
                        }
                    } else {
                        buttonName = component.getIdentifier().getName();
                        buttonValue = InputUtil.getButtonValue();
                    }
                    ButtonID id = new ButtonID(controllerQueue.getInputDeviceID(), buttonName, buttonValue);
                    if (buttonValue == 0) {
                        buttonIds.add(id);
                    } else if (lastNanos == event.getNanos()) {
                        buttonID = id;
                    } else {
                        if (buttonID != null) {
                            buttonIds.add(buttonID);
                        }
                        buttonID = id;
                    }
                    lastNanos = event.getNanos();
                }
                if (buttonID == null) continue;
                buttonIds.add(buttonID);
                continue;
            }
            InputUtil.controllerQueues[i] = null;
        }
    }

    public static int[][] getPortDeviceOverrides() {
        return portDeviceOverrides;
    }

    public static void setPortDeviceOverrides(int[][] portDeviceOverrides) {
        InputUtil.portDeviceOverrides = portDeviceOverrides;
        InputUtil.handleSettingsChange();
    }

    public static void clearPortDeviceOverrides() {
        InputUtil.setPortDeviceOverrides(null);
    }

    public static boolean isMultitapOverride() {
        return multitapOverride;
    }

    public static int getConsoleOverride() {
        return consoleOverride;
    }

    public static void setOverrides(int consoleOverride, boolean multitapOverride) {
        InputUtil.consoleOverride = consoleOverride;
        InputUtil.multitapOverride = multitapOverride;
    }

    public static void clearOverrides() {
        InputUtil.clearPortDeviceOverrides();
        multitapOverride = false;
        consoleOverride = -1;
    }

    private static boolean isMouseAxis(Controller controller, Component component) {
        return controller.getType() == Controller.Type.MOUSE && component.getIdentifier() instanceof Component.Identifier.Axis;
    }

    public static int getButtons() {
        return buttons;
    }

    public static int getButtonValue() {
        float value = event.getValue() - event.getComponent().getDeadZone();
        if (value > 0.5f) {
            return 1;
        }
        if (value < -0.5f) {
            return -1;
        }
        return 0;
    }

    public static void addOtherInput(OtherInput otherInput) {
        otherInputs = CollectionsUtil.addElement(OtherInput.class, otherInputs, otherInput);
    }

    public static OtherInput[] getOtherInputs() {
        OtherInput[] others = otherInputs;
        otherInputs = null;
        return others;
    }

    static {
        ports = Ports.DEFAULTS;
        consoleOverride = -1;
    }
}

