/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.arkanoid;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.MathUtil;

public class ArkanoidMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[] KNOB_VALUES = new int[144];
    private final int portIndex;
    private final int shift;
    private final boolean famicom;
    private int buttons;
    private int shiftRegister;
    private int fire;
    private boolean strobe;

    public ArkanoidMapper(int portIndex) {
        this.portIndex = portIndex;
        this.shift = portIndex == 0 ? 0 : 8;
        this.famicom = portIndex == 4;
    }

    @Override
    public int getInputDevice() {
        return 5;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons;
    }

    @Override
    public void writePort(int value) {
        boolean bl = this.strobe = (value & 1) == 1;
        if (this.strobe) {
            this.shiftRegister = KNOB_VALUES[MathUtil.clamp((this.buttons >> 16 & 0xFF) - 32, 0, 143)];
            this.fire = this.buttons >> this.shift & 4;
            this.fire = this.famicom ? (this.fire >>= 1) : (this.fire <<= 1);
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (this.portIndex == portIndex) {
            if (this.famicom) {
                if (portIndex == 0) {
                    return this.fire;
                }
                if (!this.strobe) {
                    this.shiftRegister <<= 1;
                }
                return this.shiftRegister >> 7 & 2;
            }
            if (!this.strobe) {
                this.shiftRegister <<= 1;
            }
            return this.shiftRegister >> 4 & 0x10 | this.fire;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        if (this.portIndex == portIndex) {
            if (this.famicom) {
                if (portIndex == 0) {
                    return this.fire;
                }
                return this.shiftRegister >> 7 & 2;
            }
            return this.shiftRegister >> 4 & 0x10 | this.fire;
        }
        return 0;
    }

    @Override
    public void render(int[] screen) {
        int x = this.famicom ? 172 : 19 + 59 * this.portIndex;
        int y = 206;
        InputIcons.Arkanoid.render(screen, x, 206);
        if (this.fire != 0) {
            InputIcons.GamepadAB.render(screen, x + 31, 213);
        }
    }

    static {
        for (int i = KNOB_VALUES.length - 1; i >= 0; --i) {
            ArkanoidMapper.KNOB_VALUES[i] = ~(i * 146 / 143 + 84 + 14);
        }
    }
}

