/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.bandaihypershot;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;
import nintaco.input.Inputs;

public class BandaiHyperShotDescriptor
extends DeviceDescriptor {
    public static final int Trigger = 0;
    public static final int Grenade = 1;
    public static final int OffscreenReload = 2;
    public static final int Select = 3;
    public static final int Start = 4;
    public static final int Up = 5;
    public static final int Down = 6;
    public static final int Left = 7;
    public static final int Right = 8;
    public static final int RewindTime = 9;
    private static final Component.Identifier[] DEFAULTS = new Component.Identifier[]{Component.Identifier.Button.LEFT, Component.Identifier.Button.RIGHT, Component.Identifier.Button.MIDDLE, Component.Identifier.Key.APOSTROPHE, Component.Identifier.Key.RETURN, Component.Identifier.Key.UP, Component.Identifier.Key.DOWN, Component.Identifier.Key.LEFT, Component.Identifier.Key.RIGHT, Component.Identifier.Key.EQUALS};
    private volatile boolean allowImpossibleInput;

    public BandaiHyperShotDescriptor() {
        super(6);
    }

    @Override
    public void handleSettingsChange(Inputs inputs) {
        super.handleSettingsChange(inputs);
        this.allowImpossibleInput = inputs.isAllowImpossibleInput();
    }

    @Override
    public String getDeviceName() {
        return "Bandai Hyper Shot";
    }

    @Override
    public int getButtonCount() {
        return 10;
    }

    @Override
    public int getRewindTimeButton() {
        return 9;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Trigger";
            }
            case 1: {
                return "Grenade";
            }
            case 2: {
                return "Offscreen Reload";
            }
            case 3: {
                return "Select";
            }
            case 4: {
                return "Start";
            }
            case 5: {
                return "Up";
            }
            case 6: {
                return "Down";
            }
            case 7: {
                return "Left";
            }
            case 8: {
                return "Right";
            }
            case 9: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(buttonIndex <= 2 ? InputUtil.getDefaultMouse() : InputUtil.getDefaultKeyboard(), buttonIndex, DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        int deltaWheel = InputUtil.getMouseDeltaWheel();
        boolean up = deltaWheel > 0;
        boolean down = deltaWheel < 0;
        this.updateRewindTime(pressedValues[9] != 0, portIndex);
        int mouseCoordinates = InputUtil.getMouseCoordinates();
        int buttons = 0;
        if (this.allowImpossibleInput) {
            if (pressedValues[8] != 0) {
                buttons |= 0x80;
            }
            if (pressedValues[7] != 0) {
                buttons |= 0x40;
            }
            if (down || pressedValues[6] != 0) {
                buttons |= 0x20;
            }
            if (up || pressedValues[5] != 0) {
                buttons |= 0x10;
            }
        } else {
            if (pressedValues[8] > pressedValues[7]) {
                buttons |= 0x80;
            } else if (pressedValues[7] > pressedValues[8]) {
                buttons |= 0x40;
            }
            if (down || pressedValues[6] > pressedValues[5]) {
                buttons |= 0x20;
            } else if (up || pressedValues[5] > pressedValues[6]) {
                buttons |= 0x10;
            }
        }
        if (pressedValues[4] != 0) {
            buttons |= 8;
        }
        if (pressedValues[3] != 0) {
            buttons |= 4;
        }
        if (mouseCoordinates != 65535) {
            if (pressedValues[1] != 0) {
                buttons |= 2;
            }
            if (pressedValues[0] != 0) {
                buttons |= 1;
            } else if (pressedValues[2] != 0) {
                buttons |= 1;
                mouseCoordinates = 65535;
            }
        }
        return bits | mouseCoordinates << 16 | buttons << 8;
    }
}

