/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.familybasic;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import nintaco.App;
import nintaco.Machine;
import nintaco.MessageException;
import nintaco.PPU;
import nintaco.input.InputUtil;
import nintaco.input.familybasic.BasicLine;
import nintaco.input.other.PasteProgram;
import nintaco.mappers.Mapper;
import nintaco.util.MathUtil;
import nintaco.util.StringUtil;

public final class FamilyBasicUtil {
    private static final String[] TOKENS = new String[256];

    private FamilyBasicUtil() {
    }

    private static boolean isLetterOrNumber(int value) {
        return value >= 65 && value <= 90 || value >= 48 && value <= 57 || value >= 97 && value <= 122;
    }

    private static void extractToken(String line, int lineNumber, int start, Token token) throws MessageException {
        char c0 = FamilyBasicUtil.charAt(line, start);
        char c1 = FamilyBasicUtil.charAt(line, start + 1);
        if (c0 == '&' && (c1 == 'H' || c1 == 'h')) {
            FamilyBasicUtil.extractHex(line, lineNumber, start, token);
        } else if (c0 >= '0' && c0 <= '9') {
            if (token.type == TokenType.CHR && FamilyBasicUtil.isLetterOrNumber(token.value)) {
                FamilyBasicUtil.extractChr(line, lineNumber, start, token);
            } else {
                FamilyBasicUtil.extractDec(line, lineNumber, start, token);
            }
        } else if (c0 == '\"') {
            FamilyBasicUtil.extractStr(line, lineNumber, start, token);
        } else if (!FamilyBasicUtil.extractTkn(line, lineNumber, start, token)) {
            FamilyBasicUtil.extractChr(line, lineNumber, start, token);
        }
    }

    private static void extractChr(String line, int lineNumber, int start, Token token) throws MessageException {
        token.type = TokenType.CHR;
        token.next = start + 1;
        token.value = FamilyBasicUtil.charAt(line, start);
    }

    private static boolean extractTkn(String line, int lineNumber, int start, Token token) throws MessageException {
        line = line.toUpperCase(Locale.ENGLISH);
        block0: for (int i = 128; i <= 253; ++i) {
            String t = TOKENS[i];
            if (t == null) continue;
            char c = t.charAt(0);
            boolean isWord = c >= 'A' && c <= 'Z';
            int j = t.length() - 1;
            while (true) {
                if (line.startsWith(t, start)) {
                    token.type = TokenType.TKN;
                    token.str = TOKENS[i];
                    token.value = i;
                    token.next = start + t.length();
                    return true;
                }
                if (!isWord || j == 0) continue block0;
                t = TOKENS[i].substring(0, j) + ".";
                --j;
            }
        }
        return false;
    }

    private static void extractData(String line, int lineNumber, int start, Token token) throws MessageException {
        token.type = TokenType.DAT;
        token.next = line.length();
        StringBuffer sb = new StringBuffer();
        boolean insideString = false;
        for (int i = start; i < line.length(); ++i) {
            char c = FamilyBasicUtil.charAt(line, i);
            if (!insideString && c == ':') {
                token.next = i;
                break;
            }
            if (c == '\"') {
                insideString = !insideString;
            }
            sb.append(c);
        }
        token.str = sb.toString();
    }

    private static void extractRemark(String line, int lineNumber, int start, Token token) throws MessageException {
        token.type = TokenType.REM;
        token.next = line.length();
        token.str = line.substring(start);
    }

    private static void extractStr(String line, int lineNumber, int start, Token token) throws MessageException {
        StringBuffer sb = new StringBuffer();
        boolean endQuote = false;
        for (int i = start + 1; i < line.length(); ++i) {
            char c = FamilyBasicUtil.charAt(line, i);
            if (c == '\"') {
                endQuote = true;
                break;
            }
            sb.append(c);
        }
        token.type = TokenType.STR;
        token.str = sb.toString();
        token.value = endQuote ? 1 : 0;
        token.next = start + sb.length() + 2;
    }

    private static void extractDec(String line, int lineNumber, int start, Token token) throws MessageException {
        boolean error;
        char c;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 5 && (c = FamilyBasicUtil.charAt(line, start + i)) >= '0' && c <= '9'; ++i) {
            sb.append(c);
        }
        boolean bl = error = sb.length() == 0;
        if (!error) {
            token.type = TokenType.DEC;
            token.next = start + sb.length();
            try {
                token.value = Integer.parseInt(sb.toString());
            }
            catch (Throwable t) {
                error = true;
            }
            if (token.value < 0 || token.value > 32768) {
                throw new MessageException("%d: Decimal value out of range.", lineNumber);
            }
        }
        if (error) {
            throw new MessageException("%d: Invalid decimal value.", lineNumber);
        }
    }

    private static void extractHex(String line, int lineNumber, int start, Token token) throws MessageException {
        boolean error;
        char c;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4 && ((c = FamilyBasicUtil.charAt(line, start + 2 + i)) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f'); ++i) {
            sb.append(c);
        }
        boolean bl = error = sb.length() == 0;
        if (!error) {
            token.type = TokenType.HEX;
            token.next = start + 2 + sb.length();
            try {
                token.value = Integer.parseInt(sb.toString(), 16);
            }
            catch (Throwable t) {
                error = true;
            }
            if (token.value < 0 || token.value > 65535) {
                throw new MessageException("%d: Hexadecimal value out of range.", lineNumber);
            }
        }
        if (error) {
            throw new MessageException("%d: Invalid hexadecimal value.", lineNumber);
        }
    }

    private static char charAt(String line, int index) {
        if (index < 0 || index >= line.length()) {
            return '\u0000';
        }
        return line.charAt(index);
    }

    public static char hexToChar(int hexCode) {
        switch (hexCode) {
            case 0: {
                return '\u0000';
            }
            case 32: {
                return ' ';
            }
            case 33: {
                return '!';
            }
            case 34: {
                return '\"';
            }
            case 35: {
                return '#';
            }
            case 36: {
                return '$';
            }
            case 37: {
                return '%';
            }
            case 38: {
                return '&';
            }
            case 39: {
                return '\'';
            }
            case 40: {
                return '(';
            }
            case 41: {
                return ')';
            }
            case 42: {
                return '*';
            }
            case 43: {
                return '+';
            }
            case 44: {
                return ',';
            }
            case 45: {
                return '-';
            }
            case 46: {
                return '.';
            }
            case 47: {
                return '/';
            }
            case 48: {
                return '0';
            }
            case 49: {
                return '1';
            }
            case 50: {
                return '2';
            }
            case 51: {
                return '3';
            }
            case 52: {
                return '4';
            }
            case 53: {
                return '5';
            }
            case 54: {
                return '6';
            }
            case 55: {
                return '7';
            }
            case 56: {
                return '8';
            }
            case 57: {
                return '9';
            }
            case 58: {
                return ':';
            }
            case 59: {
                return ';';
            }
            case 60: {
                return '<';
            }
            case 61: {
                return '=';
            }
            case 62: {
                return '>';
            }
            case 63: {
                return '?';
            }
            case 64: {
                return '@';
            }
            case 65: {
                return 'A';
            }
            case 66: {
                return 'B';
            }
            case 67: {
                return 'C';
            }
            case 68: {
                return 'D';
            }
            case 69: {
                return 'E';
            }
            case 70: {
                return 'F';
            }
            case 71: {
                return 'G';
            }
            case 72: {
                return 'H';
            }
            case 73: {
                return 'I';
            }
            case 74: {
                return 'J';
            }
            case 75: {
                return 'K';
            }
            case 76: {
                return 'L';
            }
            case 77: {
                return 'M';
            }
            case 78: {
                return 'N';
            }
            case 79: {
                return 'O';
            }
            case 80: {
                return 'P';
            }
            case 81: {
                return 'Q';
            }
            case 82: {
                return 'R';
            }
            case 83: {
                return 'S';
            }
            case 84: {
                return 'T';
            }
            case 85: {
                return 'U';
            }
            case 86: {
                return 'V';
            }
            case 87: {
                return 'W';
            }
            case 88: {
                return 'X';
            }
            case 89: {
                return 'Y';
            }
            case 90: {
                return 'Z';
            }
            case 91: {
                return '\u300c';
            }
            case 92: {
                return '\u00a5';
            }
            case 93: {
                return '\u300d';
            }
            case 94: {
                return '^';
            }
            case 95: {
                return '_';
            }
            case 96: {
                return '\u30a2';
            }
            case 97: {
                return '\u30a4';
            }
            case 98: {
                return '\u30a6';
            }
            case 99: {
                return '\u30a8';
            }
            case 100: {
                return '\u30aa';
            }
            case 101: {
                return '\u30ab';
            }
            case 102: {
                return '\u30ad';
            }
            case 103: {
                return '\u30af';
            }
            case 104: {
                return '\u30b1';
            }
            case 105: {
                return '\u30b3';
            }
            case 106: {
                return '\u30b5';
            }
            case 107: {
                return '\u30b7';
            }
            case 108: {
                return '\u30b9';
            }
            case 109: {
                return '\u30bb';
            }
            case 110: {
                return '\u30bd';
            }
            case 111: {
                return '\u30bf';
            }
            case 112: {
                return '\u30c1';
            }
            case 113: {
                return '\u30c4';
            }
            case 114: {
                return '\u30c6';
            }
            case 115: {
                return '\u30c8';
            }
            case 116: {
                return '\u30ca';
            }
            case 117: {
                return '\u30cb';
            }
            case 118: {
                return '\u30cc';
            }
            case 119: {
                return '\u30cd';
            }
            case 120: {
                return '\u30ce';
            }
            case 121: {
                return '\u30cf';
            }
            case 122: {
                return '\u30d2';
            }
            case 123: {
                return '\u30d5';
            }
            case 124: {
                return '\u30d8';
            }
            case 125: {
                return '\u30db';
            }
            case 126: {
                return '\u30de';
            }
            case 127: {
                return '\u30df';
            }
            case 128: {
                return '\u30e0';
            }
            case 129: {
                return '\u30e1';
            }
            case 130: {
                return '\u30e2';
            }
            case 131: {
                return '\u30e4';
            }
            case 132: {
                return '\u30e6';
            }
            case 133: {
                return '\u30e8';
            }
            case 134: {
                return '\u30e9';
            }
            case 135: {
                return '\u30ea';
            }
            case 136: {
                return '\u30eb';
            }
            case 137: {
                return '\u30ec';
            }
            case 138: {
                return '\u30ed';
            }
            case 139: {
                return '\u30ef';
            }
            case 140: {
                return '\u30f3';
            }
            case 141: {
                return '\u30f2';
            }
            case 142: {
                return '\u30a1';
            }
            case 143: {
                return '\u30a3';
            }
            case 144: {
                return '\u30a5';
            }
            case 145: {
                return '\u30a7';
            }
            case 146: {
                return '\u30a9';
            }
            case 147: {
                return '\u30e3';
            }
            case 148: {
                return '\u30e5';
            }
            case 149: {
                return '\u30e7';
            }
            case 150: {
                return '\u30c3';
            }
            case 151: {
                return '\u30ac';
            }
            case 152: {
                return '\u30ae';
            }
            case 153: {
                return '\u30b0';
            }
            case 154: {
                return '\u30b2';
            }
            case 155: {
                return '\u30b4';
            }
            case 156: {
                return '\u30b6';
            }
            case 157: {
                return '\u30b8';
            }
            case 158: {
                return '\u30ba';
            }
            case 159: {
                return '\u30bc';
            }
            case 160: {
                return '\u30be';
            }
            case 161: {
                return '\u30c0';
            }
            case 162: {
                return '\u30c2';
            }
            case 163: {
                return '\u30c5';
            }
            case 164: {
                return '\u30c7';
            }
            case 165: {
                return '\u30c9';
            }
            case 166: {
                return '\u30d0';
            }
            case 167: {
                return '\u30d3';
            }
            case 168: {
                return '\u30d6';
            }
            case 169: {
                return '\u30d9';
            }
            case 170: {
                return '\u30dc';
            }
            case 171: {
                return '\u30d1';
            }
            case 172: {
                return '\u30d4';
            }
            case 173: {
                return '\u30d7';
            }
            case 174: {
                return '\u30da';
            }
            case 175: {
                return '\u30dd';
            }
            case 176: {
                return '\u25a1';
            }
            case 177: {
                return '\u3002';
            }
            case 178: {
                return '[';
            }
            case 179: {
                return ']';
            }
            case 180: {
                return '\u00a9';
            }
            case 181: {
                return '\u00d7';
            }
            case 182: {
                return '\u00f7';
            }
        }
        return '?';
    }

    public static int charToHex(char ch) {
        switch (ch) {
            case '\u0000': {
                return 0;
            }
            case ' ': {
                return 32;
            }
            case '!': {
                return 33;
            }
            case '\"': {
                return 34;
            }
            case '#': {
                return 35;
            }
            case '$': {
                return 36;
            }
            case '%': {
                return 37;
            }
            case '&': {
                return 38;
            }
            case '\'': {
                return 39;
            }
            case '(': {
                return 40;
            }
            case ')': {
                return 41;
            }
            case '*': {
                return 42;
            }
            case '+': {
                return 43;
            }
            case ',': {
                return 44;
            }
            case '-': {
                return 45;
            }
            case '.': {
                return 46;
            }
            case '/': {
                return 47;
            }
            case '0': {
                return 48;
            }
            case '1': {
                return 49;
            }
            case '2': {
                return 50;
            }
            case '3': {
                return 51;
            }
            case '4': {
                return 52;
            }
            case '5': {
                return 53;
            }
            case '6': {
                return 54;
            }
            case '7': {
                return 55;
            }
            case '8': {
                return 56;
            }
            case '9': {
                return 57;
            }
            case ':': 
            case '\uff1a': {
                return 58;
            }
            case ';': {
                return 59;
            }
            case '<': {
                return 60;
            }
            case '=': {
                return 61;
            }
            case '>': {
                return 62;
            }
            case '?': {
                return 63;
            }
            case '@': {
                return 64;
            }
            case 'A': 
            case 'a': {
                return 65;
            }
            case 'B': 
            case 'b': {
                return 66;
            }
            case 'C': 
            case 'c': {
                return 67;
            }
            case 'D': 
            case 'd': {
                return 68;
            }
            case 'E': 
            case 'e': {
                return 69;
            }
            case 'F': 
            case 'f': {
                return 70;
            }
            case 'G': 
            case 'g': {
                return 71;
            }
            case 'H': 
            case 'h': {
                return 72;
            }
            case 'I': 
            case 'i': {
                return 73;
            }
            case 'J': 
            case 'j': {
                return 74;
            }
            case 'K': 
            case 'k': {
                return 75;
            }
            case 'L': 
            case 'l': {
                return 76;
            }
            case 'M': 
            case 'm': {
                return 77;
            }
            case 'N': 
            case 'n': {
                return 78;
            }
            case 'O': 
            case 'o': {
                return 79;
            }
            case 'P': 
            case 'p': {
                return 80;
            }
            case 'Q': 
            case 'q': {
                return 81;
            }
            case 'R': 
            case 'r': {
                return 82;
            }
            case 'S': 
            case 's': {
                return 83;
            }
            case 'T': 
            case 't': {
                return 84;
            }
            case 'U': 
            case 'u': {
                return 85;
            }
            case 'V': 
            case 'v': {
                return 86;
            }
            case 'W': 
            case 'w': {
                return 87;
            }
            case 'X': 
            case 'x': {
                return 88;
            }
            case 'Y': 
            case 'y': {
                return 89;
            }
            case 'Z': 
            case 'z': {
                return 90;
            }
            case '\u300c': {
                return 91;
            }
            case '\u00a5': 
            case '\uffe5': {
                return 92;
            }
            case '\u300d': {
                return 93;
            }
            case '^': {
                return 94;
            }
            case '_': {
                return 95;
            }
            case '\u30a2': {
                return 96;
            }
            case '\u30a4': {
                return 97;
            }
            case '\u30a6': {
                return 98;
            }
            case '\u30a8': {
                return 99;
            }
            case '\u30aa': {
                return 100;
            }
            case '\u30ab': {
                return 101;
            }
            case '\u30ad': {
                return 102;
            }
            case '\u30af': {
                return 103;
            }
            case '\u30b1': {
                return 104;
            }
            case '\u30b3': {
                return 105;
            }
            case '\u30b5': {
                return 106;
            }
            case '\u30b7': {
                return 107;
            }
            case '\u30b9': {
                return 108;
            }
            case '\u30bb': {
                return 109;
            }
            case '\u30bd': {
                return 110;
            }
            case '\u30bf': {
                return 111;
            }
            case '\u30c1': {
                return 112;
            }
            case '\u30c4': {
                return 113;
            }
            case '\u30c6': {
                return 114;
            }
            case '\u30c8': {
                return 115;
            }
            case '\u30ca': {
                return 116;
            }
            case '\u30cb': {
                return 117;
            }
            case '\u30cc': {
                return 118;
            }
            case '\u30cd': {
                return 119;
            }
            case '\u30ce': {
                return 120;
            }
            case '\u30cf': {
                return 121;
            }
            case '\u30d2': {
                return 122;
            }
            case '\u30d5': {
                return 123;
            }
            case '\u30d8': {
                return 124;
            }
            case '\u30db': {
                return 125;
            }
            case '\u30de': {
                return 126;
            }
            case '\u30df': {
                return 127;
            }
            case '\u30e0': {
                return 128;
            }
            case '\u30e1': {
                return 129;
            }
            case '\u30e2': {
                return 130;
            }
            case '\u30e4': {
                return 131;
            }
            case '\u30e6': {
                return 132;
            }
            case '\u30e8': {
                return 133;
            }
            case '\u30e9': {
                return 134;
            }
            case '\u30ea': {
                return 135;
            }
            case '\u30eb': {
                return 136;
            }
            case '\u30ec': {
                return 137;
            }
            case '\u30ed': {
                return 138;
            }
            case '\u30ef': {
                return 139;
            }
            case '\u30f3': {
                return 140;
            }
            case '\u30f2': {
                return 141;
            }
            case '\u30a1': {
                return 142;
            }
            case '\u30a3': {
                return 143;
            }
            case '\u30a5': {
                return 144;
            }
            case '\u30a7': {
                return 145;
            }
            case '\u30a9': {
                return 146;
            }
            case '\u30e3': {
                return 147;
            }
            case '\u30e5': {
                return 148;
            }
            case '\u30e7': {
                return 149;
            }
            case '\u30c3': {
                return 150;
            }
            case '\u30ac': {
                return 151;
            }
            case '\u30ae': {
                return 152;
            }
            case '\u30b0': {
                return 153;
            }
            case '\u30b2': {
                return 154;
            }
            case '\u30b4': {
                return 155;
            }
            case '\u30b6': {
                return 156;
            }
            case '\u30b8': {
                return 157;
            }
            case '\u30ba': {
                return 158;
            }
            case '\u30bc': {
                return 159;
            }
            case '\u30be': {
                return 160;
            }
            case '\u30c0': {
                return 161;
            }
            case '\u30c2': {
                return 162;
            }
            case '\u30c5': {
                return 163;
            }
            case '\u30c7': {
                return 164;
            }
            case '\u30c9': {
                return 165;
            }
            case '\u30d0': {
                return 166;
            }
            case '\u30d3': {
                return 167;
            }
            case '\u30d6': {
                return 168;
            }
            case '\u30d9': {
                return 169;
            }
            case '\u30dc': {
                return 170;
            }
            case '\u30d1': {
                return 171;
            }
            case '\u30d4': {
                return 172;
            }
            case '\u30d7': {
                return 173;
            }
            case '\u30da': {
                return 174;
            }
            case '\u30dd': {
                return 175;
            }
            case '\u25a1': {
                return 176;
            }
            case '\u3002': {
                return 177;
            }
            case '[': {
                return 178;
            }
            case ']': {
                return 179;
            }
            case '\u00a9': {
                return 180;
            }
            case '\u00d7': {
                return 181;
            }
            case '\u00f7': {
                return 182;
            }
        }
        return -1;
    }

    public static String copyProgram() {
        int address;
        Machine machine = App.getMachine();
        if (machine == null) {
            return "";
        }
        Mapper mapper = machine.getMapper();
        int endAddress = MathUtil.clamp(mapper.peekWord(7) - 1, 24576, Short.MAX_VALUE);
        boolean version3 = address < 28672;
        StringBuilder sb = new StringBuilder();
        for (address = MathUtil.clamp(mapper.peekWord(5), 24576, Short.MAX_VALUE); address < endAddress; ++address) {
            boolean insideString = false;
            int lineLength = mapper.peekCpuMemory(address++) - 4;
            sb.append(String.format("%d ", mapper.peekWord(address)));
            int end = (address += 2) + lineLength;
            while (address < end) {
                int hex;
                String token;
                if (insideString) {
                    char c = FamilyBasicUtil.hexToChar(mapper.peekCpuMemory(address++));
                    sb.append(c);
                    if (c != '\"') continue;
                    insideString = false;
                    continue;
                }
                if ((token = TOKENS[hex = mapper.peekCpuMemory(address++)]) != null) {
                    sb.append(token);
                    continue;
                }
                if (version3 && hex >= 1 && hex <= 10) {
                    sb.append((char)(hex - 1 + 48));
                    continue;
                }
                if (hex == 17) {
                    sb.append(String.format("&H%X", mapper.peekWord(address)));
                    address += 2;
                    continue;
                }
                if (hex == 18 || hex == 11) {
                    sb.append(mapper.peekWord(address));
                    address += 2;
                    continue;
                }
                char c = FamilyBasicUtil.hexToChar(hex);
                sb.append(c);
                if (c != '\"') continue;
                insideString = true;
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void loadProgram(File file) throws MessageException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String input = null;
            while ((input = br.readLine()) != null) {
                sb.append(input).append('\n');
            }
        }
        catch (Throwable t) {
            throw new MessageException("Failed to load BASIC program.");
        }
        InputUtil.addOtherInput(new PasteProgram(sb.toString()));
    }

    public static void saveProgram(File file) throws MessageException {
        try (PrintStream out = new PrintStream(file);){
            out.print(FamilyBasicUtil.copyProgram().replace("\n", System.lineSeparator()));
        }
        catch (Throwable t) {
            throw new MessageException("Failed to save BASIC program.");
        }
    }

    public static void loadBackground(File file) throws MessageException {
        Machine machine = App.getMachine();
        if (machine == null || file == null || !file.exists() || file.length() != 1024L) {
            throw new MessageException("Failed to load background.");
        }
        PPU ppu = machine.getPPU();
        byte[] data = new byte[1024];
        try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
            in.readFully(data);
        }
        catch (Throwable t) {
            throw new MessageException("Failed to load background.");
        }
        for (int i = 1023; i >= 0; --i) {
            ppu.writeVRAM(0x2400 | i, data[i] & 0xFF);
        }
    }

    public static void saveBackground(File file) throws MessageException {
        Machine machine = App.getMachine();
        if (machine == null) {
            throw new MessageException("Failed to save background.");
        }
        PPU ppu = machine.getPPU();
        byte[] data = new byte[1024];
        for (int i = 1023; i >= 0; --i) {
            data[i] = (byte)ppu.peekVRAM(0x2400 | i);
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(data);
        }
        catch (Throwable t) {
            throw new MessageException("Failed to save background.");
        }
    }

    public static void pasteProgram(String program) throws MessageException {
        Machine machine = App.getMachine();
        if (machine == null) {
            return;
        }
        Mapper mapper = machine.getMapper();
        int address = mapper.peekWord(5);
        boolean version3 = address < 28672;
        String[] lines = program.split("\n|\r");
        ArrayList<BasicLine> basicLines = new ArrayList<BasicLine>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (StringUtil.isBlank(line)) continue;
            basicLines.add(FamilyBasicUtil.processLine(version3, i + 1, line));
        }
        Collections.sort(basicLines);
        int endSpaceAddress = mapper.peekWord(3) - 4;
        block1: for (BasicLine basicLine : basicLines) {
            for (int value : basicLine.getData()) {
                mapper.writeMemory(address++, value);
                if (address >= endSpaceAddress) continue block1;
            }
        }
        mapper.writeMemory(address, 0);
        mapper.writeMemory(address + 1, 0);
        mapper.writeMemory(address + 2, 0);
        mapper.writeMemory(address + 3, 0);
        mapper.writeWord(7, ++address);
        mapper.writeWord(29, address + 1);
        mapper.writeWord(31, address + 2);
    }

    private static BasicLine processLine(boolean version3, int fileIndex, String line) throws MessageException {
        char c;
        int index;
        ArrayList<Integer> data = new ArrayList<Integer>();
        int lineNumber = 0;
        line = line + '\u0000';
        for (index = 0; index < line.length() && (c = line.charAt(index)) >= '0' && c <= '9'; ++index) {
            lineNumber = 10 * lineNumber + c - 48;
        }
        if (index == 0) {
            throw new MessageException("%d: Line does not start with a line number.", fileIndex);
        }
        if (lineNumber < 0 || lineNumber > 65535) {
            throw new MessageException("%d: Invalid line number (%d).", fileIndex, lineNumber);
        }
        if (index == line.length()) {
            throw new MessageException("%d: Line only contains a line number.", fileIndex);
        }
        data.add(lineNumber & 0xFF);
        data.add(lineNumber >> 8 & 0xFF);
        if (line.charAt(index) == ' ') {
            ++index;
        }
        Token token = new Token();
        boolean valueIsLineNumber = false;
        while (index < line.length()) {
            FamilyBasicUtil.extractToken(line, lineNumber, index, token);
            block0 : switch (token.type) {
                case CHR: {
                    if (token.value == 63) {
                        data.add(139);
                        break;
                    }
                    if (token.value == 39) {
                        data.add(token.value);
                        FamilyBasicUtil.extractRemark(line, lineNumber, token.next, token);
                        FamilyBasicUtil.addString(data, token);
                        break;
                    }
                    if (token.value < 0) break;
                    data.add(FamilyBasicUtil.charToHex((char)token.value));
                    break;
                }
                case DEC: 
                case HEX: {
                    if (token.type != TokenType.HEX && !valueIsLineNumber && token.value <= 9 && version3) {
                        data.add(token.value + 1);
                        break;
                    }
                    data.add(valueIsLineNumber ? 11 : (token.type == TokenType.HEX ? 17 : 18));
                    data.add(token.value & 0xFF);
                    data.add(token.value >> 8 & 0xFF);
                    break;
                }
                case STR: {
                    data.add(FamilyBasicUtil.charToHex('\"'));
                    FamilyBasicUtil.addString(data, token);
                    if (token.value != 1) break;
                    data.add(FamilyBasicUtil.charToHex('\"'));
                    break;
                }
                case TKN: {
                    data.add(token.value);
                    valueIsLineNumber = token.value >= 128 && token.value <= 134;
                    switch (token.value) {
                        case 145: {
                            FamilyBasicUtil.extractData(line, lineNumber, token.next, token);
                            FamilyBasicUtil.addString(data, token);
                            break block0;
                        }
                        case 149: {
                            FamilyBasicUtil.extractRemark(line, lineNumber, token.next, token);
                            FamilyBasicUtil.addString(data, token);
                        }
                    }
                }
            }
            index = token.next;
        }
        data.add(0, data.size() + 1);
        int[] d = new int[data.size()];
        for (int i = d.length - 1; i >= 0; --i) {
            d[i] = (Integer)data.get(i);
        }
        return new BasicLine(lineNumber, d);
    }

    private static void addString(List<Integer> data, Token token) {
        for (int i = 0; i < token.str.length(); ++i) {
            int value = FamilyBasicUtil.charToHex(token.str.charAt(i));
            if (value < 0) continue;
            data.add(value);
        }
    }

    static {
        FamilyBasicUtil.TOKENS[128] = "GOTO";
        FamilyBasicUtil.TOKENS[129] = "GOSUB";
        FamilyBasicUtil.TOKENS[130] = "RUN";
        FamilyBasicUtil.TOKENS[131] = "RETURN";
        FamilyBasicUtil.TOKENS[132] = "RESTORE";
        FamilyBasicUtil.TOKENS[133] = "THEN";
        FamilyBasicUtil.TOKENS[134] = "LIST";
        FamilyBasicUtil.TOKENS[135] = "SYSTEM";
        FamilyBasicUtil.TOKENS[136] = "TO";
        FamilyBasicUtil.TOKENS[137] = "STEP";
        FamilyBasicUtil.TOKENS[138] = "SPRITE";
        FamilyBasicUtil.TOKENS[139] = "PRINT";
        FamilyBasicUtil.TOKENS[140] = "FOR";
        FamilyBasicUtil.TOKENS[141] = "NEXT";
        FamilyBasicUtil.TOKENS[142] = "PAUSE";
        FamilyBasicUtil.TOKENS[143] = "INPUT";
        FamilyBasicUtil.TOKENS[144] = "LINPUT";
        FamilyBasicUtil.TOKENS[145] = "DATA";
        FamilyBasicUtil.TOKENS[146] = "IF";
        FamilyBasicUtil.TOKENS[147] = "READ";
        FamilyBasicUtil.TOKENS[148] = "DIM";
        FamilyBasicUtil.TOKENS[149] = "REM";
        FamilyBasicUtil.TOKENS[150] = "STOP";
        FamilyBasicUtil.TOKENS[151] = "CONT";
        FamilyBasicUtil.TOKENS[152] = "CLS";
        FamilyBasicUtil.TOKENS[153] = "CLEAR";
        FamilyBasicUtil.TOKENS[154] = "ON";
        FamilyBasicUtil.TOKENS[155] = "OFF";
        FamilyBasicUtil.TOKENS[156] = "CUT";
        FamilyBasicUtil.TOKENS[157] = "NEW";
        FamilyBasicUtil.TOKENS[158] = "POKE";
        FamilyBasicUtil.TOKENS[159] = "CGSET";
        FamilyBasicUtil.TOKENS[160] = "VIEW";
        FamilyBasicUtil.TOKENS[161] = "MOVE";
        FamilyBasicUtil.TOKENS[162] = "END";
        FamilyBasicUtil.TOKENS[163] = "PLAY";
        FamilyBasicUtil.TOKENS[164] = "BEEP";
        FamilyBasicUtil.TOKENS[165] = "LOAD";
        FamilyBasicUtil.TOKENS[166] = "SAVE";
        FamilyBasicUtil.TOKENS[167] = "POSITION";
        FamilyBasicUtil.TOKENS[168] = "KEY";
        FamilyBasicUtil.TOKENS[169] = "COLOR";
        FamilyBasicUtil.TOKENS[170] = "DEF";
        FamilyBasicUtil.TOKENS[171] = "CGEN";
        FamilyBasicUtil.TOKENS[172] = "SWAP";
        FamilyBasicUtil.TOKENS[173] = "CALL";
        FamilyBasicUtil.TOKENS[174] = "LOCATE";
        FamilyBasicUtil.TOKENS[175] = "PALET";
        FamilyBasicUtil.TOKENS[176] = "ERA";
        FamilyBasicUtil.TOKENS[177] = "TR";
        FamilyBasicUtil.TOKENS[178] = "FIND";
        FamilyBasicUtil.TOKENS[179] = "GAME";
        FamilyBasicUtil.TOKENS[180] = "BGTOOL";
        FamilyBasicUtil.TOKENS[181] = "AUTO";
        FamilyBasicUtil.TOKENS[182] = "DELETE";
        FamilyBasicUtil.TOKENS[183] = "RENUM";
        FamilyBasicUtil.TOKENS[184] = "FILTER";
        FamilyBasicUtil.TOKENS[185] = "CLICK";
        FamilyBasicUtil.TOKENS[186] = "SCREEN";
        FamilyBasicUtil.TOKENS[187] = "BACKUP";
        FamilyBasicUtil.TOKENS[188] = "ERROR";
        FamilyBasicUtil.TOKENS[189] = "RESUME";
        FamilyBasicUtil.TOKENS[190] = "BGPUT";
        FamilyBasicUtil.TOKENS[191] = "BGGET";
        FamilyBasicUtil.TOKENS[192] = "CAN";
        FamilyBasicUtil.TOKENS[202] = "ABS";
        FamilyBasicUtil.TOKENS[203] = "ASC";
        FamilyBasicUtil.TOKENS[204] = "STR$";
        FamilyBasicUtil.TOKENS[205] = "FRE";
        FamilyBasicUtil.TOKENS[206] = "LEN";
        FamilyBasicUtil.TOKENS[207] = "PEEK";
        FamilyBasicUtil.TOKENS[208] = "RND";
        FamilyBasicUtil.TOKENS[209] = "SGN";
        FamilyBasicUtil.TOKENS[210] = "SPC";
        FamilyBasicUtil.TOKENS[211] = "TAB";
        FamilyBasicUtil.TOKENS[212] = "MID$";
        FamilyBasicUtil.TOKENS[213] = "STICK";
        FamilyBasicUtil.TOKENS[214] = "STRIG";
        FamilyBasicUtil.TOKENS[215] = "XPOS";
        FamilyBasicUtil.TOKENS[216] = "YPOS";
        FamilyBasicUtil.TOKENS[217] = "VAL";
        FamilyBasicUtil.TOKENS[218] = "POS";
        FamilyBasicUtil.TOKENS[219] = "CSRLIN";
        FamilyBasicUtil.TOKENS[220] = "CHR$";
        FamilyBasicUtil.TOKENS[221] = "HEX$";
        FamilyBasicUtil.TOKENS[222] = "INKEY$";
        FamilyBasicUtil.TOKENS[223] = "RIGHT$";
        FamilyBasicUtil.TOKENS[224] = "LEFT$";
        FamilyBasicUtil.TOKENS[225] = "SCR$";
        FamilyBasicUtil.TOKENS[226] = "INSTR";
        FamilyBasicUtil.TOKENS[227] = "CRASH";
        FamilyBasicUtil.TOKENS[228] = "ERR";
        FamilyBasicUtil.TOKENS[229] = "ERL";
        FamilyBasicUtil.TOKENS[230] = "VCT";
        FamilyBasicUtil.TOKENS[239] = "XOR";
        FamilyBasicUtil.TOKENS[240] = "OR";
        FamilyBasicUtil.TOKENS[241] = "AND";
        FamilyBasicUtil.TOKENS[242] = "NOT";
        FamilyBasicUtil.TOKENS[243] = "<>";
        FamilyBasicUtil.TOKENS[244] = ">=";
        FamilyBasicUtil.TOKENS[245] = "<=";
        FamilyBasicUtil.TOKENS[246] = "=";
        FamilyBasicUtil.TOKENS[247] = ">";
        FamilyBasicUtil.TOKENS[248] = "<";
        FamilyBasicUtil.TOKENS[249] = "+";
        FamilyBasicUtil.TOKENS[250] = "-";
        FamilyBasicUtil.TOKENS[251] = "MOD";
        FamilyBasicUtil.TOKENS[252] = "/";
        FamilyBasicUtil.TOKENS[253] = "*";
    }

    private static class Token {
        public int next;
        public TokenType type;
        public int value;
        public String str;

        private Token() {
        }
    }

    private static enum TokenType {
        CHR,
        HEX,
        DEC,
        STR,
        TKN,
        DAT,
        REM;

    }
}

