/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.familybasic.keyboard;

import nintaco.input.DeviceDescriptor;
import nintaco.util.StringUtil;

public class KeyboardPaster {
    private static final int RELEASED = 0;
    private static final int CHAR_PRESSED = 1;
    private static final int KANA_PRESSED = 2;
    private static final int MAX_LINE_LENGTH = 28;
    private final String str;
    private final int shortDelay;
    private final int longDelay;
    private int state = 0;
    private int index;
    private int lineLength;
    private int timer;
    private boolean kana;
    private boolean finished;

    public KeyboardPaster(String str, int shortDelay, int longDelay) {
        this.str = StringUtil.replaceNewlines(str);
        this.shortDelay = shortDelay;
        this.longDelay = longDelay;
    }

    public int type(int bits, int consoleType, int[] pressedValues) {
        if (this.timer > 0) {
            --this.timer;
        } else {
            this.timer = this.shortDelay;
            switch (this.state) {
                case 0: {
                    char c = this.str.charAt(this.index);
                    if (c <= '\u00ff' || c == '\uff1a') {
                        if (this.kana) {
                            DeviceDescriptor.Keyboard.setKanaEnabled(pressedValues, false);
                            this.state = 2;
                            this.kana = false;
                            break;
                        }
                        if (c == '\n' || ++this.lineLength == 28) {
                            this.lineLength = 0;
                            this.timer = this.longDelay;
                        }
                        DeviceDescriptor.Keyboard.pressKey(pressedValues, c);
                        this.state = 1;
                        break;
                    }
                    if (this.kana) {
                        if (++this.lineLength == 28) {
                            this.lineLength = 0;
                            this.timer = this.longDelay;
                        }
                        DeviceDescriptor.Keyboard.pressKey(pressedValues, c);
                        this.state = 1;
                        break;
                    }
                    DeviceDescriptor.Keyboard.setKanaEnabled(pressedValues, true);
                    this.state = 2;
                    this.kana = true;
                    break;
                }
                case 1: {
                    int newIndex = this.index + 1;
                    if (newIndex >= this.str.length()) {
                        DeviceDescriptor.Keyboard.setKanaEnabled(pressedValues, false);
                        this.finished = true;
                    } else {
                        this.index = newIndex;
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.state = 0;
                }
            }
        }
        return DeviceDescriptor.Keyboard.setButtonBits(bits, consoleType, 4, pressedValues);
    }

    public boolean isFinished() {
        return this.finished;
    }
}

