/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.gamepad;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;
import nintaco.input.Inputs;
import nintaco.input.gamepad.Autofire;

public abstract class GamepadDescriptor
extends DeviceDescriptor {
    public static final int A = 0;
    public static final int B = 1;
    public static final int Select = 2;
    public static final int Start = 3;
    public static final int Up = 4;
    public static final int Down = 5;
    public static final int Left = 6;
    public static final int Right = 7;
    public static final int AutofireA = 8;
    public static final int AutofireB = 9;
    public static final int ToggleAutofire = 10;
    public static final int RewindTime = 11;
    public static final int HighSpeed = 12;
    private final Autofire autofire = new Autofire(2);
    private final int rewindTimeIndex = this.getRewindTimeButton();
    private final int highSpeedIndex = this.getHighSpeedButton();
    private volatile boolean allowImpossibleInput;

    public GamepadDescriptor(int inputDevice) {
        super(inputDevice);
    }

    @Override
    public void handleSettingsChange(Inputs inputs) {
        super.handleSettingsChange(inputs);
        this.allowImpossibleInput = inputs.isAllowImpossibleInput();
        this.autofire.setRate(inputs.getAutofireRate() - 1);
    }

    @Override
    public int getButtonCount() {
        return 13;
    }

    @Override
    public int getRewindTimeButton() {
        return 11;
    }

    @Override
    public int getHighSpeedButton() {
        return 12;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "A";
            }
            case 1: {
                return "B";
            }
            case 2: {
                return "Select";
            }
            case 3: {
                return "Start";
            }
            case 4: {
                return "Up";
            }
            case 5: {
                return "Down";
            }
            case 6: {
                return "Left";
            }
            case 7: {
                return "Right";
            }
            case 8: {
                return "Autofire A";
            }
            case 9: {
                return "Autofire B";
            }
            case 10: {
                return "Toggle Autofire";
            }
            case 11: {
                return "Rewind Time";
            }
            case 12: {
                return "High Speed";
            }
        }
        return "Unknown";
    }

    protected ButtonMapping getDefaultButtonMapping(int buttonIndex, Component.Identifier[] defaults) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, defaults);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.autofire.setToggle(pressedValues[10] != 0);
        this.autofire.buttonStates[0].update(pressedValues[8] != 0, pressedValues[0] != 0);
        this.autofire.buttonStates[1].update(pressedValues[9] != 0, pressedValues[1] != 0);
        this.updateRewindTime(pressedValues[this.rewindTimeIndex] != 0, portIndex);
        this.updateHighSpeed(pressedValues[this.highSpeedIndex] != 0, portIndex);
        int buttons = 0;
        if (this.allowImpossibleInput) {
            if (pressedValues[7] != 0) {
                buttons |= 0x80;
            }
            if (pressedValues[6] != 0) {
                buttons |= 0x40;
            }
            if (pressedValues[5] != 0) {
                buttons |= 0x20;
            }
            if (pressedValues[4] != 0) {
                buttons |= 0x10;
            }
        } else {
            if (pressedValues[7] > pressedValues[6]) {
                buttons |= 0x80;
            } else if (pressedValues[6] > pressedValues[7]) {
                buttons |= 0x40;
            }
            if (pressedValues[5] > pressedValues[4]) {
                buttons |= 0x20;
            } else if (pressedValues[4] > pressedValues[5]) {
                buttons |= 0x10;
            }
        }
        if (consoleType != 1 || portIndex != 1) {
            if (pressedValues[3] != 0) {
                buttons |= 8;
            }
            if (pressedValues[2] != 0) {
                buttons |= 4;
            }
        }
        if (this.autofire.buttonStates[1].asserted || !this.autofire.enabled && pressedValues[1] != 0) {
            buttons |= 2;
        }
        if (this.autofire.buttonStates[0].asserted || !this.autofire.enabled && pressedValues[0] != 0) {
            buttons |= 1;
        }
        return bits | buttons << (portIndex << 3);
    }
}

