/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.konamihypershot;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class KonamiHyperShotMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int buttons;
    private int output;
    private boolean strobe;

    @Override
    public int getInputDevice() {
        return 19;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons >> 15 & 0x1E;
    }

    @Override
    public void writePort(int value) {
        boolean priorStrobe = this.strobe;
        this.strobe = BitUtil.getBitBool(value, 0);
        if (priorStrobe && !this.strobe) {
            this.output = this.buttons;
        }
    }

    @Override
    public int readPort(int portIndex) {
        return portIndex == 1 ? this.output : 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.readPort(portIndex);
    }

    @Override
    public void render(int[] screen) {
        int x1 = 140;
        int x2 = 204;
        int y = 202;
        InputIcons.KonamiHyperShot.render(screen, 140, 202);
        InputIcons.KonamiHyperShot.render(screen, 204, 202);
        if ((this.buttons & 2) != 0) {
            InputIcons.KonamiHyperShotButton.render(screen, 165, 212);
        }
        if ((this.buttons & 4) != 0) {
            InputIcons.KonamiHyperShotButton.render(screen, 148, 212);
        }
        if ((this.buttons & 8) != 0) {
            InputIcons.KonamiHyperShotButton.render(screen, 229, 212);
        }
        if ((this.buttons & 0x10) != 0) {
            InputIcons.KonamiHyperShotButton.render(screen, 212, 212);
        }
    }
}

