/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.miraclepiano;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Synthesizer;
import nintaco.CPU;
import nintaco.Machine;
import nintaco.apu.APU;
import nintaco.apu.SystemAudioProcessor;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;
import nintaco.util.MathUtil;

public class MiraclePianoMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[] GENERAL_MIDI_PATCHES = new int[]{0, 3, 2, 1, 6, 7, 18, 19, 25, 25, 24, 105, 107, 107, 26, 27, 29, 30, 28, 46, 6, 32, 36, 33, 4, 34, 99, 35, 33, 11, 11, 13, 12, 9, 108, 14, 114, 116, 48, 45, 49, 40, 46, 46, 60, 69, 57, 57, 59, 62, 63, 81, 58, 22, 73, 75, 82, 77, 71, 68, 70, 64, 112, 14, 112, 26, 27, 28, 4, 6, 2, 5, 127, 119, 117, 115, 113, 16, 17, 20, 6, 88, 89, 90, 91, 92, 93, 94, 95, 80, 82, 83, 84, 85, 86, 87, 14, 101, 105, 77, 0, 11, 2, 10, 6, 7, 18, 19, 25, 33, 24, 13, 12, 57, 56, 62, 63, 81, 14, 1, 11, 41, 44, 10, 34, 4, 6, 2};
    private static final int[] FIRMWARE_RESPONSE = new int[]{240, 0, 0, 66, 1, 5, 1, 0, 247};
    private static final int[][] KEY_COORDINATES = new int[][]{{1, 0}, {2, 2}, {4, 0}, {5, 2}, {7, 1}, {10, 0}, {11, 2}, {13, 0}, {14, 2}, {16, 0}, {17, 2}, {19, 1}};
    private static final int PERCUSSION_CHANNEL = 9;
    private static final int VELOCITY = 100;
    private static final int CONTROLLER_VOLUME = 7;
    private static final int CONTROLLER_DAMPER_PEDAL = 64;
    private static final int STATE_IDLE = 0;
    private static final int STATE_STROBED = 1;
    private static final int STATE_TRANSMIT = 2;
    private static final int STATE_RECEIVE = 3;
    private static final int TRANSMIT_DELAY = 40;
    private static final int QUEUE_CAPACITY = 1024;
    private static final Object SYNTHESIZER_MONITOR = new Object();
    private static volatile Synthesizer synthesizer;
    private static volatile MidiChannel[] channels;
    private volatile int[] queue = new int[1024];
    private int queueSize;
    private int head;
    private int tail;
    private int state;
    private int data;
    private int bitsTransmitted;
    private int bytesTransmitted;
    private int command;
    private int d1;
    private int d2;
    private int d3;
    private int mainVolume = 100;
    private int masterVolume = -1;
    private long strobeCycle;
    private long keysPressed;
    private boolean localControlEnabled = true;
    private volatile CPU cpu;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMidi() {
        Object object = SYNTHESIZER_MONITOR;
        synchronized (object) {
            try {
                if (synthesizer == null && (synthesizer = MidiSystem.getSynthesizer()) != null) {
                    synthesizer.open();
                    channels = synthesizer.getChannels();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public MiraclePianoMapper() {
        MiraclePianoMapper.initMidi();
        this.adjustVolume();
    }

    @Override
    public int getInputDevice() {
        return 21;
    }

    @Override
    public void setMachine(Machine machine) {
        this.cpu = machine == null ? null : machine.getCPU();
    }

    @Override
    public void update(int buttons) {
        int offset = 18 * (buttons >> 30 & 3);
        long pressed = this.keysPressed;
        pressed &= 0x3FFFFFL << offset ^ 0xFFFFFFFFFFFFFFFFL;
        long delta = (pressed |= (long)(buttons >> 8 & 0x3FFF00 | buttons & 0xFF) << offset) ^ this.keysPressed;
        this.keysPressed = pressed;
        if (this.localControlEnabled) {
            boolean p;
            if ((delta >> 49 & 1L) != 0L) {
                boolean sustain = (this.keysPressed >> 49 & 1L) != 0L;
                this.sustain(sustain);
                this.sendSustain(sustain);
            }
            if ((delta >> 52 & 1L) != 0L) {
                boolean bl = p = (this.keysPressed >> 52 & 1L) != 0L;
                if (p) {
                    this.patch(0);
                }
                this.sendButton(0, p);
            }
            if ((delta >> 53 & 1L) != 0L) {
                boolean bl = p = (this.keysPressed >> 53 & 1L) != 0L;
                if (p) {
                    this.patch(4);
                }
                this.sendButton(1, p);
            }
            if ((delta >> 54 & 1L) != 0L) {
                boolean bl = p = (this.keysPressed >> 54 & 1L) != 0L;
                if (p) {
                    this.patch(6);
                }
                this.sendButton(2, p);
            }
            if ((delta >> 55 & 1L) != 0L) {
                boolean bl = p = (this.keysPressed >> 55 & 1L) != 0L;
                if (p) {
                    this.patch(29);
                }
                this.sendButton(3, p);
            }
            if ((delta >> 56 & 1L) != 0L) {
                boolean bl = p = (this.keysPressed >> 56 & 1L) != 0L;
                if (p) {
                    this.patch(2);
                }
                this.sendButton(4, p);
            }
            if ((delta >> 57 & 1L) != 0L) {
                boolean bl = p = (this.keysPressed >> 57 & 1L) != 0L;
                if (p) {
                    this.patch(68);
                }
                this.sendButton(5, p);
            }
            if ((delta >> 50 & 1L) != 0L) {
                boolean bl = p = (this.keysPressed >> 50 & 1L) != 0L;
                if (p) {
                    this.increaseMainVolumeLevel();
                }
                this.sendButton(6, p);
            }
            if ((delta >> 51 & 1L) != 0L) {
                boolean bl = p = (this.keysPressed >> 51 & 1L) != 0L;
                if (p) {
                    this.decreaseMainVolumeLevel();
                }
                this.sendButton(7, p);
            }
            for (int key = 36; delta != 0L && key <= 84; ++key) {
                if ((delta & 1L) != 0L) {
                    if ((pressed & 1L) != 0L) {
                        this.playNote(key);
                        this.sendNoteOn(key);
                    } else {
                        this.stopNote(key);
                        this.sendNoteOff(key);
                    }
                }
                delta >>= 1;
                pressed >>= 1;
            }
        }
    }

    @Override
    public void writePort(int value) {
        value &= 1;
        switch (this.state) {
            case 0: 
            case 3: {
                if (value != 1) break;
                this.strobeCycle = this.getCycleCounter();
                this.state = 1;
                break;
            }
            case 1: {
                if (this.getCycleCounter() - this.strobeCycle >= 40L) {
                    this.state = 2;
                    this.bitsTransmitted = 0;
                    this.data = 0;
                    this.writePort(value);
                    break;
                }
                if (value != 0) break;
                this.state = 3;
                if (this.queueSize == 0) {
                    this.data = 0;
                    break;
                }
                this.data = (0xFF ^ BitUtil.reverseBits(this.queue[this.tail])) << 1 | 1;
                --this.queueSize;
                if (++this.tail != 1024) break;
                this.tail = 0;
                break;
            }
            case 2: {
                this.data = this.data << 1 | value;
                ++this.bitsTransmitted;
                if (this.bitsTransmitted == 8) {
                    this.handleTransmit();
                    break;
                }
                if (this.bitsTransmitted != 9) break;
                this.state = 0;
            }
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 0) {
            if (this.state == 3) {
                int value = this.data & 1;
                this.data >>= 1;
                return value;
            }
        } else {
            this.state = 0;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return portIndex == 0 && this.state == 3 ? this.data & 1 : 0;
    }

    @Override
    public void render(int[] screen) {
        int x = 137;
        int y = 196;
        InputIcons.Miracle.render(screen, 137, 196);
        long k = this.keysPressed;
        int o = 0;
        int offset = 0;
        int i = 0;
        while (i < 48) {
            if ((k & 1L) == 1L) {
                int T = KEY_COORDINATES[o][1];
                (T == 0 ? InputIcons.DoremikkoWhite1 : (T == 1 ? InputIcons.DoremikkoWhite2 : InputIcons.DoremikkoBlack)).render(screen, 137 + offset + KEY_COORDINATES[o][0], 209);
            }
            if (o == 11) {
                o = 0;
                offset += 21;
            } else {
                ++o;
            }
            ++i;
            k >>= 1;
        }
        if ((k & 1L) == 1L) {
            InputIcons.DoremikkoWhite2.render(screen, 222, 209);
        }
        if (((k >>= 1) & 1L) == 1L) {
            InputIcons.MiraclePedal.render(screen, 183, 198);
        }
        if (((k >>= 1) & 1L) == 1L) {
            InputIcons.MiracleUp.render(screen, 171, 198);
        }
        if (((k >>= 1) & 1L) == 1L) {
            InputIcons.MiracleDown.render(screen, 171, 203);
        }
        if (((k >>= 1) & 1L) == 1L) {
            InputIcons.MiracleButton.render(screen, 156, 198);
        }
        if (((k >>= 1) & 1L) == 1L) {
            InputIcons.MiracleButton.render(screen, 161, 198);
        }
        if (((k >>= 1) & 1L) == 1L) {
            InputIcons.MiracleButton.render(screen, 166, 198);
        }
        if (((k >>= 1) & 1L) == 1L) {
            InputIcons.MiracleButton.render(screen, 156, 203);
        }
        if (((k >>= 1) & 1L) == 1L) {
            InputIcons.MiracleButton.render(screen, 161, 203);
        }
        if (((k >>= 1) & 1L) == 1L) {
            InputIcons.MiracleButton.render(screen, 166, 203);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean saveNonVolatileData) {
        Object object = SYNTHESIZER_MONITOR;
        synchronized (object) {
            try {
                if (synthesizer != null) {
                    synthesizer.close();
                    synthesizer = null;
                }
                channels = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void playNote(int key) {
        MidiChannel[] cs = channels;
        if (cs != null) {
            MidiChannel c;
            int channel;
            int n = channel = key >= 60 ? 0 : 8;
            if (channel < cs.length && (c = cs[channel]) != null) {
                this.adjustVolume();
                c.noteOn(key, 100);
            }
        }
    }

    private void stopNote(int key) {
        MidiChannel[] cs = channels;
        if (cs != null) {
            MidiChannel c;
            int channel;
            int n = channel = key >= 60 ? 0 : 8;
            if (channel < cs.length && (c = cs[channel]) != null) {
                c.noteOff(key);
            }
        }
    }

    private void sendNoteOn(int key) {
        this.enqueue(144);
        this.enqueue(key);
        this.enqueue(100);
    }

    private void sendNoteOff(int key) {
        this.enqueue(144);
        this.enqueue(key);
        this.enqueue(0);
    }

    private void enqueue(int value) {
        if (this.queueSize < 1024) {
            ++this.queueSize;
            this.queue[this.head] = value;
            if (++this.head == 1024) {
                this.head = 0;
            }
        }
    }

    private long getCycleCounter() {
        CPU cpu = this.cpu;
        return cpu != null ? cpu.getCycleCounter() : 0L;
    }

    private void adjustVolume() {
        int volume;
        int n = volume = APU.isSoundEnabled() ? SystemAudioProcessor.getMasterVolume() : 0;
        if (volume != this.masterVolume) {
            this.masterVolume = volume;
            this.setMainVolumeLevel(this.mainVolume);
        }
    }

    private void handleTransmit() {
        block35: {
            block33: {
                block36: {
                    block34: {
                        ++this.bytesTransmitted;
                        if (this.bytesTransmitted != 1) break block33;
                        if (this.data >= 128 || (this.command & 0xF0) != 144) break block34;
                        this.bytesTransmitted = 2;
                        this.d1 = this.data;
                        break block35;
                    }
                    this.command = this.data;
                    if (this.command != 255) break block36;
                    this.bytesTransmitted = 0;
                    break block35;
                }
                switch (this.command & 0xF0) {
                    case 128: 
                    case 144: 
                    case 176: 
                    case 192: {
                        break;
                    }
                    default: {
                        if (this.command != 240) {
                            this.bytesTransmitted = 0;
                            break;
                        }
                        break block35;
                    }
                }
                break block35;
            }
            block3 : switch (this.command & 0xF0) {
                case 128: 
                case 144: {
                    if (this.bytesTransmitted == 2) {
                        this.d1 = this.data;
                        break;
                    }
                    this.bytesTransmitted = 0;
                    this.handleToggleNote();
                    break;
                }
                case 176: {
                    if (this.bytesTransmitted == 2) {
                        this.d1 = this.data;
                        break;
                    }
                    this.bytesTransmitted = 0;
                    switch (this.d1) {
                        case 7: {
                            this.handleMainVolumeLevel();
                            break;
                        }
                        case 64: {
                            this.handleToggleSustain();
                            break;
                        }
                        case 122: {
                            this.handleToggleLocalControl();
                            break;
                        }
                        case 123: {
                            this.handleDisableNotes();
                        }
                    }
                    break;
                }
                case 192: {
                    this.bytesTransmitted = 0;
                    this.handlePatchChange();
                    break;
                }
                case 240: {
                    switch (this.bytesTransmitted) {
                        case 2: 
                        case 3: {
                            if (this.data != 0) {
                                this.bytesTransmitted = 0;
                                break block3;
                            }
                            break block35;
                        }
                        case 4: {
                            if (this.data != 66) {
                                this.bytesTransmitted = 0;
                                break block3;
                            }
                            break block35;
                        }
                        case 5: {
                            if (this.data != 1) {
                                this.bytesTransmitted = 0;
                                break block3;
                            }
                            break block35;
                        }
                        case 6: {
                            this.d1 = this.data;
                            break block3;
                        }
                        case 7: {
                            if (this.d1 == 6) {
                                this.d1 = this.data;
                                break block3;
                            }
                            this.bytesTransmitted = 0;
                            if (this.d1 == 4) {
                                this.handleFirmwareVersionRequest();
                                break block3;
                            }
                            break block35;
                        }
                        case 8: {
                            this.d2 = this.data;
                            break block3;
                        }
                        case 9: {
                            this.d3 = this.data;
                            break block3;
                        }
                        case 10: {
                            this.bytesTransmitted = 0;
                            this.handlePatchSplit();
                        }
                    }
                }
            }
        }
    }

    private void handlePatchSplit() {
        this.handlePatchSplit(this.d1, this.d2, this.d3);
    }

    private void handlePatchSplit(int channel, int lowerPatch, int upperPatch) {
        MidiChannel[] cs = channels;
        if (cs != null) {
            MidiChannel c;
            int upperChannel;
            MidiChannel c2;
            int lowerChannel = channel & 7;
            if (lowerChannel < cs.length && (c2 = cs[lowerChannel]) != null) {
                c2.programChange(GENERAL_MIDI_PATCHES[lowerPatch & 0x7F]);
            }
            if ((upperChannel = lowerChannel | 8) != 9 && upperChannel < cs.length && (c = cs[upperChannel]) != null) {
                c.programChange(GENERAL_MIDI_PATCHES[upperPatch & 0x7F]);
            }
        }
    }

    private void patch(int patch) {
        this.handlePatchSplit(0, patch, patch);
    }

    private void sendButton(int button, boolean pressed) {
        if (pressed) {
            button |= 8;
        }
        this.enqueue(240);
        this.enqueue(0);
        this.enqueue(0);
        this.enqueue(66);
        this.enqueue(1);
        this.enqueue(1);
        this.enqueue(button);
        this.enqueue(247);
    }

    private void handleFirmwareVersionRequest() {
        for (int i = 0; i < FIRMWARE_RESPONSE.length; ++i) {
            this.enqueue(FIRMWARE_RESPONSE[i]);
        }
    }

    private void handleDisableNotes() {
        int channel = this.command & 7;
        MidiChannel[] cs = channels;
        if (cs != null) {
            MidiChannel c;
            if (channel < cs.length && (c = cs[channel]) != null) {
                c.allNotesOff();
            }
            if ((channel |= 8) != 9 && channel < cs.length && (c = cs[channel]) != null) {
                c.allNotesOff();
            }
        }
    }

    private void handleToggleLocalControl() {
        this.localControlEnabled = this.data != 0;
    }

    private void handleToggleSustain() {
        this.sustain(this.command, this.data);
    }

    private void sustain(boolean sustain) {
        this.sustain(0, sustain ? 127 : 0);
    }

    private void sustain(int channel, int sustain) {
        channel &= 7;
        sustain &= 0x7F;
        MidiChannel[] cs = channels;
        if (cs != null) {
            MidiChannel c;
            if (channel < cs.length && (c = cs[channel]) != null) {
                c.controlChange(64, sustain);
            }
            if ((channel |= 8) != 9 && channel < cs.length && (c = cs[channel]) != null) {
                c.controlChange(64, sustain);
            }
        }
    }

    private void sendSustain(boolean sustain) {
        this.enqueue(176);
        this.enqueue(64);
        this.enqueue(sustain ? 127 : 0);
    }

    private void handleMainVolumeLevel() {
        this.setMainVolumeLevel(this.data);
    }

    private void increaseMainVolumeLevel() {
        this.adjustMainVolumeLevel(13);
    }

    private void decreaseMainVolumeLevel() {
        this.adjustMainVolumeLevel(-13);
    }

    private void adjustMainVolumeLevel(int deltaVolume) {
        this.setMainVolumeLevel(MathUtil.clamp(this.mainVolume + deltaVolume, 0, 127));
    }

    private void setMainVolumeLevel(int volume) {
        this.mainVolume = volume & 0x7F;
        int v = MathUtil.clamp((int)((double)this.mainVolume * Math.sqrt((double)this.masterVolume / 100.0)), 0, 127);
        MidiChannel[] cs = channels;
        if (cs != null) {
            for (int i = cs.length - 1; i >= 0; --i) {
                MidiChannel c = cs[i];
                if (c == null) continue;
                c.controlChange(7, v);
            }
        }
    }

    private void handleToggleNote() {
        MidiChannel c;
        MidiChannel[] cs;
        int key = this.d1;
        int velocity = this.data;
        int channel = this.command & 7;
        if (key >= 60 && channel != 1) {
            channel |= 8;
        }
        if ((cs = channels) != null && channel < cs.length && (c = cs[channel]) != null) {
            if (velocity == 0 || (this.command & 0xF0) == 128) {
                c.noteOff(key);
            } else {
                this.adjustVolume();
                c.noteOn(key, velocity);
            }
        }
    }

    private void handlePatchChange() {
        this.handlePatchSplit(this.command, this.data, this.data);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.tail = 0;
        this.queueSize = this.readQueue(in, this.queue);
        this.head = this.queueSize == 1024 ? 0 : this.queueSize;
        MiraclePianoMapper.initMidi();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeQueue(out, this.queue, this.tail, this.queueSize);
    }

    private int readQueue(ObjectInputStream in, int[] queue) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            queue[i] = in.read();
        }
        return size;
    }

    private void writeQueue(ObjectOutputStream out, int[] queue, int tail, int size) throws IOException {
        out.writeInt(size);
        while (size > 0) {
            --size;
            out.write(queue[tail]);
            if (++tail != 1024) continue;
            tail = 0;
        }
    }
}

