/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.oekakids;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class OekaKidsDescriptor
extends DeviceDescriptor {
    public static final int Touch = 0;
    public static final int Click = 1;
    public static final int RewindTime = 2;
    private static final Component.Identifier[] DEFAULTS = new Component.Identifier[]{Component.Identifier.Key.X, Component.Identifier.Button.LEFT, Component.Identifier.Key.BACK};

    public OekaKidsDescriptor() {
        super(22);
    }

    @Override
    public String getDeviceName() {
        return "Oeka Kids Tablet";
    }

    @Override
    public int getButtonCount() {
        return 3;
    }

    @Override
    public int getRewindTimeButton() {
        return 2;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Touch";
            }
            case 1: {
                return "Click";
            }
            case 2: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(buttonIndex == 1 ? InputUtil.getDefaultMouse() : InputUtil.getDefaultKeyboard(), buttonIndex, DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[2] != 0, 0);
        int mouseCoordinates = InputUtil.getMouseCoordinates();
        int buttons = bits | mouseCoordinates << 16;
        return mouseCoordinates == 65535 ? buttons : buttons | (pressedValues[0] != 0 ? 2048 : 0) | (pressedValues[1] != 0 ? 1024 : 0);
    }
}

