/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.powerglove;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class PowerGloveDescriptor
extends DeviceDescriptor {
    public static final int PointFinger = 0;
    public static final int MakeFist = 1;
    public static final int Select = 2;
    public static final int Start = 3;
    public static final int MoveIn = 4;
    public static final int MoveOut = 5;
    public static final int RollLeft = 6;
    public static final int RollRight = 7;
    public static final int RewindTime = 8;
    private static final Component.Identifier[] DEFAULTS = new Component.Identifier[]{Component.Identifier.Button.LEFT, Component.Identifier.Button.RIGHT, Component.Identifier.Key.APOSTROPHE, Component.Identifier.Key.RETURN, Component.Identifier.Key.W, Component.Identifier.Key.S, Component.Identifier.Key.A, Component.Identifier.Key.D, Component.Identifier.Key.BACK};

    public PowerGloveDescriptor() {
        super(25);
    }

    @Override
    public String getDeviceName() {
        return "Power Glove";
    }

    @Override
    public int getButtonCount() {
        return 9;
    }

    @Override
    public int getRewindTimeButton() {
        return 8;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Point Finger";
            }
            case 1: {
                return "Make Fist";
            }
            case 2: {
                return "Select";
            }
            case 3: {
                return "Start";
            }
            case 4: {
                return "Move In";
            }
            case 5: {
                return "Move Out";
            }
            case 6: {
                return "Roll Left";
            }
            case 7: {
                return "Roll Right";
            }
            case 8: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(buttonIndex == 0 || buttonIndex == 1 ? InputUtil.getDefaultMouse() : InputUtil.getDefaultKeyboard(), buttonIndex, DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[8] != 0, portIndex);
        int buttons = 0;
        if (pressedValues[0] != 0) {
            buttons |= 1;
        }
        if (pressedValues[1] != 0) {
            buttons |= 2;
        }
        if (pressedValues[2] != 0) {
            buttons |= 4;
        }
        if (pressedValues[3] != 0) {
            buttons |= 8;
        }
        if (pressedValues[4] != 0) {
            buttons |= 0x10;
        }
        if (pressedValues[5] != 0) {
            buttons |= 0x20;
        }
        if (pressedValues[6] != 0) {
            buttons |= 0x40;
        }
        if (pressedValues[7] != 0) {
            buttons |= 0x80;
        }
        return bits | InputUtil.getMouseCoordinates() << 16 | (portIndex == 0 ? buttons : buttons << 8);
    }
}

