/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.taptapmat;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;

public class TapTapMatMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int buttons;
    private int output = 30;

    @Override
    public int getInputDevice() {
        return 31;
    }

    @Override
    public void update(int buttons) {
        this.buttons = ~buttons;
    }

    @Override
    public void writePort(int value) {
        int row = ~value & 7;
        this.output = 0;
        if (BitUtil.getBitBool(row, 2)) {
            this.output |= this.buttons >> 23 & 0x1E;
        }
        if (BitUtil.getBitBool(row, 1)) {
            this.output |= this.buttons >> 19 & 0x1E;
        }
        if (BitUtil.getBitBool(row, 0)) {
            this.output |= this.buttons >> 15 & 0x1E;
        }
    }

    @Override
    public int readPort(int portIndex) {
        return portIndex == 1 ? this.output : 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.readPort(portIndex);
    }

    @Override
    public void render(int[] screen) {
        int x = 179;
        int y = 206;
        InputIcons.TapTapMat.render(screen, 179, 206);
        if (!BitUtil.getBitBool(this.buttons, 24)) {
            InputIcons.GamepadAB.render(screen, 181, 208);
        }
        if (!BitUtil.getBitBool(this.buttons, 25)) {
            InputIcons.GamepadAB.render(screen, 187, 208);
        }
        if (!BitUtil.getBitBool(this.buttons, 26)) {
            InputIcons.GamepadAB.render(screen, 193, 208);
        }
        if (!BitUtil.getBitBool(this.buttons, 27)) {
            InputIcons.GamepadAB.render(screen, 199, 208);
        }
        if (!BitUtil.getBitBool(this.buttons, 20)) {
            InputIcons.GamepadAB.render(screen, 181, 214);
        }
        if (!BitUtil.getBitBool(this.buttons, 21)) {
            InputIcons.GamepadAB.render(screen, 187, 214);
        }
        if (!BitUtil.getBitBool(this.buttons, 22)) {
            InputIcons.GamepadAB.render(screen, 193, 214);
        }
        if (!BitUtil.getBitBool(this.buttons, 23)) {
            InputIcons.GamepadAB.render(screen, 199, 214);
        }
        if (!BitUtil.getBitBool(this.buttons, 16)) {
            InputIcons.GamepadAB.render(screen, 181, 220);
        }
        if (!BitUtil.getBitBool(this.buttons, 17)) {
            InputIcons.GamepadAB.render(screen, 187, 220);
        }
        if (!BitUtil.getBitBool(this.buttons, 18)) {
            InputIcons.GamepadAB.render(screen, 193, 220);
        }
        if (!BitUtil.getBitBool(this.buttons, 19)) {
            InputIcons.GamepadAB.render(screen, 199, 220);
        }
    }
}

