/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.zapper;

import java.io.Serializable;
import nintaco.Machine;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.mappers.Mapper;
import nintaco.tv.TVSystem;

public class ZapperMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected static final int PHOTO_SENSOR_SCANLINES = 26;
    protected final int shift;
    protected final int portIndex;
    protected Mapper mapper;
    protected TVSystem tvSystem;
    protected int triggerScanlines;
    protected boolean triggerPulled;
    protected boolean triggerReleased = true;
    protected boolean offscreen;
    protected int coordinates;
    protected int photoSensor;
    protected int trigger;
    protected int portValue;
    protected boolean expansionPort;

    public ZapperMapper(int portIndex) {
        if (portIndex == 4) {
            this.expansionPort = true;
        }
        if (portIndex == 0) {
            this.shift = 0;
            this.portIndex = 0;
        } else {
            this.shift = 8;
            this.portIndex = 1;
        }
    }

    @Override
    public void setMachine(Machine machine) {
        this.mapper = machine.getMapper();
        machine.getPPU().setZapper(this);
    }

    @Override
    public int getInputDevice() {
        return 4;
    }

    public int getShift() {
        return this.shift;
    }

    public void handleLightDetected() {
        this.photoSensor = 26;
        this.updatePortValue();
    }

    public void handleScanline() {
        if (this.trigger > 0 && --this.trigger == 0) {
            this.offscreen = false;
        }
        if (this.photoSensor > 0) {
            --this.photoSensor;
        }
        this.updatePortValue();
    }

    protected void updatePortValue() {
        this.portValue = 0;
        if (this.trigger != 0) {
            this.portValue |= 0x10;
        }
        if (this.photoSensor == 0 && !this.offscreen) {
            this.portValue |= 8;
        }
    }

    @Override
    public void update(int buttons) {
        this.triggerPulled = (buttons >> this.shift & 4) != 0;
        this.coordinates = buttons >> 16 & 0xFFFF;
        if (this.triggerPulled) {
            TVSystem system = this.mapper.getTVSystem();
            if (this.tvSystem != system) {
                this.tvSystem = system;
                this.triggerScanlines = (int)Math.round((double)system.getScanlineCount() / (10.0 * system.getSecondsPerFrame()));
            }
            if (this.triggerReleased) {
                this.triggerReleased = false;
                this.trigger = this.triggerScanlines;
                this.offscreen = this.coordinates == 65535;
            }
        } else {
            this.triggerReleased = true;
        }
        if (this.offscreen) {
            this.coordinates = 65535;
        }
        this.updatePortValue();
    }

    public boolean isTrigger() {
        return this.trigger > 0;
    }

    public int getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void writePort(int value) {
    }

    @Override
    public int readPort(int portIndex) {
        return this.portIndex == portIndex ? this.portValue : 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return this.readPort(portIndex);
    }

    @Override
    public void render(int[] screen) {
        int x = this.expansionPort ? 169 : 8 + (this.portIndex << 6);
        int y = 205;
        InputIcons.Zapper.render(screen, x, 205);
        if (this.triggerPulled) {
            InputIcons.ZapperTrigger.render(screen, x + 14, 213);
        }
        int X = this.coordinates & 0xFF;
        int Y = this.coordinates >> 8 & 0xFF;
        if (Y < 240) {
            InputIcons.ZapperTarget.renderSafe(screen, X - 7, Y - 7);
        }
    }
}

