/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.bandai;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class KaraokeStudio
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final boolean expansionRomPresent;
    private boolean internalRomSelected;

    public KaraokeStudio(CartFile cartFile) {
        super(cartFile, 4, 1);
        this.expansionRomPresent = cartFile.getPrgRomLength() >= 262144;
    }

    @Override
    public void init() {
        this.setPrgBank(2, 0);
        this.setPrgBank(3, 7);
        this.setChrBank(0);
        this.internalRomSelected = true;
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xE000) == 24576) {
            return this.readMicrophone();
        }
        if (!this.expansionRomPresent && !this.internalRomSelected && (address & 0xC000) == 32768) {
            return 0;
        }
        return super.readMemory(address);
    }

    private int readMicrophone() {
        return 3;
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.internalRomSelected = BitUtil.getBitBool(value, 4);
        if (this.internalRomSelected) {
            this.setPrgBank(2, value & 7);
        } else if (this.expansionRomPresent) {
            this.setPrgBank(2, 8 | value & 7);
        }
        this.setNametableMirroring(BitUtil.getBit(value, 5));
    }
}

