/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.carson;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Carson
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int prgRegister;
    private int copyProtection;

    public Carson(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void setPrgBank(int bank, int value) {
        if (BitUtil.getBitBool(this.prgRegister, 7)) {
            if (BitUtil.getBitBool(this.prgRegister, 5)) {
                int B = (this.prgRegister & 0xE) << 1;
                super.setPrgBank(4, B);
                super.setPrgBank(5, B | 1);
                super.setPrgBank(6, B | 2);
                super.setPrgBank(7, B | 3);
            } else {
                int B = (this.prgRegister & 0xF) << 1;
                super.setPrgBank(4, B);
                super.setPrgBank(5, B | 1);
                super.setPrgBank(6, B);
                super.setPrgBank(7, B | 1);
            }
        } else {
            super.setPrgBank(bank, value);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address >= 32768) {
            this.writeRegister(address, value);
        } else if (address >= 16640) {
            switch (address) {
                case 20608: {
                    this.copyProtection = value;
                    break;
                }
                case 24576: {
                    this.prgRegister = value;
                    break;
                }
                case 24577: {
                    this.setChrBlockOffset((value & 1) << 8);
                }
            }
            this.updatePrgBanks();
        }
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xF000) == 20480) {
            return this.copyProtection;
        }
        return super.readMemory(address);
    }
}

