/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.carson;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper291
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private boolean mmc3Mode;

    public Mapper291(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.writeOuterBank(0);
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void writeOuterBank(int value) {
        boolean bl = this.mmc3Mode = !BitUtil.getBitBool(value, 5);
        if (this.mmc3Mode) {
            this.setPrgBlock((value & 0x40) >> 2, 15);
        } else {
            this.setPrgBlock(0, -1);
            this.set4PrgBanks(4, ((value & 0x40) >> 3 | value & 6) << 1);
        }
        this.setChrBlock((value & 0x40) << 2, 255);
    }

    @Override
    public void updatePrgBanks() {
        if (this.mmc3Mode) {
            super.updatePrgBanks();
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE000) == 24576) {
            this.writeOuterBank(value);
        }
        super.writeMemory(address, value);
    }
}

