/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.daouinfosys;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class DaouInfosys
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] chrLow = new int[8];
    private final int[] chrHigh = new int[8];

    public DaouInfosys(CartFile cartFile) {
        super(cartFile, 4, 8, 49152, 32768);
    }

    @Override
    public void init() {
        this.setPrgBank(3, -1);
        this.setNametableMirroring(2);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address < 49168) {
            int bank = (address & 8) >> 1 | address & 3;
            if (BitUtil.getBitBool(address, 2)) {
                this.chrHigh[bank] = value << 8;
            } else {
                this.chrLow[bank] = value;
            }
            this.setChrBank(bank, this.chrHigh[bank] | this.chrLow[bank]);
        } else if (address == 49168) {
            this.setPrgBank(2, value);
        } else if (address == 49172) {
            this.setNametableMirroring(BitUtil.getBit(value, 0));
        }
    }
}

