/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jy;

import nintaco.files.CartFile;
import nintaco.mappers.jy.JY;
import nintaco.mappers.nintendo.fds.FdsAudio;

public class Mapper295
extends JY {
    private static final long serialVersionUID = 0L;
    private final FdsAudio audio = new FdsAudio();
    protected int prgBlockOffset;
    protected int chrBlockOffset;

    public Mapper295(CartFile cartFile) {
        super(cartFile, 295);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        super.setPrgBank(bank, this.prgBlockOffset | value & 0xF);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        super.setChrBank(bank, this.chrBlockOffset | value & 0x7F);
    }

    @Override
    public int readMemory(int address) {
        int value = this.audio.readRegister(address);
        return value >= 0 ? value : super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (!this.audio.writeRegister(address, value) && (address & 0xF003) == 53251) {
            this.prgBlockOffset = (value &= 7) << 4;
            this.chrBlockOffset = value << 7;
            this.updatePrgBanks();
            this.updateChrBanks();
        }
        super.writeMemory(address, value);
    }

    @Override
    public void update() {
        this.audio.update();
        super.update();
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }
}

