/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jy;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper364
extends MMC3 {
    private static final long serialVersionUID = 0L;

    public Mapper364(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.writeOuterBankRegister(0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void writeOuterBankRegister(int value) {
        this.setPrgBlock((value & 0x40) >> 1, BitUtil.getBitBool(value, 5) ? 15 : 31);
        this.setChrBlock((value & 0x10) << 4, BitUtil.getBitBool(value, 5) ? 127 : 255);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xF000) == 28672) {
            this.writeOuterBankRegister(value);
        }
        super.writeMemory(address, value);
    }
}

