/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.kaiser;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Kaiser7016
extends Mapper {
    private static final long serialVersionUID = 0L;

    public Kaiser7016(CartFile cartFile) {
        super(cartFile, 8, 1, 32768, 24576);
    }

    @Override
    public void init() {
        this.setPrgBank(3, 8);
        this.set4PrgBanks(4, 12);
        this.setChrBank(0);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xD943) {
            case 55619: {
                if ((address & 0x30) == 48) {
                    this.setPrgBank(3, 11);
                    break;
                }
                this.setPrgBank(3, address >> 2 & 0xF);
                break;
            }
            case 55555: {
                if ((address & 0x30) == 48) {
                    this.setPrgBank(3, 8 | address >> 2 & 3);
                    break;
                }
                this.setPrgBank(3, 11);
            }
        }
    }
}

